/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.idp;

import com.jxdinfo.hussar.authorization.organ.service.IHussarBaseStaffBoService;
import com.jxdinfo.hussar.authorization.organ.vo.StaffBo;
import com.jxdinfo.hussar.authorization.permit.model.SysRoles;
import com.jxdinfo.hussar.authorization.permit.model.SysUserRole;
import com.jxdinfo.hussar.authorization.permit.model.SysUsers;
import com.jxdinfo.hussar.authorization.permit.service.ISysRolesService;
import com.jxdinfo.hussar.authorization.permit.service.ISysUserRoleService;
import com.jxdinfo.hussar.authorization.permit.service.ISysUsersService;
import com.jxdinfo.hussar.common.security.BaseSecurityUtil;
import com.jxdinfo.hussar.common.security.SecurityUser;
import com.jxdinfo.hussar.support.datasource.annotations.HussarTokenDs;
import com.jxdinfo.hussar.support.exception.HussarException;
import com.jxdinfo.idp.common.user.entity.SysRolesVo;
import com.jxdinfo.idp.common.user.entity.SysUserRoleVo;
import com.jxdinfo.idp.common.user.entity.SysUsersVo;
import com.jxdinfo.idp.common.user.entity.UserLoginInfo;
import com.jxdinfo.idp.common.user.service.UserLoginService;
import java.lang.reflect.InvocationTargetException;
import java.util.ArrayList;
import java.util.List;
import javax.annotation.Resource;
import org.apache.commons.beanutils.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service(value="service.UserLoginServiceImpl")
@HussarTokenDs
public class UserLoginServiceImpl
implements UserLoginService {
    @Autowired
    private IHussarBaseStaffBoService iHussarBaseStaffBoService;
    @Resource
    private ISysUsersService sysUsersService;
    @Resource
    private ISysUserRoleService sysUserRoleService;
    @Resource
    private ISysRolesService sysRolesService;

    public UserLoginInfo getUserLoginInfoByUserId(Long userId) {
        UserLoginInfo userLoginInfo = new UserLoginInfo();
        if (userId == null) {
            throw new HussarException("\u4f20\u5165\u7684\u7528\u6237id\u4e3a\u7a7a\uff01");
        }
        StaffBo staffBo = this.iHussarBaseStaffBoService.findStaffByUserId(userId);
        if (staffBo != null) {
            try {
                BeanUtils.copyProperties((Object)userLoginInfo, (Object)staffBo);
            }
            catch (IllegalAccessException | InvocationTargetException e) {
                throw new RuntimeException(e);
            }
        }
        return userLoginInfo;
    }

    public UserLoginInfo getUserLoginInfoByStaffId(Long staffId) {
        UserLoginInfo userLoginInfo = new UserLoginInfo();
        if (staffId == null) {
            throw new HussarException("\u4f20\u5165\u7684\u4eba\u5458id\u4e3a\u7a7a\uff01");
        }
        StaffBo staffBo = this.iHussarBaseStaffBoService.findStaffByStaffId(staffId);
        if (staffBo != null) {
            try {
                BeanUtils.copyProperties((Object)userLoginInfo, (Object)staffBo);
            }
            catch (IllegalAccessException | InvocationTargetException e) {
                throw new RuntimeException(e);
            }
        }
        return userLoginInfo;
    }

    public Long getUserId() {
        SecurityUser user = BaseSecurityUtil.getUser();
        if (user == null) {
            throw new HussarException("\u83b7\u53d6\u7528\u6237\u767b\u5f55\u4fe1\u606f\u5931\u8d25\uff01");
        }
        return user.getUserId();
    }

    public SysUsersVo getUser() {
        SecurityUser user = BaseSecurityUtil.getUser();
        if (user == null) {
            throw new HussarException("\u83b7\u53d6\u7528\u6237\u767b\u5f55\u4fe1\u606f\u5931\u8d25\uff01");
        }
        SysUsersVo sysUsersVo = new SysUsersVo(user.getId(), user.getAccount(), user.getName());
        return sysUsersVo;
    }

    public List<UserLoginInfo> findStaffsByStaffIds(List<Long> ids) {
        if (ids == null || ids.isEmpty()) {
            throw new HussarException("\u4f20\u5165\u4eba\u5458\u7684Id\u96c6\u5408\u4e3a\u7a7a\uff01");
        }
        ArrayList<UserLoginInfo> result = new ArrayList<UserLoginInfo>();
        List staffBoList = this.iHussarBaseStaffBoService.findStaffsByStaffIds(ids);
        if (staffBoList != null && !staffBoList.isEmpty()) {
            for (StaffBo staffBo : staffBoList) {
                try {
                    UserLoginInfo userLoginInfo = new UserLoginInfo();
                    BeanUtils.copyProperties((Object)userLoginInfo, (Object)staffBo);
                    result.add(userLoginInfo);
                }
                catch (IllegalAccessException | InvocationTargetException e) {
                    throw new RuntimeException(e);
                }
            }
        }
        return result;
    }

    public List<UserLoginInfo> findStaffsByUserIds(List<Long> ids) {
        if (ids == null || ids.isEmpty()) {
            throw new HussarException("\u4f20\u5165\u7528\u6237\u7684Id\u96c6\u5408\u4e3a\u7a7a\uff01");
        }
        ArrayList<UserLoginInfo> result = new ArrayList<UserLoginInfo>();
        List staffBoList = this.iHussarBaseStaffBoService.findStaffsByUserIds(ids);
        if (staffBoList != null && !staffBoList.isEmpty()) {
            for (StaffBo staffBo : staffBoList) {
                try {
                    UserLoginInfo userLoginInfo = new UserLoginInfo();
                    BeanUtils.copyProperties((Object)userLoginInfo, (Object)staffBo);
                    result.add(userLoginInfo);
                }
                catch (IllegalAccessException | InvocationTargetException e) {
                    throw new RuntimeException(e);
                }
            }
        }
        return result;
    }

    public UserLoginInfo findStaffByUserAccount(String account) {
        UserLoginInfo userLoginInfo = new UserLoginInfo();
        if (account == null || account.isEmpty()) {
            throw new HussarException("\u4f20\u5165\u7528\u6237\u7684\u8d26\u53f7\u4e3a\u7a7a\uff01");
        }
        StaffBo staffBo = this.iHussarBaseStaffBoService.findStaffByUserAccount(account);
        if (staffBo != null) {
            try {
                BeanUtils.copyProperties((Object)userLoginInfo, (Object)staffBo);
            }
            catch (IllegalAccessException | InvocationTargetException e) {
                throw new RuntimeException(e);
            }
        }
        return userLoginInfo;
    }

    public List<UserLoginInfo> findStaffsByUserAccounts(List<String> accounts) {
        if (accounts == null || accounts.isEmpty()) {
            throw new HussarException("\u4f20\u5165\u7684\u7528\u6237\u8d26\u6237\u96c6\u5408\u4e3a\u7a7a\uff01");
        }
        ArrayList<UserLoginInfo> result = new ArrayList<UserLoginInfo>();
        List staffBoList = this.iHussarBaseStaffBoService.findStaffsByUserAccounts(accounts);
        if (staffBoList != null && !staffBoList.isEmpty()) {
            for (StaffBo staffBo : staffBoList) {
                try {
                    UserLoginInfo userLoginInfo = new UserLoginInfo();
                    BeanUtils.copyProperties((Object)userLoginInfo, (Object)staffBo);
                    result.add(userLoginInfo);
                }
                catch (IllegalAccessException | InvocationTargetException e) {
                    throw new RuntimeException(e);
                }
            }
        }
        return result;
    }

    public UserLoginInfo findStaffByStaffCode(String code) {
        UserLoginInfo userLoginInfo = new UserLoginInfo();
        if (code == null || code.isEmpty()) {
            throw new HussarException("\u4f20\u5165\u7684\u4eba\u5458\u7f16\u7801\u4e3a\u7a7a\uff01");
        }
        StaffBo staffBo = this.iHussarBaseStaffBoService.findStaffByStaffCode(code);
        if (staffBo != null) {
            try {
                BeanUtils.copyProperties((Object)userLoginInfo, (Object)staffBo);
            }
            catch (IllegalAccessException | InvocationTargetException e) {
                throw new RuntimeException(e);
            }
        }
        return userLoginInfo;
    }

    public List<UserLoginInfo> findStaffsByStaffCodes(List<String> codes) {
        if (codes == null || codes.isEmpty()) {
            throw new HussarException("\u4f20\u5165\u7684\u7528\u6237\u8d26\u6237\u96c6\u5408\u4e3a\u7a7a\uff01");
        }
        ArrayList<UserLoginInfo> result = new ArrayList<UserLoginInfo>();
        List staffBoList = this.iHussarBaseStaffBoService.findStaffsByStaffCodes(codes);
        if (staffBoList != null && !staffBoList.isEmpty()) {
            for (StaffBo staffBo : staffBoList) {
                try {
                    UserLoginInfo userLoginInfo = new UserLoginInfo();
                    BeanUtils.copyProperties((Object)userLoginInfo, (Object)staffBo);
                    result.add(userLoginInfo);
                }
                catch (IllegalAccessException | InvocationTargetException e) {
                    throw new RuntimeException(e);
                }
            }
        }
        return result;
    }

    public List<SysUsersVo> getAllUserInfo() {
        List sysUserList = this.sysUsersService.list();
        ArrayList<SysUsersVo> sysUsersVoList = new ArrayList<SysUsersVo>();
        for (SysUsers sysUsers : sysUserList) {
            SysUsersVo sysUsersVo = new SysUsersVo();
            try {
                BeanUtils.copyProperties((Object)sysUsers, (Object)sysUsersVo);
                sysUsersVoList.add(sysUsersVo);
            }
            catch (IllegalAccessException e) {
                throw new RuntimeException(e);
            }
            catch (InvocationTargetException e) {
                throw new RuntimeException(e);
            }
        }
        return sysUsersVoList;
    }

    public List<SysUserRoleVo> getAllUserRole() {
        List sysUserRoleList = this.sysUserRoleService.list();
        ArrayList<SysUserRoleVo> sysUserRoleVoList = new ArrayList<SysUserRoleVo>();
        for (SysUserRole sysUserRole : sysUserRoleList) {
            SysUserRoleVo sysUserRoleVo = new SysUserRoleVo();
            try {
                BeanUtils.copyProperties((Object)sysUserRole, (Object)sysUserRoleVo);
                sysUserRoleVoList.add(sysUserRoleVo);
            }
            catch (IllegalAccessException e) {
                throw new RuntimeException(e);
            }
            catch (InvocationTargetException e) {
                throw new RuntimeException(e);
            }
        }
        return sysUserRoleVoList;
    }

    public List<SysRolesVo> getAllRole() {
        List sysRolesList = this.sysRolesService.list();
        ArrayList<SysRolesVo> sysRolesVoList = new ArrayList<SysRolesVo>();
        for (SysRoles sysRoles : sysRolesList) {
            SysRolesVo sysRolesVo = new SysRolesVo();
            try {
                BeanUtils.copyProperties((Object)sysRoles, (Object)sysRolesVo);
                sysRolesVoList.add(sysRolesVo);
            }
            catch (IllegalAccessException e) {
                throw new RuntimeException(e);
            }
            catch (InvocationTargetException e) {
                throw new RuntimeException(e);
            }
        }
        return sysRolesVoList;
    }
}

