/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.filepreview.start.controller;

import com.jxdinfo.filepreview.start.util.ResponseFileUtil;
import com.jxdinfo.idp.common.enums.doc.AcceptFileType;
import com.jxdinfo.idp.common.exception.BusinessException;
import com.jxdinfo.idp.common.response.ApiResponse;
import com.jxdinfo.idp.common.util.file.FileUtil;
import com.jxdinfo.idp.common.util.file.LibreOfficePDFConvert;
import com.jxdinfo.idp.interf.FileSystemInterface;
import com.jxdinfo.idp.po.DocFilePo;
import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FilterOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.RandomAccessFile;
import java.io.Serializable;
import java.io.UnsupportedEncodingException;
import java.net.URLEncoder;
import java.util.Base64;
import java.util.Date;
import java.util.Map;
import javax.annotation.Resource;
import javax.servlet.ServletOutputStream;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.jodconverter.office.OfficeException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.boot.autoconfigure.condition.ConditionalOnWebApplication;
import org.springframework.http.ContentDisposition;
import org.springframework.http.HttpHeaders;
import org.springframework.http.HttpMethod;
import org.springframework.http.MediaType;
import org.springframework.util.StringUtils;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;
import org.springframework.web.client.ResponseExtractor;
import org.springframework.web.client.RestTemplate;

@RestController
@RequestMapping(value={"/preview"})
@ConditionalOnWebApplication
public class WkPreviewController {
    @Resource
    private RestTemplate downloadProxyTemplate;
    @Resource
    private FileSystemInterface fileSystemInterface;
    private static final Logger LOGGER = LoggerFactory.getLogger(WkPreviewController.class);

    @GetMapping(value={"/test"})
    public String getPostList() throws OfficeException {
        File file3 = new File("D:\\idp\\filePath\\1cdff885731e401c8a5cad78afd798d8.xlsx");
        File file4 = new File("D:\\idp\\pdfPath\\1cdff885731e401c8a5cad78afd798d8.pdf");
        System.out.println(LibreOfficePDFConvert.doDocToFdpLibre((File)file3, (File)file4));
        return "index";
    }

    @GetMapping(value={"/proxy"})
    public void getPostList(@RequestParam(value="url") String url, HttpServletResponse response) {
        long start = System.currentTimeMillis();
        LOGGER.info("==========\u4ee3\u7406\u8bf7\u6c42\u6587\u4ef6===========");
        byte[] decodedBytes = Base64.getDecoder().decode(url);
        url = new String(decodedBytes);
        ResponseExtractor responseExtractor = clientHttpResponse -> {
            HttpHeaders headers = clientHttpResponse.getHeaders();
            headers.forEach((key, value) -> response.setHeader(key, (String)value.get(0)));
            ContentDisposition contentDisposition = headers.getContentDisposition();
            if (contentDisposition == null) {
                return false;
            }
            MediaType contentType = headers.getContentType();
            if (contentType == null) {
                return false;
            }
            AcceptFileType acceptFileType = AcceptFileType.getAcceptFileType((String)contentType.toString(), (ContentDisposition)contentDisposition);
            if (acceptFileType == null) {
                return false;
            }
            LOGGER.info("\u6587\u4ef6\u7c7b\u578b\uff1a" + acceptFileType.getContentType());
            LOGGER.info("\u6587\u4ef6\u5927\u5c0f\uff1a" + headers.getContentLength());
            ResponseFileUtil.transferOrConvertResponse(clientHttpResponse, response, acceptFileType);
            return true;
        };
        Boolean execute = (Boolean)this.downloadProxyTemplate.execute(url, HttpMethod.GET, null, responseExtractor, new Object[0]);
        if (!Boolean.TRUE.equals(execute)) {
            throw new RuntimeException("\u6587\u4ef6\u4e0b\u8f7d\u5931\u8d25, \u8bf7\u68c0\u67e5\u6587\u4ef6\u7c7b\u578b\u662f\u5426\u652f\u6301\u9884\u89c8");
        }
        LOGGER.info("\u6587\u4ef6\u4e0b\u8f7d\u6210\u529f");
        LOGGER.info(response.getContentType());
        long end = System.currentTimeMillis();
        System.out.println("\u8017\u65f6\uff1a" + (end - start) + "ms");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @PostMapping(value={"/list2"})
    public synchronized void getPostList(@RequestBody Map<String, String> params, HttpServletRequest request, HttpServletResponse response) {
        LOGGER.info("==========\u8fdb\u5165\u9884\u89c8===========");
        FileInputStream input = null;
        RandomAccessFile randomAccessFile = null;
        InputStream inputStream = null;
        try {
            File file = null;
            LOGGER.info("==========\u8fdb\u5165\u5206\u7247\u9884\u89c8===========");
            String path = params.get("pdfPath");
            String convertFlag = params.get("convertFlag");
            if ("true".equals(convertFlag) && !path.endsWith(".pdf")) {
                String pdfPath = path.substring(0, path.lastIndexOf(".")) + ".pdf";
                path = LibreOfficePDFConvert.doDocToFdpLibre((File)new File(path), (File)new File(pdfPath));
            }
            file = new File(path);
            LOGGER.info("==========\u83b7\u5f97\u6587\u4ef6===========");
            inputStream = new FileInputStream(file);
            if (file.length() < 512000L) {
                response.setDateHeader("expires", System.currentTimeMillis() + 604800000L);
            }
            response.setHeader("Accept-Ranges", "bytes");
            response.setHeader("Content-Type", "application/pdf");
            String range = request.getHeader("Range");
            LOGGER.info("==========\u83b7\u5f97\u6587\u4ef6RANGE===========" + range);
            if (!StringUtils.isEmpty((Object)range)) {
                long t1 = new Date().getTime();
                LOGGER.info("==========\u8fdb\u5165206\u5206\u7247===========");
                range = range.replace("bytes=", "");
                String[] ranges = range.split("-");
                int startIndex = Integer.parseInt(ranges[0]);
                int endIndex = Integer.parseInt(ranges[1]);
                byte[] buffer = new byte[endIndex - startIndex + 1];
                randomAccessFile = new RandomAccessFile(file, "r");
                randomAccessFile.seek(startIndex);
                LOGGER.info("==========\u8fdb\u5165206\u5206\u7247 \u8bfb\u53d6\u6587\u4ef6===========");
                randomAccessFile.read(buffer);
                LOGGER.info("==========\u8fdb\u5165206\u5206\u7247 \u8bfb\u53d6\u6587\u4ef6\u7ed3\u675f===========");
                response.setHeader("Content-Range", "bytes " + startIndex + "-" + (endIndex - 1) + "/" + file.length() + "");
                response.setStatus(206);
                LOGGER.info("==========\u8fdb\u5165206\u5206\u7247 \u5199\u5165\u6587\u4ef6===========");
                response.getOutputStream().write(buffer);
                LOGGER.info("==========\u8fdb\u5165206\u5206\u7247 \u5199\u5165\u6587\u4ef6\u7ed3\u675f===========");
                long t2 = new Date().getTime();
                LOGGER.info("==========\u8fdb\u5165206\u5206\u7247\u7ed3\u675f===========" + (t1 - t2));
            } else {
                LOGGER.info("==========\u9996\u6b21\u52a0\u8f7d===========");
                inputStream = new FileInputStream(file);
                byte[] bytes = new byte[1024];
                ServletOutputStream os = response.getOutputStream();
                int i = 0;
                while ((i = inputStream.read(bytes)) != -1) {
                    os.write(bytes, 0, i);
                }
            }
        }
        catch (FileNotFoundException e) {
            e.printStackTrace();
            LOGGER.error("\u6587\u4ef6\u5df2\u88ab\u4eba\u4e3a\u5220\u9664" + e);
            throw new BusinessException("\u6587\u4ef6\u5df2\u88ab\u4eba\u4e3a\u5220\u9664", (Throwable)e);
        }
        catch (IOException e) {
            e.printStackTrace();
            LOGGER.error("\u6587\u4ef6\u672a\u8f6c\u6362\u5b8c\u6210,\u8bf7\u7a0d\u7b49" + e);
            throw new BusinessException("\u6587\u4ef6\u672a\u8f6c\u6362\u5b8c\u6210,\u8bf7\u7a0d\u7b49");
        }
        catch (Exception e) {
            LOGGER.error("\u6587\u4ef6\u4e0b\u8f7d\u5931\u8d25\uff1a" + e);
            e.printStackTrace();
        }
        finally {
            try {
                if (response.getOutputStream() != null) {
                    response.getOutputStream().close();
                }
                if (inputStream != null) {
                    inputStream.close();
                }
                if (randomAccessFile != null) {
                    randomAccessFile.close();
                }
                if (input != null) {
                    input.close();
                }
            }
            catch (IOException e) {
                e.printStackTrace();
                LOGGER.error("\u6587\u4ef6\u9884\u89c8\u5931\u8d25\uff1a" + e);
            }
        }
    }

    @GetMapping(value={"/checkFileExists"})
    public ApiResponse<String> checkFileExists(@RequestParam(value="pdfPath") String pdfPath) {
        String msg = FileUtil.checkFileValidity((String)pdfPath);
        if (msg != null) {
            return ApiResponse.fail((String)msg);
        }
        return ApiResponse.success((String)"\u6587\u4ef6\u5b58\u5728,\u8bfb\u5199\u6210\u529f");
    }

    @GetMapping(value={"/excel"})
    public void downloadXlxsFile(HttpServletRequest request, HttpServletResponse response) throws OfficeException {
        String id = request.getParameter("fileId");
        String convertFlag = request.getParameter("convertFlag");
        DocFilePo docFilePo = (DocFilePo)this.fileSystemInterface.getById((Serializable)((Object)id));
        String filePath = docFilePo.getPdfPath();
        String stuff = filePath.substring(filePath.lastIndexOf("."));
        String xlsxPath = filePath.substring(0, filePath.lastIndexOf(".")) + ".xlsx";
        File xlsxFile = new File(xlsxPath);
        if (!xlsxFile.getParentFile().exists()) {
            xlsxFile.getParentFile().mkdirs();
        }
        File xlsFile = new File(filePath);
        if ("true".equals(convertFlag)) {
            LibreOfficePDFConvert.doDocToFdpLibre((File)xlsFile, (File)xlsxFile);
            filePath = xlsxPath;
        }
        File file = new File(filePath);
        FilterOutputStream out = null;
        InputStream bis = null;
        try {
            bis = new BufferedInputStream(new FileInputStream(file), 10240);
            String displayName = URLEncoder.encode("excel\u9884\u89c8", "UTF-8");
            response.addHeader("Content-Disposition", "attachment;filename=" + displayName);
            response.setContentType("application/octet-stream");
            response.setHeader("Content-Transfer-Encoding", "binary");
            out = new BufferedOutputStream((OutputStream)response.getOutputStream());
            int len = 0;
            int i = bis.available();
            byte[] buff = new byte[i];
            while ((len = bis.read(buff)) > 0) {
                ((BufferedOutputStream)out).write(buff, 0, len);
                ((BufferedOutputStream)out).flush();
            }
        }
        catch (FileNotFoundException e) {
            LOGGER.error("\u6587\u4ef6\u672a\u627e\u5230\uff1a" + e.getMessage());
            throw new RuntimeException(e.getMessage());
        }
        catch (UnsupportedEncodingException e) {
            LOGGER.error("\u4e0d\u652f\u6301\u7684\u7f16\u7801\u5f02\u5e38\uff1a" + e.getMessage());
            throw new RuntimeException("\u4e0b\u8f7d\u51fa\u9519");
        }
        catch (IOException e) {
            LOGGER.error("IO\u5f02\u5e38\uff1a" + e.getMessage());
            throw new RuntimeException("\u4e0b\u8f7d\u51fa\u9519");
        }
        finally {
            try {
                if (null != bis) {
                    bis.close();
                }
            }
            catch (IOException e) {
                LOGGER.error("\u6d41\u5173\u95ed\u5f02\u5e38\uff1a" + e.getMessage());
            }
            try {
                if (null != out) {
                    out.close();
                }
            }
            catch (IOException e) {
                LOGGER.error("\u6d41\u5173\u95ed\u5f02\u5e38\uff1a" + e.getMessage());
            }
        }
    }
}

