/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.filepreview.start.util;

import com.jxdinfo.idp.common.enums.doc.AcceptFileType;
import com.jxdinfo.idp.common.util.file.LibreOfficePDFConvert;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.Objects;
import java.util.UUID;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.io.FileUtils;
import org.jodconverter.office.OfficeException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.http.client.ClientHttpResponse;
import org.springframework.util.StreamUtils;

public class ResponseFileUtil {
    private static final Logger LOGGER = LoggerFactory.getLogger(ResponseFileUtil.class);
    public static final String TEMP_FILE_DIR = "/temp";
    public static final String TEMP_FILE_PREFIX = "/temp.";
    public static final String FILE_LENGTH_HEADER = "Content-Length";

    public static void transferResponse(ClientHttpResponse clientHttpResponse, HttpServletResponse response) {
        try {
            StreamUtils.copy((InputStream)Objects.requireNonNull(clientHttpResponse.getBody()), (OutputStream)response.getOutputStream());
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
        finally {
            try {
                clientHttpResponse.getBody().close();
                response.getOutputStream().close();
            }
            catch (IOException e) {
                LOGGER.error("\u5173\u95ed\u8f93\u51fa\u6d41\u5931\u8d25", (Throwable)e);
            }
        }
    }

    public static void transferOrConvertResponse(ClientHttpResponse clientHttpResponse, HttpServletResponse response, AcceptFileType acceptFileType) {
        if (!acceptFileType.getConvertFlag().booleanValue()) {
            ResponseFileUtil.transferResponse(clientHttpResponse, response);
            return;
        }
        String dirFilePath = System.getProperty("user.dir") + TEMP_FILE_DIR + File.separator + UUID.randomUUID();
        File dirFile = new File(dirFilePath);
        if (!dirFile.exists() && dirFile.mkdirs()) {
            LOGGER.info("\u521b\u5efa\u4e34\u65f6\u6587\u4ef6\u5939\u6210\u529f");
        }
        File file = new File(dirFilePath + TEMP_FILE_PREFIX + acceptFileType.getType());
        File pdfFile = new File(dirFilePath + TEMP_FILE_PREFIX + AcceptFileType.PDF.getType());
        FileOutputStream out = null;
        FileInputStream in = null;
        try {
            out = new FileOutputStream(file);
            StreamUtils.copy((InputStream)clientHttpResponse.getBody(), (OutputStream)out);
            String path = LibreOfficePDFConvert.doDocToFdpLibre((File)file, (File)pdfFile);
            LOGGER.info("\u8f6c\u6362\u540e\u7684\u6587\u4ef6\u8def\u5f84\uff1a{}", (Object)path);
            response.setContentType("application/pdf");
            response.setHeader(FILE_LENGTH_HEADER, String.valueOf(pdfFile.length()));
            in = new FileInputStream(path);
            StreamUtils.copy((InputStream)in, (OutputStream)response.getOutputStream());
        }
        catch (IOException | OfficeException e) {
            LOGGER.error("\u6587\u4ef6\u8f6c\u6362\u5931\u8d25", e);
            throw new RuntimeException(e);
        }
        finally {
            try {
                if (out != null) {
                    out.close();
                }
                if (in != null) {
                    in.close();
                }
                clientHttpResponse.getBody().close();
                if (response.getOutputStream() != null) {
                    response.getOutputStream().close();
                }
                LOGGER.info("\u5220\u9664\u4e34\u65f6\u6587\u4ef6\u5939");
                FileUtils.deleteDirectory((File)dirFile);
            }
            catch (IOException e) {
                LOGGER.error("\u5173\u95ed\u8f93\u51fa\u6d41\u5931\u8d25", (Throwable)e);
            }
        }
    }
}

