/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.idp.scene.server.service.impl;

import com.baomidou.mybatisplus.extension.service.impl.ServiceImpl;
import com.jxdinfo.idp.common.util.SnowFlakeUtil;
import com.jxdinfo.idp.scene.api.po.SceneRuleLibRelevancyPo;
import com.jxdinfo.idp.scene.server.mapper.SceneRuleLibRelevancyMapper;
import com.jxdinfo.idp.scene.server.service.SceneRuleLibRelevancyService;
import java.util.ArrayList;
import java.util.List;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.util.ObjectUtils;

@Service
public class SceneRuleLibRelevancyServiceImpl
extends ServiceImpl<SceneRuleLibRelevancyMapper, SceneRuleLibRelevancyPo>
implements SceneRuleLibRelevancyService {
    private static final Logger log = LoggerFactory.getLogger(SceneRuleLibRelevancyServiceImpl.class);
    @Autowired
    private SceneRuleLibRelevancyMapper sceneRuleLibRelevancyMapper;

    @Override
    public List<SceneRuleLibRelevancyPo> findAllBySceneId(Long sceneId) {
        return this.sceneRuleLibRelevancyMapper.findAllBySceneId(sceneId);
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public void insert(Long sceneId, List<Long> ruleLibIdList) {
        ArrayList<SceneRuleLibRelevancyPo> entityList = new ArrayList<SceneRuleLibRelevancyPo>();
        for (Long ruleLibId : ruleLibIdList) {
            SceneRuleLibRelevancyPo obj = new SceneRuleLibRelevancyPo();
            obj.setId(SnowFlakeUtil.getFlowIdInstance().nextId());
            obj.setRuleLibId(ruleLibId.longValue());
            obj.setSceneId(sceneId.longValue());
            entityList.add(obj);
        }
        this.saveBatch(entityList);
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public void addOrUpdate(Long sceneId, List<Long> ruleLibIdList) {
        if (ruleLibIdList == null || ruleLibIdList.isEmpty()) {
            this.sceneRuleLibRelevancyMapper.deleteBySceneId(sceneId);
            return;
        }
        List<SceneRuleLibRelevancyPo> sceneRuleLibRelevancyPoList = ((SceneRuleLibRelevancyMapper)this.baseMapper).findAllBySceneId(sceneId);
        List ruleLibIdListExist = sceneRuleLibRelevancyPoList.stream().map(SceneRuleLibRelevancyPo::getRuleLibId).collect(Collectors.toList());
        List<Long> ruleLibIdListDelete = ruleLibIdListExist.stream().filter(ruleLibId2 -> !ruleLibIdList.contains(ruleLibId2)).collect(Collectors.toList());
        ArrayList<SceneRuleLibRelevancyPo> ruleLibRelevancyPos = new ArrayList<SceneRuleLibRelevancyPo>();
        for (Long ruleLibId : ruleLibIdList) {
            if (ruleLibIdListExist.contains(ruleLibId)) continue;
            SceneRuleLibRelevancyPo obj = new SceneRuleLibRelevancyPo();
            obj.setId(SnowFlakeUtil.getFlowIdInstance().nextId());
            obj.setRuleLibId(ruleLibId.longValue());
            obj.setSceneId(sceneId.longValue());
            ruleLibRelevancyPos.add(obj);
        }
        this.saveBatch(ruleLibRelevancyPos);
        if (!ObjectUtils.isEmpty(ruleLibIdListDelete)) {
            this.sceneRuleLibRelevancyMapper.deleteBySceneIdAndRuleLibId(sceneId, ruleLibIdListDelete);
        }
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public void delete(long sceneId) {
        this.sceneRuleLibRelevancyMapper.deleteBySceneId(sceneId);
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public void deleteBySceneIdAndRuleLibId(long sceneId, List<Long> ruleLibIdList) {
        if (!ObjectUtils.isEmpty(ruleLibIdList)) {
            this.sceneRuleLibRelevancyMapper.deleteBySceneIdAndRuleLibId(sceneId, ruleLibIdList);
        }
    }

    @Override
    public void delete(long sceneId, List<Long> templateIdList) {
        if (!ObjectUtils.isEmpty(templateIdList)) {
            this.sceneRuleLibRelevancyMapper.delete(sceneId, templateIdList);
        }
    }
}

