/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.idp.scene.server.controller;

import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.jxdinfo.idp.common.response.ApiResponse;
import com.jxdinfo.idp.common.util.SnowFlakeUtil;
import com.jxdinfo.idp.rule.api.vo.RuleLibVo;
import com.jxdinfo.idp.scene.api.dto.GroupSceneDto;
import com.jxdinfo.idp.scene.api.dto.SceneConfigResult;
import com.jxdinfo.idp.scene.api.dto.SceneDto;
import com.jxdinfo.idp.scene.api.dto.SceneRuleLibDto;
import com.jxdinfo.idp.scene.api.po.SceneGroupPo;
import com.jxdinfo.idp.scene.api.po.ScenePo;
import com.jxdinfo.idp.scene.api.vo.ScenePageVo;
import com.jxdinfo.idp.scene.dto.RuleItemObject;
import com.jxdinfo.idp.scene.server.service.SceneGroupService;
import com.jxdinfo.idp.scene.server.service.impl.SceneDocTypeRelevancyServiceImpl;
import com.jxdinfo.idp.scene.server.service.impl.SceneServiceImpl;
import com.jxdinfo.idp.vo.DocTypeVo;
import java.util.List;
import java.util.Map;
import javax.annotation.Resource;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/scene"})
public class SceneController {
    private static final Logger log = LoggerFactory.getLogger(SceneController.class);
    @Resource
    private SceneServiceImpl sceneService;
    @Autowired
    private SceneGroupService sceneGroupService;
    @Autowired
    private SceneDocTypeRelevancyServiceImpl sceneDocTypeRelevancyService;

    @GetMapping(value={"/getSceneByPage"})
    public ApiResponse<Page<SceneRuleLibDto>> getSceneByPage(@RequestBody ScenePageVo scenePageVo) {
        Page<SceneRuleLibDto> page = this.sceneService.getSceneList(scenePageVo);
        return ApiResponse.success(page);
    }

    @GetMapping(value={"/getSceneList"})
    public ApiResponse<List<GroupSceneDto>> getSceneList() {
        return ApiResponse.success(this.sceneService.getSceneList());
    }

    @GetMapping(value={"/getSceneById"})
    public ApiResponse<SceneDto> getScene(@RequestParam long sceneId) {
        return ApiResponse.success((Object)this.sceneService.getScene(sceneId));
    }

    @PostMapping(value={"/search"})
    public ApiResponse<List<GroupSceneDto>> search(@RequestParam(required=false) String sceneName, @RequestParam(required=false) String startCreateTime, @RequestParam(required=false) String endCreateTime) {
        List<GroupSceneDto> scenePoList = this.sceneService.search2(sceneName, startCreateTime, endCreateTime);
        return ApiResponse.success(scenePoList);
    }

    @PostMapping(value={"/add"})
    public ApiResponse<Long> add(@RequestBody ScenePo scenePo) {
        scenePo.setId(SnowFlakeUtil.getFlowIdInstance().nextId());
        this.sceneService.save(scenePo);
        return ApiResponse.success((Object)scenePo.getId());
    }

    @PostMapping(value={"/update"})
    public ApiResponse<Void> update(@RequestBody ScenePo scenePo) {
        this.sceneService.updateScene(scenePo);
        return ApiResponse.success();
    }

    @GetMapping(value={"/deleteById"})
    public ApiResponse<Void> deleteById(@RequestParam long sceneId) {
        this.sceneService.deleteById(sceneId);
        return ApiResponse.success();
    }

    @PostMapping(value={"/group/add"})
    public ApiResponse<Void> saveGroup(@RequestBody SceneGroupPo groupPo) {
        groupPo.setId(SnowFlakeUtil.getFlowIdInstance().nextId());
        this.sceneGroupService.save(groupPo);
        return ApiResponse.success();
    }

    @PostMapping(value={"/group/update"})
    public ApiResponse<Void> updateGroup(@RequestBody SceneGroupPo groupPo) {
        this.sceneGroupService.updateById(groupPo);
        return ApiResponse.success();
    }

    @GetMapping(value={"/group/deleteById"})
    public ApiResponse<Void> deleteGroupById(@RequestParam Long groupId) {
        List<ScenePo> scenePoList = this.sceneService.findByGroupId(groupId);
        if (!scenePoList.isEmpty()) {
            return ApiResponse.fail((String)"\u5f53\u524d\u5206\u7ec4\u4e0d\u5141\u8bb8\u5220\u9664\uff01");
        }
        this.sceneGroupService.removeById(groupId);
        return ApiResponse.success();
    }

    @GetMapping(value={"/goStep"})
    public ApiResponse<Object> goStep(@RequestParam Long sceneId, @RequestParam int step) {
        switch (step) {
            case 1: {
                Map<String, Object> data = this.sceneService.getDocTypeData(sceneId);
                return ApiResponse.success(data);
            }
            case 2: {
                List<RuleLibVo> data2 = this.sceneService.queryRuleLib(sceneId);
                return ApiResponse.success(data2);
            }
            case 3: {
                List<RuleLibVo> data3 = this.sceneService.getRuleLibItemTree(sceneId);
                return ApiResponse.success(data3);
            }
        }
        log.error("step number is error");
        return ApiResponse.success();
    }

    @GetMapping(value={"/queryRuleItemList"})
    public ApiResponse<List<RuleItemObject>> queryRuleItemList(@RequestParam Long sceneId, @RequestParam Long[] ruleIdList) {
        return ApiResponse.success(this.sceneService.queryRuleItemList(sceneId, ruleIdList));
    }

    @GetMapping(value={"/queryDocTypeList"})
    public ApiResponse<List<DocTypeVo>> queryRuleItemList(@RequestParam Long sceneId) {
        return ApiResponse.success(this.sceneDocTypeRelevancyService.getDocTypeObjectList(sceneId));
    }

    @PostMapping(value={"/saveRuleItem"})
    public ApiResponse<Void> saveRuleItem(@RequestBody List<RuleItemObject> ruleItemObjectList) {
        this.sceneService.saveRuleItemList(ruleItemObjectList);
        return ApiResponse.success();
    }

    @GetMapping(value={"/getConfigResult"})
    public ApiResponse<List<SceneConfigResult>> getConfigResult(@RequestParam long sceneId) {
        return ApiResponse.success(this.sceneService.getConfigResultList(sceneId));
    }

    @GetMapping(value={"/getCount"})
    public ApiResponse<Integer> getSceneCount() {
        return ApiResponse.success((Object)this.sceneService.getSceneCount());
    }

    @GetMapping(value={"/getRuleLibTree"})
    public ApiResponse<List<RuleLibVo>> getRuleLibList(@RequestParam int level) {
        List<RuleLibVo> data = this.sceneService.queryRuleLibTree(level);
        return ApiResponse.success(data);
    }

    @GetMapping(value={"/getRuleLib"})
    public ApiResponse<RuleLibVo> getRuleLib(@RequestParam long ruleLibId) {
        return ApiResponse.success((Object)this.sceneService.getRuleLibVo(ruleLibId));
    }

    @GetMapping(value={"/deleteByExtractItemId"})
    public ApiResponse<Void> deleteByExtractItemId(@RequestParam long extractItemId) {
        this.sceneService.deleteByExtractItemId(extractItemId);
        return ApiResponse.success();
    }
}

