/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.idp.scene.server.controller;

import com.jxdinfo.idp.common.response.ApiResponse;
import com.jxdinfo.idp.common.util.SnowFlakeUtil;
import com.jxdinfo.idp.scene.api.po.SceneRuleExtractRelevancyPo;
import com.jxdinfo.idp.scene.server.service.impl.SceneRuleExtractRelevancyServiceImpl;
import java.util.List;
import javax.annotation.Resource;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/scene/ruleExtract"})
public class SceneRuleExtractRelevancyController {
    private static final Logger log = LoggerFactory.getLogger(SceneRuleExtractRelevancyController.class);
    @Resource
    private SceneRuleExtractRelevancyServiceImpl sceneRuleExtractRelevancyService;

    @PostMapping(value={"/add"})
    public ApiResponse<Void> add(@RequestParam List<SceneRuleExtractRelevancyPo> objects) {
        objects.forEach(obj -> {
            obj.setId(SnowFlakeUtil.getFlowIdInstance().nextId());
            this.sceneRuleExtractRelevancyService.save(obj);
        });
        return ApiResponse.success();
    }

    @PostMapping(value={"/update"})
    public ApiResponse<Void> update(@RequestParam List<SceneRuleExtractRelevancyPo> objects) {
        objects.forEach(obj -> this.sceneRuleExtractRelevancyService.updateById(obj));
        return ApiResponse.success();
    }

    @GetMapping(value={"/getBySceneId"})
    public ApiResponse<List<SceneRuleExtractRelevancyPo>> getBySceneId(@RequestParam long sceneId) {
        return ApiResponse.success(this.sceneRuleExtractRelevancyService.findAllBySceneId(sceneId));
    }
}

