/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.hussar.unify.authentication.client.utils;

import com.jxdinfo.hussar.platform.core.utils.HussarUtils;
import com.jxdinfo.hussar.support.cache.util.HussarCacheUtil;

public class UnifySessionCacheUtil {
    private static final String NAMESPACE = "CAS_CLIENT";
    private static final String ID_TO_SESSION_KEY_MAPPING = "CAS_CLIENT:SESSION_KEY:";
    private static final String MANAGED_SESSIONS = "CAS_CLIENT:MAPPING_ID:";
    private static final String TGT_EXPIRES_TIME = "CAS_CLIENT:TGT_EXPIRES_TIME:";
    private static final String ST_TGT_MAPPING = "CAS_CLIENT:ST_TGT_MAPPING:";

    public static void putSessionWithStKey(String serviceTicketId, String sessionId) {
        HussarCacheUtil.put((String)NAMESPACE, (Object)(MANAGED_SESSIONS + serviceTicketId), (Object)sessionId);
    }

    public static void putStKeyWithSessionId(String serviceTicketId, String sessionId) {
        HussarCacheUtil.put((String)NAMESPACE, (Object)(ID_TO_SESSION_KEY_MAPPING + sessionId), (Object)serviceTicketId);
    }

    public static void putSessionMapping(String serviceTicketId, String sessionId) {
        HussarCacheUtil.put((String)NAMESPACE, (Object)(MANAGED_SESSIONS + serviceTicketId), (Object)sessionId);
        HussarCacheUtil.put((String)NAMESPACE, (Object)(ID_TO_SESSION_KEY_MAPPING + sessionId), (Object)serviceTicketId);
    }

    public static void putTgtExpiresTime(String grantingTicketId, Object tgtExpiresTime) {
        HussarCacheUtil.put((String)NAMESPACE, (Object)(TGT_EXPIRES_TIME + grantingTicketId), (Object)tgtExpiresTime);
    }

    public static void putStTgtMapping(String serviceTicketId, String grantingTicketId) {
        HussarCacheUtil.put((String)NAMESPACE, (Object)(ST_TGT_MAPPING + serviceTicketId), (Object)grantingTicketId);
    }

    public static String getSessionIdByStKey(String serviceTicketId) {
        if (HussarUtils.isBlank((CharSequence)serviceTicketId)) {
            return null;
        }
        return (String)HussarCacheUtil.get((String)NAMESPACE, (Object)(MANAGED_SESSIONS + serviceTicketId), String.class);
    }

    public static String getStKeyBySessionId(String sessionId) {
        if (HussarUtils.isBlank((CharSequence)sessionId)) {
            return null;
        }
        return (String)HussarCacheUtil.get((String)NAMESPACE, (Object)(ID_TO_SESSION_KEY_MAPPING + sessionId), String.class);
    }

    public static <T> T getTgtExpiresTime(String grantingTicketId) {
        if (HussarUtils.isBlank((CharSequence)grantingTicketId)) {
            return null;
        }
        return (T)HussarCacheUtil.get((String)NAMESPACE, (Object)(TGT_EXPIRES_TIME + grantingTicketId));
    }

    public static String getStTgtMapping(String serviceTicketId) {
        if (HussarUtils.isBlank((CharSequence)serviceTicketId)) {
            return null;
        }
        return (String)HussarCacheUtil.get((String)NAMESPACE, (Object)(ST_TGT_MAPPING + serviceTicketId), String.class);
    }

    public static void removeSessionWithStKey(String serviceTicketId) {
        HussarCacheUtil.evict((String)NAMESPACE, (Object)(MANAGED_SESSIONS + serviceTicketId));
    }

    public static void removeStKeyWithSessionId(String sessionId) {
        HussarCacheUtil.evict((String)NAMESPACE, (Object)(ID_TO_SESSION_KEY_MAPPING + sessionId));
    }

    public static void removeSessionMapping(String serviceTicketId, String sessionId) {
        HussarCacheUtil.evict((String)NAMESPACE, (Object)(MANAGED_SESSIONS + serviceTicketId));
        HussarCacheUtil.evict((String)NAMESPACE, (Object)(ID_TO_SESSION_KEY_MAPPING + sessionId));
    }

    public static void removeTgtExpiresTime(String grantingTicketId) {
        HussarCacheUtil.evict((String)NAMESPACE, (Object)(TGT_EXPIRES_TIME + grantingTicketId));
    }

    public static void removeStTgtMapping(String serviceTicketId) {
        HussarCacheUtil.evict((String)NAMESPACE, (Object)(ST_TGT_MAPPING + serviceTicketId));
    }
}

