/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.hussar.unify.authentication.client.config.oauth2;

import com.jxdinfo.hussar.unify.authentication.client.config.oauth2.AutoRefreshTokenConfig;
import com.jxdinfo.hussar.unify.authentication.client.controller.oauth2.Oauth2UnifyAuthenticationController;
import com.jxdinfo.hussar.unify.authentication.client.filter.Oauth2SignOutFilter;
import com.jxdinfo.hussar.unify.authentication.client.initializer.GetRefreshTokenConfigRunner;
import com.jxdinfo.hussar.unify.authentication.client.interceptor.Oauth2HandlerInterceptor;
import com.jxdinfo.hussar.unify.authentication.client.service.AbstractSendMailService;
import com.jxdinfo.hussar.unify.authentication.client.service.AbstractUnifyAuthenticationService;
import com.jxdinfo.hussar.unify.authentication.client.service.UnifyAuthenticationPostProcessor;
import com.jxdinfo.hussar.unify.authentication.client.service.impl.DefaultSendMailService;
import com.jxdinfo.hussar.unify.authentication.client.service.impl.DefaultUnifyAuthenticationPostProcessor;
import com.jxdinfo.hussar.unify.authentication.client.service.impl.oauth2.Oauth2UnifyAuthenticationServiceImpl;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import javax.servlet.Filter;
import org.springframework.boot.ApplicationRunner;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.boot.web.servlet.FilterRegistrationBean;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.web.servlet.HandlerInterceptor;
import org.springframework.web.servlet.config.annotation.InterceptorRegistry;
import org.springframework.web.servlet.config.annotation.WebMvcConfigurer;

@Configuration
public class Oauth2ClientConfig
implements WebMvcConfigurer {
    @Bean
    public AutoRefreshTokenConfig autoRefreshTokenConfig() {
        return new AutoRefreshTokenConfig();
    }

    @Bean
    public ApplicationRunner getRefreshTokenConfigRunner() {
        return new GetRefreshTokenConfigRunner();
    }

    @Bean
    @ConditionalOnMissingBean(value={UnifyAuthenticationPostProcessor.class})
    public UnifyAuthenticationPostProcessor unifyAuthenticationPostProcessor() {
        return new DefaultUnifyAuthenticationPostProcessor();
    }

    @Bean
    @ConditionalOnMissingBean(value={AbstractSendMailService.class})
    public AbstractSendMailService abstractSendMailService() {
        return new DefaultSendMailService();
    }

    @Bean
    @ConditionalOnMissingBean
    public ExecutorService loginErrorMailExecutor() {
        ThreadPoolExecutor executor = new ThreadPoolExecutor(5, 50, 60L, TimeUnit.MILLISECONDS, new LinkedBlockingQueue<Runnable>());
        return executor;
    }

    @Bean
    public AbstractUnifyAuthenticationService abstractUnifyAuthenticationService() {
        return new Oauth2UnifyAuthenticationServiceImpl();
    }

    @Bean
    public Oauth2UnifyAuthenticationController oauth2UnifyAuthenticationController() {
        return new Oauth2UnifyAuthenticationController();
    }

    @Bean
    public Oauth2HandlerInterceptor oauth2HandlerInterceptor() {
        return new Oauth2HandlerInterceptor();
    }

    public void addInterceptors(InterceptorRegistry registry) {
        registry.addInterceptor((HandlerInterceptor)this.oauth2HandlerInterceptor()).addPathPatterns(new String[]{"/**"});
    }

    @Bean
    public FilterRegistrationBean<Oauth2SignOutFilter> oauth2SignOutFilterRegistration() {
        FilterRegistrationBean registration = new FilterRegistrationBean();
        registration.setFilter((Filter)new Oauth2SignOutFilter());
        registration.addUrlPatterns(new String[]{"/*"});
        registration.setOrder(1);
        return registration;
    }
}

