/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.hussar.unify.authentication.client.utils;

import com.jxdinfo.hussar.platform.core.annotation.Inner;
import com.jxdinfo.hussar.platform.core.utils.HussarUtils;
import com.jxdinfo.hussar.support.cache.util.HussarCacheUtil;
import com.jxdinfo.hussar.unify.authentication.client.dto.UnifyLoginUserDetail;
import com.jxdinfo.hussar.unify.authentication.client.utils.GetLoginUserUtil;
import com.jxdinfo.hussar.unify.authentication.client.utils.OkHttpRequestUtil;
import com.jxdinfo.hussar.unify.authentication.core.entity.HussarCasUserInfo;
import java.lang.reflect.Method;
import java.util.List;
import java.util.Map;
import javax.servlet.http.HttpServletRequest;
import org.jasig.cas.client.validation.Assertion;
import org.springframework.core.annotation.AnnotationUtils;
import org.springframework.util.AntPathMatcher;
import org.springframework.util.PathMatcher;
import org.springframework.web.context.request.RequestContextHolder;
import org.springframework.web.context.request.ServletRequestAttributes;
import org.springframework.web.method.HandlerMethod;

public class UnifyAuthSecurityUtil {
    private static PathMatcher pathMatcher = new AntPathMatcher();

    private static HttpServletRequest getRequest() {
        ServletRequestAttributes attributes = (ServletRequestAttributes)RequestContextHolder.getRequestAttributes();
        if (attributes == null) {
            return null;
        }
        return attributes.getRequest();
    }

    public static UnifyLoginUserDetail getUserDetail() {
        Assertion assertion;
        HttpServletRequest request = UnifyAuthSecurityUtil.getRequest();
        if (request == null) {
            return null;
        }
        String token = request.getHeader("hussar-unify-token");
        if (HussarUtils.isNotEmpty((Object)token)) {
            if (HussarCacheUtil.containKey((String)"hussar_uas_client_user", (Object)token)) {
                return UnifyLoginUserDetail.init(GetLoginUserUtil.getHussarCasUserInfo(token));
            }
            HussarCasUserInfo userInfo = OkHttpRequestUtil.getUser(token);
            if (userInfo != null) {
                return UnifyLoginUserDetail.init(userInfo);
            }
        }
        if (HussarUtils.isNotEmpty((Object)(assertion = (Assertion)request.getSession().getAttribute("_const_cas_assertion_")))) {
            UnifyLoginUserDetail userDetail = new UnifyLoginUserDetail();
            userDetail.setAccountName(assertion.getPrincipal().getName());
            Map attributes = assertion.getPrincipal().getAttributes();
            userDetail.setUserName((String)attributes.get("user_name"));
            userDetail.setTenantCode((String)attributes.get("tenantCode"));
            return userDetail;
        }
        return null;
    }

    public static boolean isRequestUrlExcluded(HttpServletRequest request, Object handler, List<String> ignorePatterns) {
        if (handler != null) {
            Inner annotationClass = (Inner)AnnotationUtils.findAnnotation((Class)((HandlerMethod)handler).getBeanType(), Inner.class);
            if (HussarUtils.isNotEmpty((Object)annotationClass)) {
                return true;
            }
            Inner annotationMethod = (Inner)AnnotationUtils.findAnnotation((Method)((HandlerMethod)handler).getMethod(), Inner.class);
            if (HussarUtils.isNotEmpty((Object)annotationMethod)) {
                return true;
            }
        }
        if (HussarUtils.isEmpty(ignorePatterns)) {
            return false;
        }
        for (String pattern : ignorePatterns) {
            if (!pathMatcher.match(pattern, request.getRequestURI())) continue;
            return true;
        }
        return false;
    }
}

