/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.hussar.unify.authentication.client.service;

import com.jxdinfo.hussar.mail.util.HussarMailUtils;
import com.jxdinfo.hussar.platform.core.utils.HussarUtils;
import com.jxdinfo.hussar.unify.authentication.client.dto.SendMailEntity;
import com.jxdinfo.hussar.unify.authentication.client.properties.UnifyAuthenticationClientProperties;
import java.io.File;
import java.util.HashSet;
import java.util.Set;
import java.util.concurrent.ExecutorService;
import javax.annotation.Resource;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AbstractSendMailService {
    protected final Logger logger = LoggerFactory.getLogger(AbstractSendMailService.class);
    @Resource
    private ExecutorService loginErrorMailExecutor;
    @Resource
    private UnifyAuthenticationClientProperties properties;

    public void sendLoginErrorMail(String username, Exception loginException) {
        this.loginErrorMailExecutor.execute(() -> {
            try {
                SendMailEntity sendMailEntity = this.getSendLoginErrorMailEntity(username, loginException);
                HashSet<String> tos = new HashSet<String>();
                if (HussarUtils.isNotEmpty(this.properties.getErrorMailReceiver())) {
                    tos.addAll(this.properties.getErrorMailReceiver());
                }
                if (HussarUtils.isNotEmpty(sendMailEntity.getTos())) {
                    tos.addAll(sendMailEntity.getTos());
                }
                if (HussarUtils.isNotEmpty(tos)) {
                    this.sendMail(sendMailEntity, tos);
                }
            }
            catch (Exception e) {
                this.logger.error("\u53d1\u9001\u90ae\u4ef6\u5931\u8d25", (Throwable)e);
            }
        });
    }

    public abstract SendMailEntity getSendLoginErrorMailEntity(String var1, Exception var2);

    private void sendMail(SendMailEntity sendMailEntity, Set<String> tos) {
        HussarMailUtils.send(tos, (String)sendMailEntity.getMailSubject(), (String)sendMailEntity.getContent(), (boolean)sendMailEntity.isHtml(), (File[])new File[0]);
    }
}

