/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.hussar.unify.authentication.client.initializer;

import com.jxdinfo.hussar.platform.core.BooleanUtil;
import java.util.HashMap;
import java.util.Map;
import org.springframework.boot.SpringApplication;
import org.springframework.boot.env.EnvironmentPostProcessor;
import org.springframework.boot.env.OriginTrackedMapPropertySource;
import org.springframework.core.env.ConfigurableEnvironment;
import org.springframework.core.env.PropertySource;

public class UnifyAuthenticationClientEnvironmentPostProcessor
implements EnvironmentPostProcessor {
    public void postProcessEnvironment(ConfigurableEnvironment environment, SpringApplication application) {
        Boolean enable = (Boolean)environment.getProperty("hussar.unify.authentication.enable", Boolean.class);
        if (!BooleanUtil.isTrue((Boolean)enable)) {
            return;
        }
        OriginTrackedMapPropertySource originSource = (OriginTrackedMapPropertySource)environment.getPropertySources().stream().filter(source -> source instanceof OriginTrackedMapPropertySource).filter(source -> source.containsProperty("hussar.unify.authentication.enable")).findFirst().get();
        OriginTrackedMapPropertySource newPropertySource = this.init(originSource);
        environment.getPropertySources().remove(newPropertySource.getName());
        environment.getPropertySources().addLast((PropertySource)newPropertySource);
    }

    private OriginTrackedMapPropertySource init(OriginTrackedMapPropertySource originSource) {
        String serverHostUrl = ((Map)originSource.getSource()).get("hussar.unify.authentication.server-host-url").toString();
        String clientHostUrl = ((Map)originSource.getSource()).get("hussar.unify.authentication.client-host-url").toString();
        HashMap<String, String> newSourceMap = new HashMap<String, String>();
        OriginTrackedMapPropertySource newSource = new OriginTrackedMapPropertySource(originSource.getName(), newSourceMap);
        newSourceMap.putAll((Map)originSource.getSource());
        newSourceMap.put("cas.server-login-url", serverHostUrl + "/uas/login");
        newSourceMap.put("cas.server-url-prefix", serverHostUrl + "/uas");
        newSourceMap.put("cas.client-host-url", clientHostUrl);
        newSourceMap.put("cas.validation-type", "cas3");
        return newSource;
    }
}

