/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.hussar.unify.authentication.client.session;

import com.jxdinfo.hussar.unify.authentication.client.utils.UnifySessionCacheUtil;
import javax.servlet.http.HttpSession;
import org.jasig.cas.client.session.SessionMappingStorage;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class HashMapBackedSessionMappingStorage
implements SessionMappingStorage {
    private final Logger logger = LoggerFactory.getLogger(this.getClass());

    public synchronized void addSessionById(String mappingId, HttpSession session) {
        UnifySessionCacheUtil.putSessionMapping(mappingId, session.getId());
    }

    public synchronized void removeBySessionById(String sessionId) {
        this.logger.debug("Attempting to remove Session=[{}]", (Object)sessionId);
        String key = UnifySessionCacheUtil.getStKeyBySessionId(sessionId);
        if (this.logger.isDebugEnabled()) {
            if (key != null) {
                this.logger.debug("Found mapping for session.  Session Removed.");
            } else {
                this.logger.debug("No mapping for session found.  Ignoring.");
            }
        }
        UnifySessionCacheUtil.removeSessionMapping(key, sessionId);
        String grantingTicketId = UnifySessionCacheUtil.getStTgtMapping(key);
        UnifySessionCacheUtil.removeTgtExpiresTime(grantingTicketId);
        UnifySessionCacheUtil.removeStTgtMapping(key);
    }

    public synchronized HttpSession removeSessionByMappingId(String mappingId) {
        String sessionId = UnifySessionCacheUtil.getSessionIdByStKey(mappingId);
        if (sessionId != null) {
            this.removeBySessionById(sessionId);
        }
        return null;
    }
}

