/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.hussar.support.transdict.service.config;

import com.jxdinfo.hussar.support.transdict.service.properties.TransdictProperties;
import com.jxdinfo.hussar.support.transdict.service.support.SpringContextUtil;
import com.jxdinfo.hussar.support.transdict.service.trans.aop.TransMethodResultAop;
import com.jxdinfo.hussar.support.transdict.service.trans.clearCache.ClearCacheAnnotationAdvisor;
import com.jxdinfo.hussar.support.transdict.service.trans.clearCache.ClearCacheAnnotationInterceptor;
import com.jxdinfo.hussar.support.transdict.service.trans.service.impl.FieldsTransService;
import com.jxdinfo.hussar.support.transdict.service.trans.service.impl.IdTransService;
import com.jxdinfo.hussar.support.transdict.service.trans.service.impl.TransService;
import org.aopalliance.aop.Advice;
import org.springframework.aop.Advisor;
import org.springframework.boot.autoconfigure.condition.ConditionalOnClass;
import org.springframework.boot.context.properties.EnableConfigurationProperties;
import org.springframework.cache.CacheManager;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;

@Configuration
@EnableConfigurationProperties(value={TransdictProperties.class})
public class TransServiceConfig {
    private final TransdictProperties transdictProperties;

    public TransServiceConfig(TransdictProperties transdictProperties) {
        this.transdictProperties = transdictProperties;
    }

    @Bean
    public TransService transService() {
        return new TransService();
    }

    @Bean
    public IdTransService autoTransService(CacheManager hussarCacheManager) {
        IdTransService autoTransService = new IdTransService();
        autoTransService.setPackageNames(this.transdictProperties.getServicePackageNames());
        autoTransService.setTransdictProperties(this.transdictProperties);
        if (this.transdictProperties.getEnableCache().booleanValue()) {
            autoTransService.setHussarCacheManager(hussarCacheManager);
        }
        return autoTransService;
    }

    @Bean
    public FieldsTransService dictionaryTransService(CacheManager hussarCacheManager) {
        FieldsTransService dictionaryTransService = new FieldsTransService();
        dictionaryTransService.setTransdictProperties(this.transdictProperties);
        dictionaryTransService.setPackageNames(this.transdictProperties.getServicePackageNames());
        if (this.transdictProperties.getEnableCache().booleanValue()) {
            dictionaryTransService.setHussarCacheManager(hussarCacheManager);
        }
        return dictionaryTransService;
    }

    @Bean
    public TransMethodResultAop transMethodResultAop(TransService transService) {
        return new TransMethodResultAop(transService);
    }

    @Bean
    @ConditionalOnClass(value={CacheManager.class})
    public Advisor clearCacheAnnotationAdvisor(CacheManager hussarCacheManager) {
        ClearCacheAnnotationInterceptor clearCacheAnnotationInterceptor = new ClearCacheAnnotationInterceptor();
        clearCacheAnnotationInterceptor.setHussarCacheManager(hussarCacheManager);
        clearCacheAnnotationInterceptor.setTransdictProperties(this.transdictProperties);
        ClearCacheAnnotationAdvisor clearCacheAnnotationAdvisor = new ClearCacheAnnotationAdvisor((Advice)clearCacheAnnotationInterceptor);
        return clearCacheAnnotationAdvisor;
    }

    @Bean(value={"springContextUtil"})
    public SpringContextUtil springContextUtil() {
        return new SpringContextUtil();
    }
}

