/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.hussar.support.transdict.service.utils;

import com.jxdinfo.hussar.support.transdict.service.utils.ConverterUtils;
import com.jxdinfo.hussar.support.transdict.service.utils.StringUtil;
import java.util.Collection;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class CheckUtils {
    public static boolean isNullOrEmpty(Object obj) {
        return obj == null || "".equals(StringUtil.toString(obj).trim());
    }

    public static boolean isNotEmpty(Object obj) {
        return obj != null && !"".equals(StringUtil.toString(obj).trim());
    }

    public static boolean isNumber(Object obj) {
        return CheckUtils.checkPattern(StringUtil.toString(obj).trim(), "^[-+]?[0-9]+(\\.[0-9]+)?$");
    }

    public static boolean isPositiveNumber(Object obj) {
        return CheckUtils.checkPattern(StringUtil.toString(obj).trim(), "^[0-9]+(\\.[0-9]+)?$");
    }

    public static boolean isDouble(Object obj) {
        return CheckUtils.checkPattern(StringUtil.toString(obj).trim(), "^[0-9]+(.[0-9]{1,2})?$");
    }

    public static boolean isInt(Object obj) {
        return CheckUtils.checkPattern(StringUtil.toString(obj).trim(), "^[0-9]?$");
    }

    public static boolean checkCollectionIsNullOrEmpty(Collection con) {
        return con == null || con.size() == 0;
    }

    public static boolean checkPattern(String str, String pattern) {
        try {
            if (pattern.startsWith("/")) {
                pattern = pattern.substring(1);
            }
            if (pattern.endsWith("/")) {
                pattern = pattern.substring(0, pattern.length() - 1);
            }
            return str.matches(pattern);
        }
        catch (Exception e) {
            e.printStackTrace();
            return false;
        }
    }

    public static boolean checkPhone(String str) {
        String phone = "^((13[0-9])|(14[5,7,9])|(15([0-3]|[5-9]))|(166)|(17[0,1,3,5,6,7,8])|(18[0-9])|(19[8|9]))\\d{8}$";
        return str.matches(phone);
    }

    public static boolean checkCharacters(String str) {
        String chineseCharacters = "[\u4e00-\u9fa5]+";
        return str.matches(chineseCharacters);
    }

    public static boolean checkEmail(String emailStr) {
        String emailRegStr = "^([a-z0-9A-Z]+[-|\\.]?)+[a-z0-9A-Z]@([a-z0-9A-Z]+(-[a-z0-9A-Z]+)?\\.)+[a-zA-Z]{2,}$";
        return emailStr.matches(emailRegStr);
    }

    public static boolean checkUserName(String userNameStr) {
        String userNameRegStr = "^([a-zA-Z_]{4,32})$";
        return userNameStr.matches(userNameRegStr);
    }

    public static boolean checkDate(String dateStr) {
        if (null == dateStr || "".equals(dateStr)) {
            return false;
        }
        boolean flag = false;
        Pattern pattern0 = null;
        Matcher match0 = null;
        String datePattern = "((^\\d{3}[1-9]|\\d{2}[1-9]\\d{1}|\\d{1}[1-9]\\d{2}|[1-9]\\d{3}([-/\\._]?)(10|12|0?[13578])([-/\\._]?)((3[01]|[12][0-9]|0?[1-9])?)([\\s]?)((([0-1]?[0-9]|2[0-3]):([0-5]?[0-9]):([0-5]?[0-9]))?))$|(^\\d{3}[1-9]|\\d{2}[1-9]\\d{1}|\\d{1}[1-9]\\d{2}|[1-9]\\d{3}([-/\\._]?)(11|0?[469])([-/\\._]?)(30|[12][0-9]|0?[1-9])([\\s]?)((([0-1]?[0-9]|2[0-3]):([0-5]?[0-9]):([0-5]?[0-9]))?))$|(^\\d{3}[1-9]|\\d{2}[1-9]\\d{1}|\\d{1}[1-9]\\d{2}|[1-9]\\d{3}([-/\\._]?)(0?2)([-/\\._]?)(2[0-8]|1[0-9]|0?[1-9])([\\s]?)((([0-1]?[0-9]|2[0-3]):([0-5]?[0-9]):([0-5]?[0-9]))?))$|(^((\\d{2})(0[48]|[2468][048]|[13579][26]))|((0[48]|[2468][048]|[13579][26])00)([-/\\._]?)(0?2)([-/\\._]?)(29)([\\s]?)((([0-1]?\\d|2[0-3]):([0-5]?\\d):([0-5]?\\d))?))$)";
        pattern0 = Pattern.compile(datePattern);
        match0 = pattern0.matcher(dateStr);
        flag = match0.matches();
        return flag;
    }

    public static boolean checkIdCard(String idCardStr) {
        String idCardReg = "(^\\d{18}$)|(^\\d{15}$)";
        return idCardStr.matches(idCardReg);
    }

    public static void main(String[] args) {
        boolean result = CheckUtils.checkDate("2016/01/-08 ");
        System.out.println(result);
    }

    public static boolean checkFixedPhone(String fixedPhone) {
        String reg = "(?:(\\(\\+?86\\))(0[0-9]{2,3}\\-?)?([2-9][0-9]{6,7})+(\\-[0-9]{1,4})?)|(?:(86-?)?(0[0-9]{2,3}\\-?)?([2-9][0-9]{6,7})+(\\-[0-9]{1,4})?)";
        return Pattern.matches(reg, fixedPhone);
    }

    public static boolean checkSQL(String str) {
        str = str.toLowerCase();
        String badStr = "'|\"|and|exec|execute|insert|select|delete|update|count|drop|*|%|chr|mid|master|truncate|char|declare|sitename|net user|xp_cmdshell|;|or|,|like'|and|exec|execute|insert|create|drop|table|from|grant|use|group_concat|column_name|xp_shell|(|)|information_schema.columns|table_schema|union|where|select|delete|update|order|count|*|chr|mid|master|truncate|char|declare|--|+|,|like|//|/|%|#";
        String[] badStrs = badStr.split("\\|");
        for (int i = 0; i < badStrs.length; ++i) {
            if (str.indexOf(badStrs[i]) < 0 && str.indexOf("\\|\\|") < 0) continue;
            return true;
        }
        return false;
    }

    public boolean isNumeric(Object obj) {
        Pattern pattern = Pattern.compile("[0-9]*");
        Matcher isNum = pattern.matcher(ConverterUtils.toString(obj));
        return isNum.matches();
    }
}

