/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.hussar.support.transdict.service.trans.service.impl;

import com.jxdinfo.hussar.support.transdict.core.vo.TransDictVo;
import com.jxdinfo.hussar.support.transdict.service.trans.manager.ClassInfo;
import com.jxdinfo.hussar.support.transdict.service.trans.manager.ClassManager;
import com.jxdinfo.hussar.support.transdict.service.trans.service.impl.ITransTypeService;
import java.lang.reflect.Field;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class TransService {
    private static final Map<String, ITransTypeService> transTypeServiceMap = new HashMap<String, ITransTypeService>();

    public static void registerTransType(String type, ITransTypeService transTypeService) {
        transTypeServiceMap.put(type, transTypeService);
    }

    public void transOne(TransDictVo obj) {
        if (obj == null) {
            return;
        }
        ClassInfo info = ClassManager.getClassInfoByName(obj.getClass());
        String[] transTypes = info.getTransTypes();
        if (transTypes == null) {
            return;
        }
        List<Field> transFieldList = null;
        for (String type : transTypes) {
            transFieldList = info.getTransField(type);
            if (transFieldList == null || transFieldList.size() == 0) continue;
            transTypeServiceMap.get(type).transOne(obj, transFieldList);
        }
    }

    public void transMore(List<? extends TransDictVo> objList) {
        if (objList == null || objList.size() == 0) {
            return;
        }
        TransDictVo object = objList.get(0);
        ClassInfo info = ClassManager.getClassInfoByName(object.getClass());
        String[] transTypes = info.getTransTypes();
        if (transTypes == null) {
            return;
        }
        List<Field> transFieldList = null;
        for (String type : transTypes) {
            transFieldList = info.getTransField(type);
            if (transFieldList == null || transFieldList.size() == 0) continue;
            transTypeServiceMap.get(type).transMore(objList, transFieldList);
        }
    }
}

