/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.hussar.support.transdict.service.trans.service.impl;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.TypeReference;
import com.alibaba.fastjson.parser.Feature;
import com.jxdinfo.hussar.support.cache.support.HussarCache;
import com.jxdinfo.hussar.support.transdict.core.anno.FieldsTrans;
import com.jxdinfo.hussar.support.transdict.core.anno.Trans;
import com.jxdinfo.hussar.support.transdict.core.util.ReflectUtils;
import com.jxdinfo.hussar.support.transdict.core.vo.TransDictVo;
import com.jxdinfo.hussar.support.transdict.service.properties.TransdictProperties;
import com.jxdinfo.hussar.support.transdict.service.support.CheckVo;
import com.jxdinfo.hussar.support.transdict.service.support.QueryVo;
import com.jxdinfo.hussar.support.transdict.service.support.SpringContextUtil;
import com.jxdinfo.hussar.support.transdict.service.support.TransFieldSet;
import com.jxdinfo.hussar.support.transdict.service.trans.service.FieldsTransAble;
import com.jxdinfo.hussar.support.transdict.service.trans.service.impl.ITransTypeService;
import com.jxdinfo.hussar.support.transdict.service.trans.service.impl.TransService;
import com.jxdinfo.hussar.support.transdict.service.utils.CacheUtils;
import com.jxdinfo.hussar.support.transdict.service.utils.CheckUtils;
import com.jxdinfo.hussar.support.transdict.service.utils.ConverterUtils;
import com.jxdinfo.hussar.support.transdict.service.utils.SpringClassScanUtil;
import com.jxdinfo.hussar.support.transdict.service.utils.StringUtil;
import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.InitializingBean;
import org.springframework.boot.context.event.ApplicationReadyEvent;
import org.springframework.cache.CacheManager;
import org.springframework.context.ApplicationListener;
import org.springframework.util.ObjectUtils;

public class FieldsTransService
implements ITransTypeService,
InitializingBean,
ApplicationListener<ApplicationReadyEvent> {
    private static final Logger LOGGER = LoggerFactory.getLogger(FieldsTransService.class);
    private final Map<String, String> dictionaryTransMap = new ConcurrentHashMap<String, String>();
    private String packageNames;
    private TransdictProperties transdictProperties;
    private CacheManager hussarCacheManager;
    private final Map<String, FieldsTransAble> baseServiceMap = new HashMap<String, FieldsTransAble>();
    private final ThreadLocal<Map<String, Map<String, String>>> threadLocalCache = new ThreadLocal();
    private final Map<String, FieldsTrans> dictionaryTransSetMap = new ConcurrentHashMap<String, FieldsTrans>();
    private final Map<Field, TransFieldSet> transFieldSetMap = new HashMap<Field, TransFieldSet>();

    public void refreshCache(String dicTypeCode, Map<String, String> dicMap) {
        dicMap.keySet().forEach(key -> this.dictionaryTransMap.put(dicTypeCode + "_" + key, (String)dicMap.get(key)));
    }

    @Override
    public void transOne(TransDictVo obj, List<Field> toTransList) {
        boolean isClearThreadLocal = false;
        if (this.threadLocalCache.get() == null) {
            this.threadLocalCache.set(new HashMap());
            isClearThreadLocal = true;
        }
        for (Field tempField : toTransList) {
            Map<String, String> transCache;
            TransFieldSet transFieldSet;
            tempField.setAccessible(true);
            CheckVo checkVo = this.checkRules(tempField, obj);
            if (!checkVo.isTrans()) continue;
            if (this.transFieldSetMap.containsKey(tempField)) {
                transFieldSet = this.transFieldSetMap.get(tempField);
            } else {
                transFieldSet = new TransFieldSet(tempField);
                this.transFieldSetMap.put(tempField, transFieldSet);
            }
            String namespace = transFieldSet.getNamespace();
            String alias = transFieldSet.getAlias();
            if (this.dictionaryTransSetMap.containsKey(namespace) && CheckUtils.isNullOrEmpty(alias)) {
                transFieldSet.setAlias(this.dictionaryTransSetMap.get(namespace).defaultAlias());
            }
            List<QueryVo> queryVoList = checkVo.getQueryFieldList();
            String fieldValue = queryVoList.get(0).getFieldValue().toString();
            if ((fieldValue = fieldValue.replace("[", "").replace("]", "")).contains(",")) {
                String[] pkeys = fieldValue.split(",");
                transCache = new LinkedHashMap<String, String>();
                for (String tempPkey : pkeys) {
                    queryVoList.get(0).setFieldValue(tempPkey);
                    Map<String, String> tempTransCache = this.convertKeyToValueByNamespace(queryVoList, transFieldSet);
                    if (tempTransCache == null) {
                        LOGGER.error("auto trans\u7f13\u5b58\u672a\u547d\u4e2d:" + this.getCacheKey(queryVoList, transFieldSet));
                        continue;
                    }
                    for (String key : tempTransCache.keySet()) {
                        transCache.put(key, transCache.containsKey(key) ? transCache.get(key) + "," + tempTransCache.get(key) : tempTransCache.get(key));
                    }
                }
            } else {
                transCache = this.convertKeyToValueByNamespace(queryVoList, transFieldSet);
                if (transCache == null) {
                    LOGGER.error("auto trans\u7f13\u5b58\u672a\u547d\u4e2d:" + this.getCacheKey(queryVoList, transFieldSet));
                    continue;
                }
            }
            this.setRef(transFieldSet, obj, transCache);
        }
        if (isClearThreadLocal) {
            this.threadLocalCache.set(null);
        }
    }

    @Override
    public void transMore(List<? extends TransDictVo> objList, List<Field> toTransList) {
        this.threadLocalCache.set(new HashMap());
        objList.forEach(obj -> this.transOne((TransDictVo)obj, toTransList));
        this.threadLocalCache.set(null);
    }

    public void afterPropertiesSet() throws Exception {
        TransService.registerTransType("field_trans", this);
    }

    public void init(ApplicationReadyEvent applicationReadyEvent) {
        Set<Class<?>> entitySet = SpringClassScanUtil.scan(FieldsTrans.class, this.packageNames.split(";"));
        if (entitySet != null) {
            for (Class<?> entity : entitySet) {
                Object baseService = SpringContextUtil.getBeanByName(entity);
                if (!(baseService instanceof FieldsTransAble)) continue;
                FieldsTrans fieldsTrans = entity.getAnnotation(FieldsTrans.class);
                String namespace = fieldsTrans.namespace();
                if (StringUtil.isEmpty(namespace) || this.baseServiceMap.containsKey(namespace)) {
                    LOGGER.warn(entity.getName() + "\u6807\u6ce8[namesapce\uff1a" + namespace + "] \u4e3a\u7a7a\uff0cnamespace\u5df2\u7ecf\u5b58\u5728");
                    continue;
                }
                if (TransDictVo.class.isAssignableFrom(entity)) {
                    LOGGER.warn(entity.getName() + "\u672a\u5b9e\u73b0TransDictVo\u7684\u63a5\u53e3");
                    continue;
                }
                FieldsTrans autoTransSett = entity.getAnnotation(FieldsTrans.class);
                this.baseServiceMap.put(autoTransSett.namespace(), (FieldsTransAble)baseService);
                this.dictionaryTransSetMap.put(autoTransSett.namespace(), autoTransSett);
            }
        }
    }

    private Map<String, String> convertKeyToValueByNamespace(List<QueryVo> queryVoList, TransFieldSet transFieldSet) {
        HussarCache hussarTranCache;
        String namespace = transFieldSet.getNamespace();
        String cacheKey = this.getCacheKey(queryVoList, transFieldSet);
        FieldsTrans fieldsTrans = this.dictionaryTransSetMap.get(namespace);
        if (this.threadLocalCache.get().containsKey(cacheKey)) {
            return this.threadLocalCache.get().get(cacheKey);
        }
        if (this.transdictProperties.getEnableCache().booleanValue() && fieldsTrans.useCache() && (hussarTranCache = CacheUtils.getHussarTranCache(this.transdictProperties, this.hussarCacheManager)).containKey((Object)cacheKey)) {
            return (Map)hussarTranCache.get((Object)cacheKey, Map.class);
        }
        Map<String, String> valueFromDb = this.getValueFromDb(queryVoList, fieldsTrans, transFieldSet);
        return valueFromDb;
    }

    private Map<String, String> getValueFromDb(List<QueryVo> queryVoList, FieldsTrans fieldsTrans, TransFieldSet transFieldSet) {
        String namespace = fieldsTrans.namespace();
        if (StringUtil.isEmpty(namespace)) {
            return null;
        }
        Object transDictVo = this.baseServiceMap.get(namespace).selectByFields(queryVoList);
        if (ObjectUtils.isEmpty(transDictVo)) {
            return null;
        }
        Map<String, String> transCacheMap = this.createTempTransCacheMap((TransDictVo)transDictVo, fieldsTrans);
        String cacheKey = this.getCacheKey(queryVoList, transFieldSet);
        this.threadLocalCache.get().put(cacheKey, transCacheMap);
        if (this.transdictProperties.getEnableCache().booleanValue() && fieldsTrans.useCache()) {
            CacheUtils.getHussarTranCache(this.transdictProperties, this.hussarCacheManager).put((Object)cacheKey, transCacheMap);
        }
        return transCacheMap;
    }

    private Map<String, String> createTempTransCacheMap(TransDictVo po, FieldsTrans fieldsTrans) {
        LinkedHashMap<String, String> tempCacheTransMap = new LinkedHashMap<String, String>();
        if (po == null) {
            return tempCacheTransMap;
        }
        if (fieldsTrans.fields().length == 0) {
            return (Map)JSON.parseObject((String)JSON.toJSONString((Object)po), (TypeReference)new TypeReference<Map<String, String>>(){}, (Feature[])new Feature[0]);
        }
        for (String field : fieldsTrans.fields()) {
            String fieldVal = ConverterUtils.toString(ReflectUtils.getValue((Object)po, (String)field));
            tempCacheTransMap.put(field, fieldVal);
        }
        return tempCacheTransMap;
    }

    private String getCacheKey(List<QueryVo> queryVoList, TransFieldSet transFieldSet) {
        String namespace = transFieldSet.getNamespace();
        StringBuilder stringBuilder = new StringBuilder(namespace);
        for (int i = 0; i < queryVoList.size(); ++i) {
            stringBuilder.append("_");
            stringBuilder.append(queryVoList.get(i).getFieldValue());
        }
        return stringBuilder.toString();
    }

    private CheckVo checkRules(Field tempField, TransDictVo obj) {
        String[] queryFields;
        Trans trans = tempField.getAnnotation(Trans.class);
        CheckVo.CheckVoBuilder builder = CheckVo.builder();
        if (trans == null || StringUtil.isEmpty(trans.namespace())) {
            builder.isTrans(false);
            return builder.build();
        }
        String namespace = trans.namespace();
        FieldsTrans fieldsTrans = this.dictionaryTransSetMap.get(namespace);
        if (fieldsTrans == null) {
            builder.isTrans(false);
            LOGGER.warn("namespace\uff1a" + namespace + "\u5bf9\u5e94\u7684service\u672a\u6807\u6ce8[@FieldsTrans]");
            return builder.build();
        }
        FieldsTransAble fieldsTransAble = this.baseServiceMap.get(namespace);
        if (fieldsTransAble == null) {
            builder.isTrans(false);
            LOGGER.warn("namespace\uff1a" + namespace + "\u5bf9\u5e94\u7684service\u672a\u5b9e\u73b0FieldsTransAble\u63a5\u53e3");
            return builder.build();
        }
        String[] stringArray = queryFields = fieldsTrans.queryFields() != null && fieldsTrans.queryFields().length > 0 ? fieldsTrans.queryFields() : trans.queryFields();
        if (queryFields == null || queryFields.length < 0) {
            builder.isTrans(false);
            LOGGER.warn("namespace\uff1a" + namespace + "@trans\u7684\u67e5\u8be2\u5b57\u6bb5\u4e3a\u7a7a");
            return builder.build();
        }
        String trankey = trans.key();
        String[] keyRef = trans.keyRef();
        int len = 0;
        if (!StringUtil.isEmpty(trankey)) {
            ++len;
        }
        if (keyRef != null && keyRef.length > 0) {
            len += keyRef.length;
        }
        if (queryFields.length - len == 1) {
            builder.isTrans(true);
            String fieldValue = ConverterUtils.toString(ReflectUtils.getValue((Object)obj, (String)tempField.getName()));
            if (StringUtil.isEmpty(fieldValue)) {
                builder.isTrans(false);
                LOGGER.warn("namespace\uff1a" + namespace + "\u6807\u6ce8\u7684\u5b9e\u4f53\u7c7b\u7684\u5b57\u6bb5\u4e3a\u7a7a");
                return builder.build();
            }
            int startIndex = 0;
            ArrayList<QueryVo> queryVoList = new ArrayList<QueryVo>();
            QueryVo queryVo = new QueryVo(queryFields[startIndex], fieldValue);
            queryVoList.add(queryVo);
            ++startIndex;
            if (!StringUtil.isEmpty(trankey)) {
                queryVo = new QueryVo(queryFields[startIndex], trankey);
                queryVoList.add(queryVo);
                ++startIndex;
            }
            int keyRefIndex = 0;
            if (keyRef != null && keyRef.length > 0) {
                for (int i = startIndex; i < queryFields.length; ++i) {
                    queryVo = new QueryVo(queryFields[startIndex], ReflectUtils.getValue((Object)obj, (String)keyRef[keyRefIndex]));
                    queryVoList.add(queryVo);
                    ++keyRefIndex;
                    ++startIndex;
                }
            }
            builder.queryFieldList(queryVoList);
            return builder.build();
        }
        builder.isTrans(false);
        LOGGER.warn("namespace\uff1a" + namespace + "queryField\u7684\u4e2a\u6570\u548c\u5b57\u6bb5\u7684\u503c\u4e0d\u76f8\u7b49");
        return builder.build();
    }

    public void onApplicationEvent(ApplicationReadyEvent event) {
        this.init(event);
    }

    public String getPackageNames() {
        return this.packageNames;
    }

    public void setPackageNames(String packageNames) {
        this.packageNames = packageNames;
    }

    public TransdictProperties getTransdictProperties() {
        return this.transdictProperties;
    }

    public void setTransdictProperties(TransdictProperties transdictProperties) {
        this.transdictProperties = transdictProperties;
    }

    public CacheManager getHussarCacheManager() {
        return this.hussarCacheManager;
    }

    public void setHussarCacheManager(CacheManager hussarCacheManager) {
        this.hussarCacheManager = hussarCacheManager;
    }

    public void regTransable(FieldsTransAble transAble, FieldsTrans autoTransSett) {
        this.baseServiceMap.put(autoTransSett.namespace(), transAble);
        this.dictionaryTransSetMap.put(autoTransSett.namespace(), autoTransSett);
    }

    public boolean hasTransable(String namespace) {
        return this.baseServiceMap.containsKey(namespace);
    }
}

