/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.hussar.support.transdict.service.trans.manager;

import com.jxdinfo.hussar.support.transdict.service.exception.ParamException;
import com.jxdinfo.hussar.support.transdict.service.trans.manager.ClassInfo;
import java.io.Serializable;
import java.util.HashMap;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeanUtils;

public class ClassManager
implements Serializable {
    private static final long serialVersionUID = 1L;
    public static final Logger LOGGER = LoggerFactory.getLogger(ClassManager.class);
    private static final Map<String, ClassInfo> CACHE = new HashMap<String, ClassInfo>();

    public static ClassInfo getClassInfoByName(Class<?> clazz) {
        ClassInfo temp = CACHE.get(clazz.getName());
        ClassInfo info = null;
        if (null == temp) {
            try {
                temp = new ClassInfo(clazz);
            }
            catch (IllegalAccessException | InstantiationException e) {
                LOGGER.error(clazz.getName() + "\u751f\u6210classinfo\u9519\u8bef", (Throwable)e);
                throw new ParamException(clazz.getName() + "\u751f\u6210classinfo\u9519\u8bef");
            }
            ClassManager.setClassInfoByName(clazz.getName(), temp);
        }
        try {
            info = new ClassInfo();
            BeanUtils.copyProperties((Object)temp, (Object)info);
        }
        catch (Exception e) {
            e.printStackTrace();
            LOGGER.error(e.getMessage());
        }
        return info;
    }

    public static void setClassInfoByName(String className, ClassInfo info) {
        CACHE.put(className, info);
    }

    public static void reMoveDbTableByName(String className) {
        CACHE.remove(className);
    }

    public static void main(String[] args) {
        ClassManager.getClassInfoByName(Long.class);
    }
}

