/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.hussar.support.transdict.service.trans.service.impl;

import com.jxdinfo.hussar.support.cache.support.HussarCache;
import com.jxdinfo.hussar.support.cache.support.HussarCacheManager;
import com.jxdinfo.hussar.support.transdict.core.anno.IdTrans;
import com.jxdinfo.hussar.support.transdict.core.util.ReflectUtils;
import com.jxdinfo.hussar.support.transdict.core.vo.TransDictVo;
import com.jxdinfo.hussar.support.transdict.service.properties.TransdictProperties;
import com.jxdinfo.hussar.support.transdict.service.support.SpringContextUtil;
import com.jxdinfo.hussar.support.transdict.service.support.TransFieldSet;
import com.jxdinfo.hussar.support.transdict.service.trans.service.IdTransAble;
import com.jxdinfo.hussar.support.transdict.service.trans.service.impl.ITransTypeService;
import com.jxdinfo.hussar.support.transdict.service.trans.service.impl.TransService;
import com.jxdinfo.hussar.support.transdict.service.utils.CacheUtils;
import com.jxdinfo.hussar.support.transdict.service.utils.CheckUtils;
import com.jxdinfo.hussar.support.transdict.service.utils.ConverterUtils;
import com.jxdinfo.hussar.support.transdict.service.utils.SpringClassScanUtil;
import com.jxdinfo.hussar.support.transdict.service.utils.StringUtil;
import java.lang.reflect.Field;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.InitializingBean;
import org.springframework.boot.context.event.ApplicationReadyEvent;
import org.springframework.context.ApplicationListener;
import org.springframework.util.ObjectUtils;
import org.springframework.util.StringUtils;

public class IdTransService
implements ITransTypeService,
InitializingBean,
ApplicationListener<ApplicationReadyEvent> {
    public static final Logger LOGGER = LoggerFactory.getLogger(IdTransService.class);
    private String packageNames;
    private TransdictProperties transdictProperties;
    private HussarCacheManager hussarCacheManager;
    private Map<String, IdTransAble> baseServiceMap = new HashMap<String, IdTransAble>();
    private Map<String, IdTrans> autoTransSetMap = new ConcurrentHashMap<String, IdTrans>();
    private ThreadLocal<Map<String, Map<String, String>>> threadLocalCache = new ThreadLocal();
    private Map<Field, TransFieldSet> transFieldSetMap = new HashMap<Field, TransFieldSet>();

    @Override
    public void transOne(TransDictVo obj, List<Field> toTransList) {
        boolean isClearThreadLocal = false;
        if (this.threadLocalCache.get() == null) {
            this.threadLocalCache.set(new HashMap());
            isClearThreadLocal = true;
        }
        for (Field tempField : toTransList) {
            Map<String, String> transCache;
            String pkey;
            TransFieldSet transFieldSet;
            tempField.setAccessible(true);
            if (this.transFieldSetMap.containsKey(tempField)) {
                transFieldSet = this.transFieldSetMap.get(tempField);
            } else {
                transFieldSet = new TransFieldSet(tempField);
                this.transFieldSetMap.put(tempField, transFieldSet);
            }
            String namespace = transFieldSet.getNamespace();
            String alias = transFieldSet.getAlias();
            if (this.autoTransSetMap.containsKey(namespace) && CheckUtils.isNullOrEmpty(alias)) {
                transFieldSet.setAlias(this.autoTransSetMap.get(namespace).defaultAlias());
            }
            if (StringUtils.isEmpty((Object)(pkey = ConverterUtils.toString(ReflectUtils.getValue((Object)obj, (String)tempField.getName()))))) continue;
            if ((pkey = pkey.replace("[", "").replace("]", "")).contains(",")) {
                String[] pkeys = pkey.split(",");
                transCache = new LinkedHashMap<String, String>();
                for (String tempPkey : pkeys) {
                    Map<String, String> tempTransCache = this.convertKeyToValueByNamespace(namespace, tempPkey);
                    if (tempTransCache == null) {
                        LOGGER.error("auto trans\u7f13\u5b58\u672a\u547d\u4e2d:" + namespace + "_" + tempPkey);
                        continue;
                    }
                    for (String key : tempTransCache.keySet()) {
                        transCache.put(key, transCache.containsKey(key) ? transCache.get(key) + "," + tempTransCache.get(key) : tempTransCache.get(key));
                    }
                }
            } else {
                transCache = this.convertKeyToValueByNamespace(namespace, pkey);
                if (transCache == null) {
                    LOGGER.error("auto trans\u7f13\u5b58\u672a\u547d\u4e2d:" + namespace + "_" + pkey);
                    continue;
                }
            }
            this.setRef(transFieldSet, obj, transCache);
        }
        if (isClearThreadLocal) {
            this.threadLocalCache.set(null);
        }
    }

    @Override
    public void transMore(List<? extends TransDictVo> objList, List<Field> toTransList) {
        this.threadLocalCache.set(new HashMap());
        objList.forEach(obj -> this.transOne((TransDictVo)obj, toTransList));
        this.threadLocalCache.set(null);
    }

    public void afterPropertiesSet() {
        TransService.registerTransType("id_trans", this);
    }

    public void init(ApplicationReadyEvent applicationReadyEvent) {
        Set<Class<?>> entitySet = SpringClassScanUtil.scan(IdTrans.class, this.packageNames.split(";"));
        if (entitySet != null) {
            for (Class<?> entity : entitySet) {
                Object baseService = SpringContextUtil.getBeanByName(entity);
                if (!(baseService instanceof IdTransAble)) continue;
                IdTrans autoTransSett = entity.getAnnotation(IdTrans.class);
                String namespace = autoTransSett.namespace();
                if (StringUtil.isEmpty(namespace) || this.baseServiceMap.containsKey(namespace)) {
                    LOGGER.warn(entity.getName() + "\u6807\u6ce8[namesapce\uff1a" + namespace + "] \u4e3a\u7a7a\uff0cnamespace\u5df2\u7ecf\u5b58\u5728");
                    continue;
                }
                if (TransDictVo.class.isAssignableFrom(entity)) {
                    LOGGER.warn(entity.getName() + "\u672a\u5b9e\u73b0TransDictVo\u7684\u63a5\u53e3");
                    continue;
                }
                this.baseServiceMap.put(autoTransSett.namespace(), (IdTransAble)baseService);
                this.autoTransSetMap.put(autoTransSett.namespace(), autoTransSett);
            }
        }
    }

    public void refreshCache(Map<String, Object> messageMap) {
        String namespace;
        String string = namespace = messageMap.get("namespace") != null ? messageMap.get("namespace").toString() : null;
        if (namespace == null) {
            Set<String> namespaceSet = this.autoTransSetMap.keySet();
            namespaceSet.forEach(temp -> this.refreshOneNamespace((String)temp));
        } else {
            try {
                Thread.sleep(1000L);
            }
            catch (InterruptedException e) {
                LOGGER.error("\u5237\u65b0\u7f13\u5b58\u9519\u8bef:", (Throwable)e);
            }
            this.refreshOneNamespace(namespace);
        }
    }

    public void refreshOneNamespace(String namespace) {
        LOGGER.info("\u5f00\u59cb\u5237\u65b0auto-trans\u7f13\u5b58:" + namespace);
        if (!this.autoTransSetMap.containsKey(namespace)) {
            LOGGER.info("\u672c\u7cfb\u7edf\u65e0\u9700\u5237\u65b0\u6b64\u7f13\u5b58namespace:" + namespace);
            return;
        }
        IdTrans autoTrans = this.autoTransSetMap.get(namespace);
        if (!autoTrans.useCache()) {
            return;
        }
        List vos = this.baseServiceMap.get(namespace).selectAll();
        if (vos == null || vos.isEmpty()) {
            return;
        }
        HussarCache hussarTranCache = CacheUtils.getHussarTranCache(this.transdictProperties, this.hussarCacheManager);
        for (int i = 0; i < vos.size(); ++i) {
            TransDictVo po = (TransDictVo)vos.get(i);
            Object pkeyVal = po.getPkey();
            if (!autoTrans.useCache() || hussarTranCache == null) continue;
            String cachekey = this.getCacheKey(namespace, pkeyVal);
            hussarTranCache.put((Object)cachekey, this.createTempTransCacheMap(po, autoTrans), this.transdictProperties.getDictCacheDictTtl());
            LOGGER.info("\u5237\u65b0auto-trans\u7f13\u5b58\u5b8c\u6210:" + namespace);
        }
    }

    private Map<String, String> createTempTransCacheMap(TransDictVo po, IdTrans autoTrans) {
        LinkedHashMap<String, String> tempCacheTransMap = new LinkedHashMap<String, String>();
        if (po == null) {
            return tempCacheTransMap;
        }
        for (String field : autoTrans.fields()) {
            String fieldVal = ConverterUtils.toString(ReflectUtils.getValue((Object)po, (String)field));
            tempCacheTransMap.put(field, fieldVal);
        }
        return tempCacheTransMap;
    }

    private Map<String, String> convertKeyToValueByNamespace(String namespace, Object pkey) {
        HussarCache hussarTranCache;
        IdTrans autoTrans = this.autoTransSetMap.get(namespace);
        String cacheKey = this.getCacheKey(namespace, pkey);
        if (this.threadLocalCache.get().containsKey(cacheKey)) {
            return this.threadLocalCache.get().get(cacheKey);
        }
        if (this.transdictProperties.getEnableCache().booleanValue() && autoTrans.useCache() && (hussarTranCache = CacheUtils.getHussarTranCache(this.transdictProperties, this.hussarCacheManager)).containKey((Object)cacheKey)) {
            return (Map)hussarTranCache.get((Object)cacheKey, Map.class);
        }
        Map<String, String> valueFromDb = this.getValueFromDb(pkey, autoTrans);
        return valueFromDb;
    }

    private Map<String, String> getValueFromDb(Object po, IdTrans autoTrans) {
        String namespace = autoTrans.namespace();
        if (StringUtil.isEmpty(namespace)) {
            return null;
        }
        Object transDictVo = this.baseServiceMap.get(namespace).selectById(po);
        if (ObjectUtils.isEmpty(transDictVo)) {
            return null;
        }
        Map<String, String> transCacheMap = this.createTempTransCacheMap((TransDictVo)transDictVo, autoTrans);
        String cacheKey = this.getCacheKey(namespace, transDictVo.getPkey());
        this.threadLocalCache.get().put(cacheKey, transCacheMap);
        if (this.transdictProperties.getEnableCache().booleanValue() && autoTrans.useCache()) {
            CacheUtils.getHussarTranCache(this.transdictProperties, this.hussarCacheManager).put((Object)cacheKey, transCacheMap);
        }
        return transCacheMap;
    }

    private String getCacheKey(String namespace, Object pkValue) {
        return namespace + "_" + pkValue;
    }

    public void onApplicationEvent(ApplicationReadyEvent applicationReadyEvent) {
        this.init(applicationReadyEvent);
    }

    public void setPackageNames(String packageNames) {
        this.packageNames = packageNames;
    }

    public TransdictProperties getTransdictProperties() {
        return this.transdictProperties;
    }

    public void setTransdictProperties(TransdictProperties transdictProperties) {
        this.transdictProperties = transdictProperties;
    }

    public HussarCacheManager getHussarCacheManager() {
        return this.hussarCacheManager;
    }

    public void setHussarCacheManager(HussarCacheManager hussarCacheManager) {
        this.hussarCacheManager = hussarCacheManager;
    }

    public void regTransable(IdTransAble transAble, IdTrans autoTransSett) {
        this.baseServiceMap.put(autoTransSett.namespace(), transAble);
        this.autoTransSetMap.put(autoTransSett.namespace(), autoTransSett);
    }
}

