/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.hussar.support.transdict.service.trans.clearCache;

import com.jxdinfo.hussar.support.cache.support.HussarCache;
import com.jxdinfo.hussar.support.cache.support.HussarCacheManager;
import com.jxdinfo.hussar.support.transdict.core.anno.FieldsTrans;
import com.jxdinfo.hussar.support.transdict.core.anno.IdTrans;
import com.jxdinfo.hussar.support.transdict.service.properties.TransdictProperties;
import com.jxdinfo.hussar.support.transdict.service.trans.clearCache.vo.ServiceAnnoVo;
import com.jxdinfo.hussar.support.transdict.service.trans.matcher.ClearCacheMethodMatcher;
import com.jxdinfo.hussar.support.transdict.service.utils.CacheUtils;
import java.util.ArrayList;
import java.util.List;
import java.util.stream.Collectors;
import org.aopalliance.intercept.MethodInterceptor;
import org.aopalliance.intercept.MethodInvocation;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.util.CollectionUtils;
import org.springframework.util.StringUtils;

public class ClearCacheAnnotationInterceptor
implements MethodInterceptor {
    private static final Logger log = LoggerFactory.getLogger(ClearCacheAnnotationInterceptor.class);
    private TransdictProperties transdictProperties;
    private HussarCacheManager hussarCacheManager;
    private static List<String> methodsNameDefault = new ArrayList<String>();

    public ClearCacheAnnotationInterceptor(TransdictProperties transdictProperties, HussarCacheManager hussarCacheManager) {
        this.transdictProperties = transdictProperties;
        this.hussarCacheManager = hussarCacheManager;
    }

    public ClearCacheAnnotationInterceptor() {
    }

    public Object invoke(MethodInvocation invocation) throws Throwable {
        try {
            log.info("ClearCacheAnnotationInterceptor,\u62e6\u622a\u4e86\u7c7b[" + invocation.getThis().getClass().getSimpleName() + "]\u65b9\u6cd5" + invocation.getMethod().getName());
            Object object = invocation.proceed();
            return object;
        }
        finally {
            this.clearCacheByNameSpace(invocation);
        }
    }

    private ServiceAnnoVo getServiceAnnoVo(MethodInvocation invocation) {
        IdTrans idTransAnno = invocation.getThis().getClass().getAnnotation(IdTrans.class);
        if (idTransAnno != null) {
            ServiceAnnoVo serviceAnnoVo = ServiceAnnoVo.builder().nameSpace(idTransAnno.namespace()).useCache(idTransAnno.useCache()).build();
            return serviceAnnoVo;
        }
        FieldsTrans fieldsTransAnno = invocation.getThis().getClass().getAnnotation(FieldsTrans.class);
        if (fieldsTransAnno != null) {
            ServiceAnnoVo serviceAnnoVo = ServiceAnnoVo.builder().nameSpace(fieldsTransAnno.namespace()).useCache(fieldsTransAnno.useCache()).build();
            return serviceAnnoVo;
        }
        return null;
    }

    private void clearCacheByNameSpace(MethodInvocation invocation) {
        List<String> interceptMethodName = this.getInterceptMethodName();
        ClearCacheMethodMatcher clearCacheMethodMatcher = ClearCacheMethodMatcher.getInstance();
        String methodName = invocation.getMethod().getName();
        boolean b = interceptMethodName.stream().anyMatch(iterceptName -> clearCacheMethodMatcher.matches((String)iterceptName, methodName));
        ServiceAnnoVo serviceAnnoVo = this.getServiceAnnoVo(invocation);
        if (!b) {
            log.warn("ClearCacheAnnotationInterceptor \u62e6\u622a\u7684service:[" + invocation.getThis().getClass().getSimpleName() + "]\u7684\u65b9\u6cd5[" + invocation.getMethod().getName() + "]\u65e0\u987b\u6e05\u7406\u7f13\u5b58");
            return;
        }
        if (serviceAnnoVo == null || StringUtils.isEmpty((Object)serviceAnnoVo.getNameSpace())) {
            log.warn("ClearCacheAnnotationInterceptor \u62e6\u622a\u7684service:[" + invocation.getThis().getClass().getSimpleName() + "]\u7684\u65b9\u6cd5[" + invocation.getMethod().getName() + "]\u7684namespace\u4e3a\u7a7a\uff0c\u65e0\u6cd5\u6e05\u7a7a\u7f13\u5b58");
            return;
        }
        HussarCache hussarTranCache = CacheUtils.getHussarTranCache(this.transdictProperties, this.hussarCacheManager);
        if (hussarTranCache == null || serviceAnnoVo != null && !serviceAnnoVo.isUseCache()) {
            log.warn("ClearCacheAnnotationInterceptor \u62e6\u622a\u7684service:[" + invocation.getThis().getClass().getSimpleName() + "]\u7684\u65b9\u6cd5[" + invocation.getMethod().getName() + "]\u7684\u672a\u5f00\u542f\u7f13\u5b58\u4e3a\u7a7a\u65e0\u987b\u5904\u7406");
            return;
        }
        String clearkeyLike = serviceAnnoVo.getNameSpace() + "*";
        log.info("\u6b63\u5728\u6e05\u7406\u7f13\u5b58key = [" + clearkeyLike + "].........");
        hussarTranCache.evictKeys(clearkeyLike);
        log.info("\u6e05\u7406\u7f13\u5b58key = [" + clearkeyLike + "]\u5df2\u7ecf\u5b8c\u6210.........");
    }

    private List<String> getInterceptMethodName() {
        List<String> clearCacheMethodNames = this.transdictProperties.getClearCacheMethodName();
        if (CollectionUtils.isEmpty(clearCacheMethodNames)) {
            return methodsNameDefault;
        }
        ArrayList<String> interceptMethods = new ArrayList<String>();
        interceptMethods.addAll(methodsNameDefault);
        interceptMethods.addAll(clearCacheMethodNames);
        return interceptMethods.stream().distinct().collect(Collectors.toList());
    }

    public TransdictProperties getTransdictProperties() {
        return this.transdictProperties;
    }

    public void setTransdictProperties(TransdictProperties transdictProperties) {
        this.transdictProperties = transdictProperties;
    }

    public HussarCacheManager getHussarCacheManager() {
        return this.hussarCacheManager;
    }

    public void setHussarCacheManager(HussarCacheManager hussarCacheManager) {
        this.hussarCacheManager = hussarCacheManager;
    }

    static {
        methodsNameDefault.add("*insert*");
        methodsNameDefault.add("*save*");
        methodsNameDefault.add("*update*");
        methodsNameDefault.add("*delete*");
        methodsNameDefault.add("*remove*");
    }
}

