/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.hussar.support.transdict.service.trans.aop;

import com.jxdinfo.hussar.support.transdict.core.util.ReflectUtils;
import com.jxdinfo.hussar.support.transdict.core.vo.TransDictVo;
import com.jxdinfo.hussar.support.transdict.service.trans.aop.DefaultVO;
import com.jxdinfo.hussar.support.transdict.service.trans.service.impl.TransService;
import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import org.aspectj.lang.ProceedingJoinPoint;
import org.aspectj.lang.annotation.Around;
import org.aspectj.lang.annotation.Aspect;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;

@Aspect
public class TransMethodResultAop {
    private static final Logger log = LoggerFactory.getLogger(TransMethodResultAop.class);
    @Autowired
    private TransService transService;

    @Around(value="@annotation(com.jxdinfo.hussar.support.transdict.core.anno.TransMethodResult)")
    public Object transResult(ProceedingJoinPoint joinPoint) throws Throwable {
        Object proceed = null;
        proceed = joinPoint.proceed();
        List<TransDictVo> transOneVOs = this.getTransOneVOs(proceed);
        for (TransDictVo transOneVO : transOneVOs) {
            this.transService.transOne(transOneVO);
        }
        List<List<TransDictVo>> voLists = this.getTransMoreVOS(proceed);
        for (List<TransDictVo> voList : voLists) {
            this.transService.transMore(voList);
        }
        return proceed;
    }

    private List<TransDictVo> getTransOneVOs(Object proceed) {
        ArrayList<TransDictVo> result = new ArrayList<TransDictVo>();
        if (proceed == null) {
            return result;
        }
        if (TransDictVo.class.isAssignableFrom(proceed.getClass())) {
            result.add((TransDictVo)proceed);
        }
        List fields = ReflectUtils.getAllField((Object)proceed);
        TransDictVo vo = null;
        for (Field field : fields) {
            if (!this.checkFieldIsVO(field, proceed)) continue;
            try {
                field.setAccessible(true);
                vo = (TransDictVo)field.get(proceed);
                if (vo == null) continue;
                result.add(vo);
            }
            catch (IllegalAccessException e) {
                log.error("\u83b7\u53d6\u503c\u9519\u8bef", (Throwable)e);
            }
        }
        return result;
    }

    public boolean checkFieldIsVO(Field field, Object proceed) {
        Class clazz = this.getFieldClass(field, proceed);
        if (clazz == null) {
            return false;
        }
        return TransDictVo.class.isAssignableFrom(clazz);
    }

    private List<List<TransDictVo>> getTransMoreVOS(Object proceed) {
        ArrayList<List<TransDictVo>> result = new ArrayList<List<TransDictVo>>();
        if (proceed == null) {
            return result;
        }
        if (Collection.class.isAssignableFrom(proceed.getClass())) {
            result.add(new ArrayList((Collection)proceed));
        }
        List fields = ReflectUtils.getAllField((Object)proceed);
        ArrayList voList = null;
        for (Field field : fields) {
            if (!this.checkFieldIsCollection(field, proceed)) continue;
            field.setAccessible(true);
            try {
                Collection collection = (Collection)field.get(proceed);
                if (collection == null || collection.isEmpty()) continue;
                voList = new ArrayList();
                voList.addAll(collection);
                result.add(voList);
            }
            catch (IllegalAccessException e) {
                log.error("", (Throwable)e);
            }
        }
        return result;
    }

    public Class getFieldClass(Field field, Object proceed) {
        String className = field.getGenericType().getTypeName().replace("class ", "");
        if ("T".equals(className)) {
            try {
                field.setAccessible(true);
                Object obj = field.get(proceed);
                if (obj == null) {
                    return Object.class;
                }
                if (TransDictVo.class.isAssignableFrom(obj.getClass())) {
                    return DefaultVO.class;
                }
                if (Collection.class.isAssignableFrom(obj.getClass())) {
                    return List.class;
                }
            }
            catch (IllegalAccessException e) {
                log.error("", (Throwable)e);
                return Object.class;
            }
        }
        if (className.contains("<")) {
            className = className.substring(0, className.indexOf("<"));
        }
        if (className.contains("/") || Character.isLowerCase(className.charAt(0)) && !className.contains(".") || className.contains("$")) {
            return null;
        }
        if (className.contains("]")) {
            className = className.substring(0, className.indexOf("["));
        }
        if (className.contains("]")) {
            className = className.substring(0, className.indexOf("<"));
        }
        try {
            Class<?> clazz = Class.forName(className);
            return clazz;
        }
        catch (ClassNotFoundException e) {
            log.error("", (Throwable)e);
            return null;
        }
    }

    public boolean checkFieldIsCollection(Field field, Object proceed) {
        Class clazz = this.getFieldClass(field, proceed);
        if (clazz == null) {
            return false;
        }
        return Collection.class.isAssignableFrom(clazz);
    }
}

