/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.hussar.transaction.plugin.datasource.aspect;

import com.jxdinfo.hussar.platform.core.utils.HussarUtils;
import com.jxdinfo.hussar.transaction.plugin.datasource.HussarPlatformTransactionManager;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.List;
import java.util.Properties;
import java.util.concurrent.ConcurrentMap;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.beans.factory.BeanFactory;
import org.springframework.beans.factory.BeanFactoryAware;
import org.springframework.beans.factory.InitializingBean;
import org.springframework.beans.factory.annotation.BeanFactoryAnnotationUtils;
import org.springframework.core.NamedThreadLocal;
import org.springframework.lang.Nullable;
import org.springframework.transaction.NoTransactionException;
import org.springframework.transaction.PlatformTransactionManager;
import org.springframework.transaction.ReactiveTransaction;
import org.springframework.transaction.ReactiveTransactionManager;
import org.springframework.transaction.TransactionDefinition;
import org.springframework.transaction.TransactionManager;
import org.springframework.transaction.TransactionStatus;
import org.springframework.transaction.TransactionSystemException;
import org.springframework.transaction.interceptor.CompositeTransactionAttributeSource;
import org.springframework.transaction.interceptor.DefaultTransactionAttribute;
import org.springframework.transaction.interceptor.DelegatingTransactionAttribute;
import org.springframework.transaction.interceptor.NameMatchTransactionAttributeSource;
import org.springframework.transaction.interceptor.TransactionAttribute;
import org.springframework.transaction.interceptor.TransactionAttributeSource;
import org.springframework.util.Assert;
import org.springframework.util.ClassUtils;
import org.springframework.util.ConcurrentReferenceHashMap;
import org.springframework.util.StringUtils;

public abstract class AbstractTransactionInterceptor
implements BeanFactoryAware,
InitializingBean {
    protected final Log logger = LogFactory.getLog(this.getClass());
    private static final Object DEFAULT_TRANSACTION_MANAGER_KEY = new Object();
    private static final boolean vavrPresent = ClassUtils.isPresent((String)"io.vavr.control.Try", (ClassLoader)AbstractTransactionInterceptor.class.getClassLoader());
    private static final ThreadLocal<TransactionInfo> transactionInfoHolder = new NamedThreadLocal("Current aspect-driven transaction");
    @Nullable
    private String transactionManagerBeanName;
    @Nullable
    private TransactionManager transactionManager;
    @Nullable
    private TransactionAttributeSource transactionAttributeSource;
    @Nullable
    private BeanFactory beanFactory;
    private final ConcurrentMap<Object, TransactionManager> transactionManagerCache = new ConcurrentReferenceHashMap(4);

    protected AbstractTransactionInterceptor() {
    }

    @Nullable
    protected static TransactionInfo currentTransactionInfo() throws NoTransactionException {
        return transactionInfoHolder.get();
    }

    public static TransactionStatus currentTransactionStatus() throws NoTransactionException {
        TransactionInfo info = AbstractTransactionInterceptor.currentTransactionInfo();
        if (info == null || info.transactionStatus == null) {
            throw new NoTransactionException("No transaction aspect-managed TransactionStatus in scope");
        }
        return info.transactionStatus;
    }

    public void setTransactionManagerBeanName(@Nullable String transactionManagerBeanName) {
        this.transactionManagerBeanName = transactionManagerBeanName;
    }

    @Nullable
    protected final String getTransactionManagerBeanName() {
        return this.transactionManagerBeanName;
    }

    public void setTransactionManager(@Nullable TransactionManager transactionManager) {
        this.transactionManager = transactionManager;
    }

    @Nullable
    public TransactionManager getTransactionManager() {
        return this.transactionManager;
    }

    public void setTransactionAttributes(Properties transactionAttributes) {
        NameMatchTransactionAttributeSource tas = new NameMatchTransactionAttributeSource();
        tas.setProperties(transactionAttributes);
        this.transactionAttributeSource = tas;
    }

    public void setTransactionAttributeSources(TransactionAttributeSource ... transactionAttributeSources) {
        this.transactionAttributeSource = new CompositeTransactionAttributeSource(transactionAttributeSources);
    }

    public void setTransactionAttributeSource(@Nullable TransactionAttributeSource transactionAttributeSource) {
        this.transactionAttributeSource = transactionAttributeSource;
    }

    @Nullable
    public TransactionAttributeSource getTransactionAttributeSource() {
        return this.transactionAttributeSource;
    }

    public void setBeanFactory(@Nullable BeanFactory beanFactory) {
        this.beanFactory = beanFactory;
    }

    @Nullable
    protected final BeanFactory getBeanFactory() {
        return this.beanFactory;
    }

    public void afterPropertiesSet() {
        if (this.getTransactionManager() == null && this.beanFactory == null) {
            throw new IllegalStateException("Set the 'transactionManager' property or make sure to run within a BeanFactory containing a TransactionManager bean!");
        }
        if (this.getTransactionAttributeSource() == null) {
            throw new IllegalStateException("Either 'transactionAttributeSource' or 'transactionAttributes' is required: If there are no transactional methods, then don't use a transaction aspect.");
        }
    }

    @Nullable
    protected Object invokeWithinTransaction(Method method, @Nullable Class<?> targetClass, InvocationCallback invocation) throws Throwable {
        Object retVal;
        TransactionAttributeSource tas = this.getTransactionAttributeSource();
        TransactionAttribute txAttr = tas != null ? tas.getTransactionAttribute(method, targetClass) : null;
        TransactionManager tm = this.determineTransactionManager(txAttr);
        HussarPlatformTransactionManager ptm = this.asPlatformTransactionManager(tm);
        String joinpointIdentification = this.methodIdentification(method, targetClass, txAttr);
        TransactionInfo txInfo = this.createTransactionIfNecessary(ptm, txAttr, joinpointIdentification);
        try {
            retVal = invocation.proceedWithInvocation();
        }
        catch (Throwable ex) {
            this.completeTransactionAfterThrowing(txInfo, ex);
            throw ex;
        }
        finally {
            this.cleanupTransactionInfo(txInfo);
        }
        this.commitTransactionAfterReturning(txInfo);
        return retVal;
    }

    protected void clearTransactionManagerCache() {
        this.transactionManagerCache.clear();
        this.beanFactory = null;
    }

    @Nullable
    protected TransactionManager determineTransactionManager(@Nullable TransactionAttribute txAttr) {
        if (txAttr == null || this.beanFactory == null) {
            return this.getTransactionManager();
        }
        String qualifier = txAttr.getQualifier();
        if (StringUtils.hasText((String)qualifier)) {
            return this.determineQualifiedTransactionManager(this.beanFactory, qualifier);
        }
        if (StringUtils.hasText((String)this.transactionManagerBeanName)) {
            return this.determineQualifiedTransactionManager(this.beanFactory, this.transactionManagerBeanName);
        }
        TransactionManager defaultTransactionManager = this.getTransactionManager();
        if (defaultTransactionManager == null && (defaultTransactionManager = (TransactionManager)this.transactionManagerCache.get(DEFAULT_TRANSACTION_MANAGER_KEY)) == null) {
            defaultTransactionManager = (TransactionManager)this.beanFactory.getBean(TransactionManager.class);
            this.transactionManagerCache.putIfAbsent(DEFAULT_TRANSACTION_MANAGER_KEY, defaultTransactionManager);
        }
        return defaultTransactionManager;
    }

    private TransactionManager determineQualifiedTransactionManager(BeanFactory beanFactory, String qualifier) {
        TransactionManager txManager = (TransactionManager)this.transactionManagerCache.get(qualifier);
        if (txManager == null) {
            txManager = (TransactionManager)BeanFactoryAnnotationUtils.qualifiedBeanOfType((BeanFactory)beanFactory, TransactionManager.class, (String)qualifier);
            this.transactionManagerCache.putIfAbsent(qualifier, txManager);
        }
        return txManager;
    }

    @Nullable
    private HussarPlatformTransactionManager asPlatformTransactionManager(@Nullable Object transactionManager) {
        if (transactionManager == null || transactionManager instanceof PlatformTransactionManager) {
            return (HussarPlatformTransactionManager)transactionManager;
        }
        throw new IllegalStateException("Specified transaction manager is not a HussarPlatformTransactionManager: " + transactionManager);
    }

    private String methodIdentification(Method method, @Nullable Class<?> targetClass, @Nullable TransactionAttribute txAttr) {
        String methodIdentification = this.methodIdentification(method, targetClass);
        if (methodIdentification == null) {
            if (txAttr instanceof DefaultTransactionAttribute) {
                methodIdentification = ((DefaultTransactionAttribute)txAttr).getDescriptor();
            }
            if (methodIdentification == null) {
                methodIdentification = ClassUtils.getQualifiedMethodName((Method)method, targetClass);
            }
        }
        return methodIdentification;
    }

    @Nullable
    protected String methodIdentification(Method method, @Nullable Class<?> targetClass) {
        return null;
    }

    protected TransactionInfo createTransactionIfNecessary(@Nullable HussarPlatformTransactionManager tm, @Nullable TransactionAttribute txAttr, final String joinpointIdentification) {
        if (txAttr != null && txAttr.getName() == null) {
            txAttr = new DelegatingTransactionAttribute((TransactionAttribute)txAttr){

                public String getName() {
                    return joinpointIdentification;
                }
            };
        }
        TransactionStatus status = null;
        if (txAttr != null) {
            if (tm != null) {
                status = tm.getTransaction((TransactionDefinition)txAttr);
            } else if (this.logger.isDebugEnabled()) {
                this.logger.debug((Object)("Skipping transactional joinpoint [" + joinpointIdentification + "] because no transaction manager has been configured"));
            }
        }
        return this.prepareTransactionInfo(tm, (TransactionAttribute)txAttr, joinpointIdentification, status);
    }

    protected TransactionInfo prepareTransactionInfo(@Nullable HussarPlatformTransactionManager tm, @Nullable TransactionAttribute txAttr, String joinpointIdentification, @Nullable TransactionStatus status) {
        TransactionInfo txInfo = new TransactionInfo(tm, txAttr, joinpointIdentification);
        if (txAttr != null) {
            if (this.logger.isTraceEnabled()) {
                this.logger.trace((Object)("Getting transaction for [" + txInfo.getJoinpointIdentification() + "]"));
            }
            txInfo.newTransactionStatus(status);
        } else if (this.logger.isTraceEnabled()) {
            this.logger.trace((Object)("No need to create transaction for [" + joinpointIdentification + "]: This method is not transactional."));
        }
        txInfo.bindToThread();
        return txInfo;
    }

    protected void commitTransactionAfterReturning(@Nullable TransactionInfo txInfo) {
        if (txInfo != null && txInfo.getTransactionStatus() != null) {
            if (this.logger.isTraceEnabled()) {
                this.logger.trace((Object)("Completing transaction for [" + txInfo.getJoinpointIdentification() + "]"));
            }
            txInfo.getTransactionManager().commit(txInfo);
        }
    }

    protected void completeTransactionAfterThrowing(@Nullable TransactionInfo txInfo, Throwable ex) {
        if (txInfo != null && txInfo.getTransactionStatus() != null) {
            if (this.logger.isTraceEnabled()) {
                this.logger.trace((Object)("Completing transaction for [" + txInfo.getJoinpointIdentification() + "] after exception: " + ex));
            }
            if (txInfo.transactionAttribute != null && txInfo.transactionAttribute.rollbackOn(ex)) {
                try {
                    txInfo.getTransactionManager().rollback(txInfo);
                }
                catch (TransactionSystemException ex2) {
                    this.logger.error((Object)"Application exception overridden by rollback exception", ex);
                    ex2.initApplicationException(ex);
                    throw ex2;
                }
                catch (Error | RuntimeException ex2) {
                    this.logger.error((Object)"Application exception overridden by rollback exception", ex);
                    throw ex2;
                }
            }
            try {
                txInfo.getTransactionManager().commit(txInfo.getTransactionStatus());
            }
            catch (TransactionSystemException ex2) {
                this.logger.error((Object)"Application exception overridden by commit exception", ex);
                ex2.initApplicationException(ex);
                throw ex2;
            }
            catch (Error | RuntimeException ex2) {
                this.logger.error((Object)"Application exception overridden by commit exception", ex);
                throw ex2;
            }
        }
    }

    protected void cleanupTransactionInfo(@Nullable TransactionInfo txInfo) {
        if (txInfo != null) {
            txInfo.restoreThreadLocalStatus();
        }
    }

    private static final class ReactiveTransactionInfo {
        @Nullable
        private final ReactiveTransactionManager transactionManager;
        @Nullable
        private final TransactionAttribute transactionAttribute;
        private final String joinpointIdentification;
        @Nullable
        private ReactiveTransaction reactiveTransaction;

        public ReactiveTransactionInfo(@Nullable ReactiveTransactionManager transactionManager, @Nullable TransactionAttribute transactionAttribute, String joinpointIdentification) {
            this.transactionManager = transactionManager;
            this.transactionAttribute = transactionAttribute;
            this.joinpointIdentification = joinpointIdentification;
        }

        public ReactiveTransactionManager getTransactionManager() {
            Assert.state((this.transactionManager != null ? 1 : 0) != 0, (String)"No ReactiveTransactionManager set");
            return this.transactionManager;
        }

        @Nullable
        public TransactionAttribute getTransactionAttribute() {
            return this.transactionAttribute;
        }

        public String getJoinpointIdentification() {
            return this.joinpointIdentification;
        }

        public void newReactiveTransaction(@Nullable ReactiveTransaction transaction) {
            this.reactiveTransaction = transaction;
        }

        @Nullable
        public ReactiveTransaction getReactiveTransaction() {
            return this.reactiveTransaction;
        }

        public String toString() {
            return this.transactionAttribute != null ? this.transactionAttribute.toString() : "No transaction";
        }
    }

    private static class ThrowableHolderException
    extends RuntimeException {
        public ThrowableHolderException(Throwable throwable) {
            super(throwable);
        }

        @Override
        public String toString() {
            return this.getCause().toString();
        }
    }

    private static class ThrowableHolder {
        @Nullable
        public Throwable throwable;

        private ThrowableHolder() {
        }
    }

    @FunctionalInterface
    protected static interface InvocationCallback {
        @Nullable
        public Object proceedWithInvocation() throws Throwable;
    }

    public static final class TransactionInfo {
        @Nullable
        private final HussarPlatformTransactionManager transactionManager;
        @Nullable
        private final TransactionAttribute transactionAttribute;
        private final String joinpointIdentification;
        @Nullable
        private TransactionStatus transactionStatus;
        @Nullable
        private TransactionInfo oldTransactionInfo;
        private List<TransactionInfo> newTransactionInfos;

        public TransactionInfo(@Nullable HussarPlatformTransactionManager transactionManager, @Nullable TransactionAttribute transactionAttribute, String joinpointIdentification) {
            this.transactionManager = transactionManager;
            this.transactionAttribute = transactionAttribute;
            this.joinpointIdentification = joinpointIdentification;
        }

        public HussarPlatformTransactionManager getTransactionManager() {
            Assert.state((this.transactionManager != null ? 1 : 0) != 0, (String)"No PlatformTransactionManager set");
            return this.transactionManager;
        }

        @Nullable
        public TransactionAttribute getTransactionAttribute() {
            return this.transactionAttribute;
        }

        public String getJoinpointIdentification() {
            return this.joinpointIdentification;
        }

        public void newTransactionStatus(@Nullable TransactionStatus status) {
            this.transactionStatus = status;
        }

        @Nullable
        public TransactionStatus getTransactionStatus() {
            return this.transactionStatus;
        }

        public boolean hasTransaction() {
            return this.transactionStatus != null;
        }

        private void bindToThread() {
            this.oldTransactionInfo = (TransactionInfo)transactionInfoHolder.get();
            transactionInfoHolder.set(this);
        }

        private void restoreThreadLocalStatus() {
            if (HussarUtils.isNotEmpty((Object)this.oldTransactionInfo)) {
                if (HussarUtils.isEmpty(this.oldTransactionInfo.getNewTransactionInfos())) {
                    this.oldTransactionInfo.setNewTransactionInfos(new ArrayList<TransactionInfo>());
                }
                this.oldTransactionInfo.getNewTransactionInfos().add(this);
            }
            transactionInfoHolder.set(this.oldTransactionInfo);
        }

        public List<TransactionInfo> getNewTransactionInfos() {
            return this.newTransactionInfos;
        }

        public void setNewTransactionInfos(List<TransactionInfo> newTransactionInfos) {
            this.newTransactionInfos = newTransactionInfos;
        }

        public String toString() {
            return this.transactionAttribute != null ? this.transactionAttribute.toString() : "No transaction";
        }
    }
}

