/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.hussar.support.sequence.config;

import com.jxdinfo.hussar.platform.core.sequence.builder.SeqBuilder;
import com.jxdinfo.hussar.platform.core.sequence.builder.impl.SnowflakeSeqBuilder;
import com.jxdinfo.hussar.support.sequence.plugin.snowflake.redis.generator.WorkIdGenerator;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.boot.autoconfigure.AutoConfigureAfter;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.data.redis.core.RedisTemplate;

@Configuration
@AutoConfigureAfter(name={"com.jxdinfo.hussar.support.cache.config.HussarCacheConfiguration"})
public class HussarSequenceConfiguration {
    @Value(value="${spring.application.name:}")
    private String applicationName;

    @Bean
    @ConditionalOnProperty(prefix="hussar.core.seq", name={"type"}, havingValue="snowflake-redis")
    public SeqBuilder snowflakeSeqBuilder(RedisTemplate<Object, Object> redisTemplate) {
        WorkIdGenerator workIdGenerator = new WorkIdGenerator(redisTemplate, this.applicationName);
        return SnowflakeSeqBuilder.create((Long)workIdGenerator.getDataCenterId(), (Long)workIdGenerator.getWorkerId());
    }
}

