-- Lua 脚本逻辑（保存为 worker_id.lua）
local key = KEYS[1]
-- 若 currentWorkerId 未传入，则默认为 0
local currentWorkerId = tonumber(ARGV[1]) or 0

-- 获取当前 key 的值
local storedValue = redis.call('GET', key)

-- 处理 key 不存在的情况
if not storedValue then
    redis.call('SET', key, currentWorkerId)
    return currentWorkerId
end

-- 转换存储值为数字
local storedWorkerId = tonumber(storedValue)
if not storedWorkerId then
    return redis.error_reply("存储的 Key 值必须为数字")
end

-- 比较并更新逻辑
if storedWorkerId < currentWorkerId then
    redis.call('SET', key, currentWorkerId)
    return currentWorkerId
else
    local newValue
    if currentWorkerId ~= 0 then
        -- 当 currentWorkerId 不等于 0 时，newValue 在 [currentWorkerId, currentWorkerId + 32) 范围内循环
        newValue = currentWorkerId + (storedWorkerId - currentWorkerId + 1) % 32
    else
        -- 当 currentWorkerId 等于 0 时，newValue 在 [0, 1024) 范围内循环
        newValue = (storedWorkerId + 1) % 1024
    end
    redis.call('SET', key, newValue)
    return newValue
end