/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.hussar.support.sequence.plugin.snowflake.redis.generator;

import com.jxdinfo.hussar.platform.core.utils.HussarUtils;
import java.util.Collections;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.core.io.ClassPathResource;
import org.springframework.core.io.Resource;
import org.springframework.data.redis.core.RedisTemplate;
import org.springframework.data.redis.core.script.DefaultRedisScript;

public class WorkIdGenerator {
    Logger logger = LoggerFactory.getLogger(WorkIdGenerator.class);
    private Long dataCenterInitId = 0L;
    private Long dataCenterId;
    private Long workerId;
    private RedisTemplate<String, String> redisTemplate;
    private DefaultRedisScript<Long> workerIdScript;
    private final String applicationName;
    private final String SEQ_WORKER_ID = "seq_worker_id";

    public WorkIdGenerator(RedisTemplate<String, String> redisTemplate, String applicationName) {
        this.redisTemplate = redisTemplate;
        this.workerIdScript = new DefaultRedisScript();
        this.workerIdScript.setLocation((Resource)new ClassPathResource("worker_id.lua"));
        this.workerIdScript.setResultType(Long.class);
        this.applicationName = applicationName;
        this.init();
    }

    public WorkIdGenerator(RedisTemplate<String, String> redisTemplate, String applicationName, Long dataCenterInitId) {
        this.redisTemplate = redisTemplate;
        this.workerIdScript = new DefaultRedisScript();
        this.workerIdScript.setLocation((Resource)new ClassPathResource("worker_id.lua"));
        this.workerIdScript.setResultType(Long.class);
        this.applicationName = applicationName;
        this.dataCenterInitId = dataCenterInitId;
        this.init();
    }

    public Long getDataCenterId() {
        return this.dataCenterId;
    }

    public Long getWorkerId() {
        return this.workerId;
    }

    private void init() {
        String key = HussarUtils.isNotEmpty((Object)this.applicationName) ? "{" + this.applicationName + "}" + "seq_worker_id" : "seq_worker_id";
        Long currentWorkerId = this.dataCenterInitId % 32L << 5;
        Long maxId = this.getMaxWorkId(key, currentWorkerId);
        String maxIdStr = Long.toBinaryString(maxId);
        maxIdStr = StringUtils.leftPad((String)maxIdStr, (int)10, (String)"0");
        String datacenterStr = maxIdStr.substring(0, 5);
        String workerStr = maxIdStr.substring(5, 10);
        this.dataCenterId = Long.parseLong(datacenterStr, 2);
        this.workerId = Long.parseLong(workerStr, 2);
        this.logger.info("\u83b7\u53d6\u6570\u636e\u4e2d\u5fc3ID\u548c\u5de5\u4f5c\u673a\u5668ID\u6210\u529f\uff0c\u5f53\u524d\u670d\u52a1\u6570\u636e\u4e2d\u5fc3ID\u4e3a{},\u5de5\u4f5c\u673a\u5668ID\u4e3a{}", (Object)this.dataCenterId, (Object)this.workerId);
    }

    private Long getMaxWorkId(String key, Long currentWorkerId) {
        if (key == null || key.isEmpty()) {
            throw new IllegalArgumentException("Key \u4e0d\u80fd\u4e3a\u7a7a");
        }
        if (currentWorkerId == null) {
            throw new IllegalArgumentException("currentWorkerId \u4e0d\u80fd\u4e3a\u7a7a");
        }
        if (currentWorkerId >= 1024L) {
            throw new IllegalArgumentException("currentWorkerId \u53d6\u503c\u8303\u56f4[0,31)");
        }
        return (Long)this.redisTemplate.execute(this.workerIdScript, Collections.singletonList(key), new Object[]{currentWorkerId.toString()});
    }
}

