/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.hussar.support.security.servlet.model;

import com.jxdinfo.hussar.platform.core.utils.HussarUtils;
import com.jxdinfo.hussar.support.security.core.SecurityManager;
import com.jxdinfo.hussar.support.security.core.context.model.SecurityRequest;
import com.jxdinfo.hussar.support.security.core.exception.SecurityTokenException;
import com.jxdinfo.hussar.support.security.core.util.SecurityFoxUtil;
import java.io.IOException;
import java.util.HashMap;
import java.util.Map;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.Cookie;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

public class SecurityRequestForServlet
implements SecurityRequest {
    private Map<String, String> headerMap = new HashMap<String, String>();
    protected HttpServletRequest request;

    public SecurityRequestForServlet(HttpServletRequest request) {
        this.request = request;
    }

    public Object getSource() {
        return this.request;
    }

    public String getParam(String name) {
        return this.request.getParameter(name);
    }

    public Map<String, String[]> getParamsMap() {
        return this.request.getParameterMap();
    }

    public String getHeader(String name) {
        if (HussarUtils.isEmpty(this.headerMap) || !this.headerMap.containsKey(name)) {
            return this.request.getHeader(name);
        }
        return this.headerMap.get(name);
    }

    public void setHeader(String name, String value) {
        if (HussarUtils.isEmpty((Object)name) || HussarUtils.isEmpty((Object)value)) {
            return;
        }
        if (HussarUtils.isEmpty((Object)this.getHeader(name))) {
            if (HussarUtils.isEmpty(this.headerMap)) {
                this.headerMap = new HashMap<String, String>();
            }
            this.headerMap.put(name, value);
        }
    }

    public void setHeaderForce(String name, String value) {
        if (HussarUtils.isEmpty((Object)name) || HussarUtils.isEmpty((Object)value)) {
            return;
        }
        if (HussarUtils.isEmpty(this.headerMap)) {
            this.headerMap = new HashMap<String, String>();
        }
        this.headerMap.put(name, value);
    }

    public String getCookieValue(String name) {
        Cookie[] cookies = this.request.getCookies();
        if (cookies != null) {
            for (Cookie cookie : cookies) {
                if (cookie == null || !name.equals(cookie.getName())) continue;
                return cookie.getValue();
            }
        }
        return null;
    }

    public String getRequestPath() {
        return this.request.getServletPath();
    }

    public String getUrl() {
        String currDomain = SecurityManager.getConfig().getCurrDomain();
        if (!SecurityFoxUtil.isEmpty((Object)currDomain)) {
            return currDomain + this.getRequestPath();
        }
        return this.request.getRequestURL().toString();
    }

    public String getMethod() {
        return this.request.getMethod();
    }

    public Object forward(String path) {
        try {
            HttpServletResponse response = (HttpServletResponse)SecurityManager.getSaTokenContext().getResponse().getSource();
            this.request.getRequestDispatcher(path).forward((ServletRequest)this.request, (ServletResponse)response);
            return null;
        }
        catch (IOException | ServletException e) {
            throw new SecurityTokenException(e);
        }
    }
}

