/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.hussar.support.security.plugin.quickLogin;

import com.jxdinfo.hussar.support.security.core.context.SecurityHolder;
import com.jxdinfo.hussar.support.security.core.router.SecurityRouter;
import com.jxdinfo.hussar.support.security.core.stp.SecurityUtil;
import com.jxdinfo.hussar.support.security.filter.SecurityServletFilter;
import com.jxdinfo.hussar.support.security.plugin.quickLogin.SecurityQuickManager;
import com.jxdinfo.hussar.support.security.plugin.quickLogin.config.SecurityQuickConfig;
import com.jxdinfo.hussar.support.security.plugin.quickLogin.web.SecurityQuickController;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.boot.context.properties.ConfigurationProperties;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.context.annotation.Import;
import org.springframework.core.annotation.Order;
import org.springframework.web.servlet.config.annotation.WebMvcConfigurer;

@Configuration
@Import(value={SecurityQuickController.class})
public class SecurityQuickBean
implements WebMvcConfigurer {
    @Bean
    @ConfigurationProperties(prefix="hussar.security")
    public SecurityQuickConfig getSaQuickConfig() {
        return new SecurityQuickConfig();
    }

    @Autowired
    public void setSaQuickConfig(SecurityQuickConfig securityQuickConfig) {
        SecurityQuickManager.setConfig(securityQuickConfig);
    }

    @Bean
    @Order(value=-101)
    public SecurityServletFilter getSaServletFilter() {
        return new SecurityServletFilter().addInclude(SecurityQuickManager.getConfig().getInclude().split(",")).addExclude(SecurityQuickManager.getConfig().getExclude().split(",")).addExclude(new String[]{"/favicon.ico", "/saLogin", "/doLogin", "/security-res/**"}).setAuth(r -> {
            if (SecurityQuickManager.getConfig().getAuth().booleanValue() && !SecurityUtil.isLogin()) {
                SecurityHolder.getRequest().forward("/saLogin");
                SecurityRouter.back();
            }
        }).setError(e -> e.getMessage());
    }
}

