/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.hussar.support.security.plugin.oauth2.customizers;

import com.jxdinfo.hussar.platform.core.base.apiresult.ApiResponse;
import com.jxdinfo.hussar.platform.core.base.apiresult.ResultCode;
import com.jxdinfo.hussar.platform.core.support.service.dto.LoginUser;
import com.jxdinfo.hussar.platform.core.support.service.dto.UserDetails;
import com.jxdinfo.hussar.platform.core.utils.HussarUtils;
import com.jxdinfo.hussar.support.security.core.context.SecurityHolder;
import com.jxdinfo.hussar.support.security.core.stp.SecurityUtil;
import com.jxdinfo.hussar.support.security.plugin.oauth2.SecurityOAuth2Manager;
import com.jxdinfo.hussar.support.security.plugin.oauth2.config.SecurityOAuth2Config;
import com.jxdinfo.hussar.support.security.plugin.oauth2.customizers.HussarSecurityAuthenticationService;
import com.jxdinfo.hussar.support.security.plugin.oauth2.customizers.dto.SecurityAuthenticationDto;
import com.jxdinfo.hussar.support.security.plugin.oauth2.exception.SecurityOAuth2Exception;
import com.jxdinfo.hussar.support.security.plugin.oauth2.listener.HussarSecurityOauthListener;
import com.jxdinfo.hussar.support.security.plugin.oauth2.logic.SecurityOAuth2Constants;
import com.jxdinfo.hussar.support.security.plugin.oauth2.logic.SecurityOAuth2Util;
import com.jxdinfo.hussar.support.security.plugin.oauth2.model.AccessTokenModel;
import com.jxdinfo.hussar.support.security.plugin.oauth2.model.RequestAuthModel;
import com.jxdinfo.hussar.support.security.plugin.oauth2.model.SecurityClientModel;
import java.util.Map;

public class DefaultSecurityAuthenticationService
implements HussarSecurityAuthenticationService {
    private final HussarSecurityOauthListener hussarSecurityOauthListener;

    public DefaultSecurityAuthenticationService(HussarSecurityOauthListener hussarSecurityOauthListener) {
        this.hussarSecurityOauthListener = hussarSecurityOauthListener;
    }

    @Override
    public ApiResponse<Map<String, Object>> securityPassword(SecurityAuthenticationDto securityAuthenticationDto) {
        if (HussarUtils.isEmpty((Object)securityAuthenticationDto) || HussarUtils.isEmpty((Object)securityAuthenticationDto.getUsername()) || HussarUtils.isEmpty((Object)securityAuthenticationDto.getClientId())) {
            SecurityOAuth2Exception.throwBy(true, "\u8ba4\u8bc1\u5931\u8d25\uff0c\u7528\u6237\u540d\u3001clientid\u4e0d\u80fd\u4e3a\u7a7a");
        }
        SecurityOAuth2Config cfg = SecurityOAuth2Manager.getConfig();
        String username = securityAuthenticationDto.getUsername();
        String password = securityAuthenticationDto.getPassword();
        String clientId = securityAuthenticationDto.getClientId();
        String tenantCode = securityAuthenticationDto.getTenantCode();
        Map<String, String> paramsMapExcludeParam = securityAuthenticationDto.getParamsMapExcludeParam();
        SecurityClientModel securityClientModel = SecurityOAuth2Util.checkClientModel(clientId);
        boolean isGrantype = SecurityOAuth2Util.checkClientGrantype(SecurityOAuth2Constants.GrantType.password, securityClientModel);
        SecurityOAuth2Exception.throwBy(!isGrantype, "\u8ba4\u8bc1\u5931\u8d25\uff0c\u6b64clientId=" + clientId + ",\u4e0d\u652f\u6301\u5bc6\u7801\u6a21\u5f0f\u767b\u9646");
        SecurityHolder.getStorage().set(SecurityUtil.securityLogic.splicingKeyJustCreatedSave(), (Object)"no-token");
        LoginUser loginUser = new LoginUser();
        loginUser.setPassword(password).setUserName(username).setTenantCode(tenantCode).setClientId(clientId);
        loginUser.setExtendMap(paramsMapExcludeParam);
        ApiResponse retObj = (ApiResponse)cfg.doLoginHandle.apply(loginUser);
        if (HussarUtils.isEmpty((Object)retObj) || retObj.getCode() != ResultCode.SUCCESS.getCode() && HussarUtils.isEmpty((Object)retObj.getData())) {
            SecurityOAuth2Exception.throwBy(true, "\u8ba4\u8bc1\u5931\u8d25,\u8ba4\u8bc1\u7528\u6237\u4fe1\u606f\u5931\u8d25");
        }
        UserDetails data = (UserDetails)retObj.getData();
        SecurityOAuth2Exception.throwBy(!SecurityUtil.isLogin(), "\u8ba4\u8bc1\u5931\u8d25\uff0c\u672a\u68c0\u6d4b\u7528\u6237\u5df2\u7ecf\u767b\u5f55");
        AccessTokenModel at = null;
        if (HussarUtils.isNotEmpty((Object)data.getAccessToken())) {
            at = SecurityOAuth2Util.updateAllAccessTokenTimeout(data.getAccessToken(), securityClientModel.getAccessTokenValidTime(), securityClientModel.getRefreshTokenValidTime());
        }
        if (HussarUtils.isEmpty(at)) {
            RequestAuthModel ra = new RequestAuthModel();
            ra.clientId = clientId;
            ra.loginId = data.getLoginId();
            ra.scope = securityAuthenticationDto.getScope();
            ra.expiresTime = securityClientModel.getAccessTokenValidTime();
            ra.refreshExpiresTime = securityClientModel.getRefreshTokenValidTime();
            ra.specifyAccessToken = HussarUtils.isEmpty(paramsMapExcludeParam) ? null : paramsMapExcludeParam.get("specify-access-token");
            at = SecurityOAuth2Util.generateAccessToken(ra, true, data.getTokenValue(), data.getLoginType());
            data.setAccessToken(at.accessToken);
            SecurityUtil.getTokenSession((String)data.getTokenValue()).addUserDetailToTokenSession(data, data.getTokenValue());
        }
        this.hussarSecurityOauthListener.loginSuccess(data);
        return ApiResponse.success(at.toLineMap());
    }
}

