/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.hussar.support.security.plugin.oauth2.extend.otherauth.service.impl;

import com.jxdinfo.hussar.platform.core.base.apiresult.ApiResponse;
import com.jxdinfo.hussar.platform.core.support.service.dto.UserDetails;
import com.jxdinfo.hussar.platform.core.utils.HussarUtils;
import com.jxdinfo.hussar.platform.core.utils.SpringContextUtil;
import com.jxdinfo.hussar.support.security.core.context.SecurityHolder;
import com.jxdinfo.hussar.support.security.core.context.model.SecurityRequest;
import com.jxdinfo.hussar.support.security.core.stp.SecurityLoginModel;
import com.jxdinfo.hussar.support.security.core.stp.SecuritySpecialUtil;
import com.jxdinfo.hussar.support.security.core.stp.SecurityTokenInfo;
import com.jxdinfo.hussar.support.security.core.util.SecurityFoxUtil;
import com.jxdinfo.hussar.support.security.plugin.oauth2.exception.SecurityOAuth2Exception;
import com.jxdinfo.hussar.support.security.plugin.oauth2.extend.otherauth.dto.SpecialUser;
import com.jxdinfo.hussar.support.security.plugin.oauth2.extend.otherauth.service.AuthSecuritySpecialUserDetailService;
import com.jxdinfo.hussar.support.security.plugin.oauth2.extend.otherauth.service.SecurityOAuth2SpecialHandlerService;
import com.jxdinfo.hussar.support.security.plugin.oauth2.listener.HussarSecurityOauthListener;
import com.jxdinfo.hussar.support.security.plugin.oauth2.logic.SecurityOAuth2Constants;
import com.jxdinfo.hussar.support.security.plugin.oauth2.logic.SecurityOAuth2Util;
import com.jxdinfo.hussar.support.security.plugin.oauth2.model.SecurityClientModel;
import com.jxdinfo.hussar.support.security.plugin.oauth2.model.SpecialTokenModel;
import java.util.List;
import java.util.Map;
import org.springframework.beans.factory.annotation.Autowired;

public class DefaultSecurityOAuth2SpecialHandlerService
implements SecurityOAuth2SpecialHandlerService {
    @Autowired
    private HussarSecurityOauthListener hussarSecurityOauthListener;

    @Override
    public ApiResponse otherSpecialToken() {
        SecurityRequest req = SecurityHolder.getRequest();
        String username = req.getParamNotNull(SecurityOAuth2Constants.Param.username);
        String clientId = req.getParamNotNull(SecurityOAuth2Constants.Param.client_id);
        String tenantCode = req.getParam(SecurityOAuth2Constants.Param.tenant_code);
        SecurityClientModel securityClientModel = SecurityOAuth2Util.checkClientModel(clientId);
        boolean isGrantype = SecurityOAuth2Util.checkClientGrantype(SecurityOAuth2Constants.GrantType.other_special, securityClientModel);
        SecurityOAuth2Exception.throwBy(!isGrantype, "\u8ba4\u8bc1\u5931\u8d25\uff0c\u6b64clientId=" + clientId + ",\u4e0d\u652f\u6301\u7279\u6b8a\u6a21\u5f0f\u767b\u9646");
        SpecialUser specialUser = new SpecialUser();
        specialUser.setUserName(username).setTenantCode(tenantCode).setClientId(clientId);
        List excludeList = SecurityFoxUtil.toList((String[])new String[]{SecurityOAuth2Constants.Param.username, SecurityOAuth2Constants.Param.password, SecurityOAuth2Constants.Param.client_id, SecurityOAuth2Constants.Param.tenant_code});
        Map paramsMapExcludeParam = SecurityFoxUtil.getParamsMapExcludeParam((List)excludeList, (Map)req.getParamsMap());
        specialUser.setExtendMap(paramsMapExcludeParam);
        List authSecuritySpecialUserDetailServices = SpringContextUtil.getBeansByClass(AuthSecuritySpecialUserDetailService.class);
        SecurityOAuth2Exception.throwByNull((Object)authSecuritySpecialUserDetailServices, (String)"\u8ba4\u8bc1\u5931\u8d25\uff0c\u672a\u6ce8\u5165\u8ba4\u8bc1\u7684AuthSecuritySpecialUserDetailService");
        SecurityOAuth2Exception.throwBy(authSecuritySpecialUserDetailServices.size() > 1, "\u8ba4\u8bc1\u5931\u8d25\uff0c\u53ea\u9700\u6ce8\u5165\u4e00\u4e2a\u672a\u6ce8\u5165\u8ba4\u8bc1\u7684AuthSecuritySpecialUserDetailService");
        AuthSecuritySpecialUserDetailService securitySpecialUserDetailService = (AuthSecuritySpecialUserDetailService)authSecuritySpecialUserDetailServices.get(0);
        SecurityOAuth2Exception.throwBy(HussarUtils.isEmpty((Object)specialUser) || HussarUtils.isEmpty((Object)specialUser.getUserName()), "\u7528\u6237\u540d\u5bc6\u7801\u4e0d\u80fd\u4e3a\u7a7a");
        SecurityOAuth2Exception.throwBy(HussarUtils.isEmpty((Object)specialUser.getClientId()), "clientId\u4e3a\u7a7a\uff01");
        UserDetails userDetails = securitySpecialUserDetailService.loadUserByUserNameForSpecial(specialUser);
        SecurityOAuth2Exception.throwBy(HussarUtils.isEmpty((Object)userDetails) || HussarUtils.isEmpty((Object)userDetails.getUserId()), "\u8ba4\u8bc1\u5931\u8d25\uff0c\u67e5\u65e0\u6b64\u7528\u6237\uff01");
        SecurityLoginModel securityLoginModel = new SecurityLoginModel();
        securityLoginModel.setTimeout(securityClientModel.getRefreshTokenValidTime());
        if (HussarUtils.isNotEmpty((Object)userDetails.getMaxSameCount())) {
            securityLoginModel.setMaxSameCount(userDetails.getMaxSameCount());
        }
        SecuritySpecialUtil.login((Object)userDetails.getUserId(), (SecurityLoginModel)securityLoginModel);
        SecurityTokenInfo tokenInfo = SecuritySpecialUtil.getTokenInfo();
        userDetails.setLoginType(tokenInfo.getLoginType());
        userDetails.setLoginDevice(tokenInfo.getLoginDevice());
        userDetails.setTokenName(tokenInfo.getTokenName());
        userDetails.setTokenValue(tokenInfo.getTokenValue());
        userDetails.setLoginId(tokenInfo.loginId);
        SecuritySpecialUtil.getTokenSession().addUserDetailToTokenSession(userDetails, tokenInfo.getTokenValue());
        SpecialTokenModel sct = SecurityOAuth2Util.generateSpecialClientToken(securityClientModel, tokenInfo);
        userDetails.setAccessToken(sct.accessToken);
        SecuritySpecialUtil.getTokenSession().addUserDetailToTokenSession(userDetails, userDetails.getTokenValue());
        this.hussarSecurityOauthListener.loginSuccess(userDetails);
        return ApiResponse.success(sct.toLineMap());
    }
}

