/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.hussar.support.security.plugin.oauth2.model;

import com.jxdinfo.hussar.support.security.plugin.oauth2.logic.SecurityOAuth2Constants;
import com.jxdinfo.hussar.support.security.plugin.oauth2.model.support.TokenModel;
import java.util.LinkedHashMap;
import java.util.Map;

public class AccessTokenModel
implements TokenModel {
    private static final long serialVersionUID = -6541180061782004705L;
    public String accessToken;
    public String refreshToken;
    public long expiresTime;
    public long refreshExpiresTime;
    public String clientId;
    public Object loginId;
    public String openid;
    public String scope;
    public String loginTicket;
    public String loginType;
    public Boolean isShare = false;

    public AccessTokenModel() {
    }

    public AccessTokenModel(String accessToken, String clientId, Object loginId, String scope) {
        this.accessToken = accessToken;
        this.clientId = clientId;
        this.loginId = loginId;
        this.scope = scope;
    }

    public String toString() {
        return "AccessTokenModel [accessToken=" + this.accessToken + ", refreshToken=" + this.refreshToken + ", accessTokenTimeout=" + this.expiresTime + ", refreshTokenTimeout=" + this.refreshExpiresTime + ", clientId=" + this.clientId + ", scope=" + this.scope + ", openid=" + this.openid + ",loginTicket=" + this.loginTicket + "]";
    }

    public long getExpiresIn() {
        long s = (this.expiresTime - System.currentTimeMillis()) / 1000L;
        return s < 1L ? -2L : s;
    }

    public long getRefreshExpiresIn() {
        long s = (this.refreshExpiresTime - System.currentTimeMillis()) / 1000L;
        return s < 1L ? -2L : s;
    }

    public Map<String, Object> toLineMap() {
        LinkedHashMap<String, Object> map = new LinkedHashMap<String, Object>();
        map.put(SecurityOAuth2Constants.Param.access_token, this.accessToken);
        map.put(SecurityOAuth2Constants.Param.refresh_token, this.refreshToken);
        map.put(SecurityOAuth2Constants.Param.expires_in, this.getExpiresIn());
        map.put(SecurityOAuth2Constants.Param.refresh_expires_in, this.getRefreshExpiresIn());
        map.put(SecurityOAuth2Constants.Param.client_id, this.clientId);
        map.put(SecurityOAuth2Constants.Param.scope, this.scope);
        map.put(SecurityOAuth2Constants.Param.openid, this.openid);
        map.put(SecurityOAuth2Constants.Param.login_ticket, this.loginTicket);
        return map;
    }

    @Override
    public String getValidClientId() {
        return this.clientId;
    }
}

