/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.hussar.support.security.plugin.oauth2.logic;

import com.jxdinfo.hussar.support.security.core.context.model.SecurityRequest;
import com.jxdinfo.hussar.support.security.core.context.model.SecurityResponse;
import com.jxdinfo.hussar.support.security.core.stp.SecurityTokenInfo;
import com.jxdinfo.hussar.support.security.plugin.oauth2.logic.SecurityOAuth2Template;
import com.jxdinfo.hussar.support.security.plugin.oauth2.model.AccessTokenModel;
import com.jxdinfo.hussar.support.security.plugin.oauth2.model.AccessTokenSign;
import com.jxdinfo.hussar.support.security.plugin.oauth2.model.ClientTokenModel;
import com.jxdinfo.hussar.support.security.plugin.oauth2.model.CodeModel;
import com.jxdinfo.hussar.support.security.plugin.oauth2.model.RefreshTokenModel;
import com.jxdinfo.hussar.support.security.plugin.oauth2.model.RequestAuthModel;
import com.jxdinfo.hussar.support.security.plugin.oauth2.model.SecurityClientModel;
import com.jxdinfo.hussar.support.security.plugin.oauth2.model.SpecialTokenModel;
import com.jxdinfo.hussar.support.security.plugin.oauth2.model.support.TokenModel;
import java.util.List;

public class SecurityOAuth2Util {
    public static SecurityOAuth2Template securityOAuth2Template = new SecurityOAuth2Template();

    public static SecurityClientModel checkClientModel(String clientId) {
        return securityOAuth2Template.checkClientModel(clientId);
    }

    public static boolean checkClientGrantype(String grantType, String clientId) {
        return securityOAuth2Template.checkClientGrantype(grantType, clientId);
    }

    public static boolean checkClientGrantype(String grantType, SecurityClientModel securityClientModel) {
        return securityOAuth2Template.checkClientGrantype(grantType, securityClientModel);
    }

    public static void checkClientScope(String scope, SecurityClientModel securityClientModel) {
        securityOAuth2Template.checkClientScope(scope, securityClientModel);
    }

    public static AccessTokenModel checkAccessToken(String accessToken) {
        return securityOAuth2Template.checkAccessToken(accessToken);
    }

    public static boolean checkOauthToken(TokenModel tokenModel, SecurityRequest securityRequest, SecurityResponse response, Object handler) {
        return securityOAuth2Template.checkOauthToken(tokenModel, securityRequest, response, handler);
    }

    public static ClientTokenModel checkClientToken(String clientToken, String tenantCode) {
        return securityOAuth2Template.checkClientToken(clientToken, tenantCode);
    }

    public static TokenModel getTokenModelByAcessToken(String accessToken, String tenantCode) {
        return securityOAuth2Template.getTokenModelByAcessToken(accessToken, tenantCode);
    }

    public static Object getLoginIdByAccessToken(String accessToken) {
        return securityOAuth2Template.getLoginIdByAccessToken(accessToken);
    }

    public static void checkScope(String accessToken, String ... scopes) {
        securityOAuth2Template.checkScope(accessToken, scopes);
    }

    public static RequestAuthModel generateRequestAuth(SecurityRequest req, Object loginId) {
        return securityOAuth2Template.generateRequestAuth(req, loginId);
    }

    public static CodeModel generateCode(RequestAuthModel ra) {
        return securityOAuth2Template.generateCode(ra);
    }

    public static AccessTokenModel generateAccessToken(String code) {
        return securityOAuth2Template.generateAccessToken(code);
    }

    public static AccessTokenModel refreshAccessToken(String refreshToken) {
        return SecurityOAuth2Util.refreshAccessToken(refreshToken, null);
    }

    public static AccessTokenModel refreshAccessToken(String refreshToken, String tenantCode) {
        return securityOAuth2Template.refreshAccessToken(refreshToken, tenantCode);
    }

    public static AccessTokenSign getRefreshAccessToken(String clientId, Object loginId, String refreshToken) {
        return SecurityOAuth2Util.getRefreshAccessToken(clientId, loginId, refreshToken, null);
    }

    public static AccessTokenSign getRefreshAccessToken(String clientId, Object loginId, String refreshToken, String tenantCode) {
        return securityOAuth2Template.getRefreshTokenValue(clientId, loginId, refreshToken, tenantCode);
    }

    public static AccessTokenSign getRefreshAccessTokenByAccessToken(String clientId, Object loginId, String accessToken) {
        return securityOAuth2Template.getRefreshTokenValueByAccessToken(clientId, loginId, accessToken);
    }

    public static AccessTokenModel generateAccessToken(RequestAuthModel ra, boolean isCreateRt, String loginToken, String loginType) {
        return SecurityOAuth2Util.generateAccessToken(ra, isCreateRt, loginToken, loginType, null);
    }

    public static AccessTokenModel generateAccessToken(RequestAuthModel ra, boolean isCreateRt, String loginToken, String loginType, String tenantCode) {
        return securityOAuth2Template.generateAccessToken(ra, isCreateRt, loginToken, loginType, tenantCode);
    }

    public static ClientTokenModel generateClientToken(SecurityClientModel securityClientModel, String scope, String tenantCode) {
        return securityOAuth2Template.generateClientToken(securityClientModel, scope, tenantCode);
    }

    public static ClientTokenModel generateClientTokenSavePast(SecurityClientModel securityClientModel, String scope, String tenantCode) {
        return securityOAuth2Template.generateClientTokenSavePast(securityClientModel, scope, tenantCode);
    }

    public static SpecialTokenModel generateSpecialClientToken(SecurityClientModel securityClientModel, SecurityTokenInfo tokenInfo) {
        return securityOAuth2Template.generateSpecialToken(securityClientModel, tokenInfo);
    }

    public static String buildRedirectUri(String redirectUri, String code, String state) {
        return securityOAuth2Template.buildRedirectUri(redirectUri, code, state);
    }

    public static String buildImplicitRedirectUri(String redirectUri, String token, String state) {
        return securityOAuth2Template.buildImplicitRedirectUri(redirectUri, token, state);
    }

    public static void revokeAccessToken(String accessToken) {
        SecurityOAuth2Util.revokeAccessToken(accessToken, null);
    }

    public static void revokeAccessToken(String accessToken, String tenantCode) {
        securityOAuth2Template.revokeAccessToken(accessToken, tenantCode);
    }

    public static void revokeAccessTokenNotLoginOutAndRefreshToken(String clientId, String loginId, String accessToken) {
        SecurityOAuth2Util.revokeAccessTokenNotLoginOutAndRefreshToken(clientId, loginId, accessToken, null);
    }

    public static void revokeAccessTokenNotLoginOutAndRefreshToken(String clientId, String loginId, String accessToken, String tenantCode) {
        securityOAuth2Template.revokeAccessTokenNotLoginOutAndRefreshToken(clientId, loginId, accessToken, tenantCode);
    }

    public static void revokeSpecialAccessTokenNotLoginOut(String clientId, String loginId, String accessToken) {
        SecurityOAuth2Util.revokeSpecialAccessTokenNotLoginOut(clientId, loginId, accessToken, null);
    }

    public static void revokeSpecialAccessTokenNotLoginOut(String clientId, String loginId, String accessToken, String tenantCode) {
        securityOAuth2Template.revokeSpecialAccessTokenNotLoginOut(clientId, loginId, accessToken, tenantCode);
    }

    public static void revokeClientToken(String clientId, String tenantCode) {
        securityOAuth2Template.revokeClientToken(clientId, tenantCode);
    }

    public static void updateClientPermissions(String clientId, String tenantCode, List<String> permissions) {
        securityOAuth2Template.updateClientPermissions(clientId, tenantCode, permissions);
    }

    public static void revokeSpecialClientToken(String specialClientToken) {
        securityOAuth2Template.revokeSpecialToken(specialClientToken);
    }

    public static boolean isGrant(Object loginId, String clientId, String scope) {
        return securityOAuth2Template.isGrant(loginId, clientId, scope);
    }

    public static void checkContract(String clientId, String scope) {
        securityOAuth2Template.checkContract(clientId, scope);
    }

    public static void checkRightUrl(String clientId, String url) {
        securityOAuth2Template.checkRightUrl(clientId, url);
    }

    public static SecurityClientModel checkClientSecret(String clientId, String clientSecret, String tenantCode) {
        return securityOAuth2Template.checkClientSecret(clientId, clientSecret, tenantCode);
    }

    public static CodeModel checkGainTokenParam(String code, String clientId, String clientSecret, String redirectUri) {
        return securityOAuth2Template.checkGainTokenParam(code, clientId, clientSecret, redirectUri);
    }

    public static RefreshTokenModel checkRefreshTokenParam(String clientId, String clientSecret, String refreshToken) {
        return SecurityOAuth2Util.checkRefreshTokenParam(clientId, clientSecret, refreshToken, null);
    }

    public static RefreshTokenModel checkRefreshTokenParam(String clientId, String clientSecret, String refreshToken, String tenantCode) {
        return securityOAuth2Template.checkRefreshTokenParam(clientId, clientSecret, refreshToken, tenantCode);
    }

    public static AccessTokenModel checkAccessTokenParam(String clientId, String clientSecret, String accessToken, String tenantCode) {
        return securityOAuth2Template.checkAccessTokenParam(clientId, clientSecret, accessToken, tenantCode);
    }

    public static void saveGrantScope(String clientId, Object loginId, String scope) {
        securityOAuth2Template.saveGrantScope(clientId, loginId, scope);
    }

    public static CodeModel getCode(String code) {
        return securityOAuth2Template.getCode(code);
    }

    public static AccessTokenModel getAccessToken(String accessToken) {
        return SecurityOAuth2Util.getAccessToken(accessToken, null);
    }

    public static AccessTokenModel getAccessToken(String accessToken, String tenantCode) {
        return securityOAuth2Template.getAccessToken(accessToken, tenantCode);
    }

    public static TokenModel getPastOrAccessToken(String accessToken) {
        return securityOAuth2Template.getPastOrAccessToken(accessToken);
    }

    public static RefreshTokenModel getRefreshToken(String refreshToken) {
        return securityOAuth2Template.getRefreshToken(refreshToken);
    }

    public static ClientTokenModel getClientToken(String clientToken, String tenantCode) {
        return securityOAuth2Template.getClientToken(clientToken, tenantCode);
    }

    public static TokenModel getPastOrClientToken(String clientToken, String tenantCode) {
        return securityOAuth2Template.getPastOrClientToken(clientToken, tenantCode);
    }

    public static TokenModel getPastOrClientTokenByClientId(String clientId, String tenantCode) {
        return securityOAuth2Template.getPastOrClientTokenByClientId(clientId, tenantCode);
    }

    public static String getGrantScope(String clientId, Object loginId) {
        return securityOAuth2Template.getGrantScope(clientId, loginId);
    }

    public static void updateAllAccessTokenTimeout(String accessToken, long accessTokenTimeout, long refreshTokenTimeout) {
        SecurityOAuth2Util.updateAllAccessTokenTimeout(accessToken, accessTokenTimeout, refreshTokenTimeout, null);
    }

    public static void updateAllAccessTokenTimeout(String accessToken, long accessTokenTimeout, long refreshTokenTimeout, String tenantCode) {
        securityOAuth2Template.updateAllAccessTokenTimeout(accessToken, accessTokenTimeout, refreshTokenTimeout, tenantCode);
    }

    public static SecurityClientModel getClientModelByClientId(String clientId) {
        return securityOAuth2Template.getClientModel(clientId);
    }

    public static ClientTokenModel getClientTokenModel(String clientId, String tenantCode) {
        return securityOAuth2Template.getClientTokenModel(clientId, tenantCode);
    }
}

