/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.hussar.support.security.plugin.oauth2.logic;

import com.jxdinfo.hussar.platform.core.support.service.dto.UserDetails;
import com.jxdinfo.hussar.platform.core.utils.HussarUtils;
import com.jxdinfo.hussar.support.security.core.SecurityManager;
import com.jxdinfo.hussar.support.security.core.context.model.SecurityRequest;
import com.jxdinfo.hussar.support.security.core.context.model.SecurityResponse;
import com.jxdinfo.hussar.support.security.core.session.TokenSession;
import com.jxdinfo.hussar.support.security.core.stp.SecuritySpecialUtil;
import com.jxdinfo.hussar.support.security.core.stp.SecurityTokenInfo;
import com.jxdinfo.hussar.support.security.core.stp.SecurityUtil;
import com.jxdinfo.hussar.support.security.core.strategy.SecurityStrategy;
import com.jxdinfo.hussar.support.security.core.util.SecurityFoxUtil;
import com.jxdinfo.hussar.support.security.plugin.oauth2.SecurityOAuth2Manager;
import com.jxdinfo.hussar.support.security.plugin.oauth2.exception.SecurityOAuth2Exception;
import com.jxdinfo.hussar.support.security.plugin.oauth2.listener.HussarSecurityOauthListener;
import com.jxdinfo.hussar.support.security.plugin.oauth2.logic.SecurityOAuth2Constants;
import com.jxdinfo.hussar.support.security.plugin.oauth2.logic.SecurityOAuth2Util;
import com.jxdinfo.hussar.support.security.plugin.oauth2.model.AccessTokenModel;
import com.jxdinfo.hussar.support.security.plugin.oauth2.model.AccessTokenSign;
import com.jxdinfo.hussar.support.security.plugin.oauth2.model.ClientTokenModel;
import com.jxdinfo.hussar.support.security.plugin.oauth2.model.CodeModel;
import com.jxdinfo.hussar.support.security.plugin.oauth2.model.PastAccessTokenModel;
import com.jxdinfo.hussar.support.security.plugin.oauth2.model.PastAccessTokenSign;
import com.jxdinfo.hussar.support.security.plugin.oauth2.model.PastClientTokenModel;
import com.jxdinfo.hussar.support.security.plugin.oauth2.model.RefreshTokenModel;
import com.jxdinfo.hussar.support.security.plugin.oauth2.model.RequestAuthModel;
import com.jxdinfo.hussar.support.security.plugin.oauth2.model.SecurityClientModel;
import com.jxdinfo.hussar.support.security.plugin.oauth2.model.SpecialTokenModel;
import com.jxdinfo.hussar.support.security.plugin.oauth2.model.SpecialTokenSign;
import com.jxdinfo.hussar.support.security.plugin.oauth2.model.support.TokenModel;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Optional;
import java.util.Vector;
import java.util.concurrent.ConcurrentHashMap;
import org.springframework.beans.factory.annotation.Autowired;

public class SecurityOAuth2Template {
    @Autowired
    private HussarSecurityOauthListener hussarSecurityOauthListener;

    public SecurityClientModel getClientModel(String clientId) {
        return this.getClientModel(clientId, null);
    }

    public SecurityClientModel getClientModel(String clientId, String tenantCode) {
        return null;
    }

    public String getOpenid(String clientId, Object loginId) {
        return null;
    }

    public SecurityClientModel checkClientModel(String clientId) {
        return this.checkClientModel(clientId, null);
    }

    public SecurityClientModel checkClientModel(String clientId, String tenantCode) {
        SecurityClientModel clientModel = this.getClientModel(clientId, tenantCode);
        if (clientModel == null) {
            throw new SecurityOAuth2Exception("\u65e0\u6548client_id: " + clientId);
        }
        return clientModel;
    }

    public boolean checkOauthToken(TokenModel tokenModel, SecurityRequest securityRequest, SecurityResponse response, Object handler) {
        return true;
    }

    public boolean checkClientGrantype(String grantType, String clientId) {
        SecurityClientModel clientModel = this.getClientModel(clientId);
        SecurityOAuth2Exception.throwBy(HussarUtils.isEmpty((Object)clientModel) || HussarUtils.isEmpty((Object)grantType), "\u8ba4\u8bc1\u5931\u8d25\uff0c\u672a\u67e5\u5230\u6b64client\uff0c\u83b7\u53d6granttype\u4e3a\u7a7a");
        Object[] grantTypes = clientModel.getGrantTypes();
        SecurityOAuth2Exception.throwBy(HussarUtils.isEmpty((Object[])grantTypes), "\u8ba4\u8bc1\u5931\u8d25\uff0cclientId=[" + clientId + "]\uff0c\u672a\u8bbe\u7f6e\u8ba4\u8bc1\u7c7b\u578bgrantType");
        boolean isGrantType = Arrays.stream(grantTypes).anyMatch(str -> str.equalsIgnoreCase(grantType));
        return isGrantType;
    }

    public boolean checkClientGrantype(String grantType, SecurityClientModel securityClientModel) {
        SecurityOAuth2Exception.throwBy(HussarUtils.isEmpty((Object)securityClientModel) || HussarUtils.isEmpty((Object)grantType), "\u8ba4\u8bc1\u5931\u8d25\uff0c\u672a\u67e5\u5230\u6b64client\uff0c\u83b7\u53d6granttype\u4e3a\u7a7a");
        Object[] grantTypes = securityClientModel.getGrantTypes();
        SecurityOAuth2Exception.throwBy(HussarUtils.isEmpty((Object[])grantTypes), "\u8ba4\u8bc1\u5931\u8d25\uff0cclientId=[" + securityClientModel.getClientId() + "]\uff0c\u672a\u8bbe\u7f6e\u8ba4\u8bc1\u7c7b\u578bgrantType");
        boolean isGrantType = Arrays.stream(grantTypes).anyMatch(str -> str.equalsIgnoreCase(grantType));
        return isGrantType;
    }

    public void checkClientScope(String scope, SecurityClientModel securityClientModel) {
        SecurityOAuth2Exception.throwBy(HussarUtils.isEmpty((Object)securityClientModel) || HussarUtils.isEmpty((Object)scope), "\u8ba4\u8bc1\u5931\u8d25\uff0c\u672a\u67e5\u5230\u6b64client\uff0c\u83b7\u53d6scope\u4e3a\u7a7a");
    }

    public AccessTokenModel checkAccessToken(String accessToken) {
        AccessTokenModel at = this.getAccessToken(accessToken);
        SecurityOAuth2Exception.throwBy(at == null, "\u65e0\u6548access_token\uff1a" + accessToken);
        return at;
    }

    public ClientTokenModel checkClientToken(String clientToken, String tenantCode) {
        ClientTokenModel ct = this.getClientToken(clientToken, tenantCode);
        SecurityOAuth2Exception.throwBy(ct == null, "\u65e0\u6548\uff1aclient_token" + ct);
        return ct;
    }

    public Object getLoginIdByAccessToken(String accessToken) {
        return this.checkAccessToken((String)accessToken).loginId;
    }

    public void checkScope(String accessToken, String ... scopes) {
        if (scopes == null || scopes.length == 0) {
            return;
        }
        AccessTokenModel at = this.checkAccessToken(accessToken);
        List scopeList = SecurityFoxUtil.convertStringToList((String)at.scope);
        for (String scope : scopes) {
            SecurityOAuth2Exception.throwBy(!scopeList.contains(scope), "\u8be5 Access-Token \u4e0d\u5177\u5907 Scope\uff1a" + scope);
        }
    }

    public RequestAuthModel generateRequestAuth(SecurityRequest req, Object loginId) {
        RequestAuthModel ra = new RequestAuthModel();
        ra.clientId = req.getHeaderNotNull(SecurityOAuth2Constants.Param.client_id);
        ra.responseType = req.getParamNotNull(SecurityOAuth2Constants.Param.response_type);
        ra.redirectUri = req.getParamNotNull(SecurityOAuth2Constants.Param.redirect_uri);
        ra.state = req.getParam(SecurityOAuth2Constants.Param.state);
        ra.scope = req.getParam(SecurityOAuth2Constants.Param.scope, "");
        ra.loginId = loginId;
        return ra;
    }

    public CodeModel generateCode(RequestAuthModel ra) {
        this.deleteCode(this.getCodeValue(ra.clientId, ra.loginId));
        String code = this.randomCode(ra.clientId, ra.loginId, ra.scope);
        CodeModel cm = new CodeModel(code, ra.clientId, ra.scope, ra.loginId, ra.redirectUri);
        this.saveCode(cm);
        this.saveCodeIndex(cm);
        return cm;
    }

    public AccessTokenModel generateAccessToken(String code) {
        CodeModel cm = this.getCode(code);
        SecurityOAuth2Exception.throwBy(cm == null, "\u65e0\u6548code");
        AccessTokenModel at = this.converCodeToAccessToken(cm);
        RefreshTokenModel rt = this.converAccessTokenToRefreshToken(at);
        at.refreshToken = rt.refreshToken;
        at.refreshExpiresTime = rt.expiresTime;
        this.saveAccessToken(at);
        this.saveAccessTokenIndex(at);
        this.saveRefreshToken(rt);
        this.saveRefreshTokenIndex(rt, at.accessToken);
        this.deleteCode(code);
        this.deleteCodeIndex(cm.clientId, cm.loginId);
        return at;
    }

    public AccessTokenModel refreshAccessToken(String refreshToken) {
        return this.refreshAccessToken(refreshToken, null);
    }

    public AccessTokenModel refreshAccessToken(String refreshToken, String tenantCode) {
        String oldAccessToken;
        AccessTokenModel oldAccessTokenModel;
        RefreshTokenModel rt = this.getRefreshToken(refreshToken, tenantCode);
        SecurityOAuth2Exception.throwBy(rt == null, "\u65e0\u6548refresh_token: " + refreshToken);
        AccessTokenSign refreshTokenSign = this.getRefreshTokenValue(rt.clientId, rt.loginId, refreshToken, tenantCode);
        SecurityOAuth2Exception.throwByNull((Object)refreshTokenSign, (String)"\u5237\u65b0token\u5931\u8d25\uff0c\u672a\u627e\u5230\u6b64refreshtoken");
        SecurityClientModel clientModel = this.getClientModel(rt.clientId);
        if (HussarUtils.isEmpty((Object)clientModel)) {
            SecurityOAuth2Exception.throwBy(true, "\u5237\u65b0token\u5931\u8d25,\u672a\u627e\u5230\u6b64client_id=[" + rt.clientId + "]");
        }
        AccessTokenSign refreshAccessToken = SecurityOAuth2Util.getRefreshAccessToken(rt.clientId, rt.loginId, rt.refreshToken, tenantCode);
        if (SecurityOAuth2Manager.getConfig().getIsNewRefresh().booleanValue()) {
            this.deleteRefreshToken(rt.refreshToken, tenantCode);
            rt = this.converRefreshTokenToRefreshToken(rt, clientModel);
        }
        if (HussarUtils.isNotEmpty((Object)(oldAccessTokenModel = this.getAccessToken(oldAccessToken = refreshTokenSign.getAccessToken(), tenantCode)))) {
            this.deleteAccessToken(oldAccessTokenModel.accessToken, tenantCode);
            this.deleteAccessTokenIndex(rt.clientId, rt.loginId, oldAccessTokenModel.accessToken, tenantCode);
        }
        this.deleteRefreshTokenIndex(rt.clientId, rt.loginId, refreshTokenSign.getRefreshToken(), tenantCode);
        AccessTokenModel newAccesstionTokenModel = this.converRefreshTokenToAccessToken(rt, clientModel);
        this.saveRefreshToken(rt, tenantCode);
        this.saveRefreshTokenIndex(rt, newAccesstionTokenModel.accessToken, tenantCode);
        this.saveAccessToken(newAccesstionTokenModel, tenantCode);
        this.saveAccessTokenIndex(newAccesstionTokenModel, tenantCode);
        if (SecurityOAuth2Manager.getConfig().getRefreshTokenThreshold() > 0L && SecurityOAuth2Manager.getConfig().isEnableSavePastAccessToken()) {
            PastAccessTokenModel pastAccessTokenModel = new PastAccessTokenModel();
            pastAccessTokenModel.setAccessToken(oldAccessTokenModel.accessToken);
            pastAccessTokenModel.setClientId(oldAccessTokenModel.clientId);
            pastAccessTokenModel.setExpiresTime(System.currentTimeMillis() + SecurityOAuth2Manager.getConfig().getRefreshTokenThreshold() * 1000L);
            pastAccessTokenModel.setLoginId(oldAccessTokenModel.loginId);
            pastAccessTokenModel.setOpenid(oldAccessTokenModel.openid);
            pastAccessTokenModel.setLoginTicket(newAccesstionTokenModel.loginTicket);
            pastAccessTokenModel.setScope(oldAccessTokenModel.scope);
            pastAccessTokenModel.setLoginType(oldAccessTokenModel.loginType);
            pastAccessTokenModel.tenantCode = oldAccessTokenModel.tenantCode;
            this.savePastAccessTokenIndex(pastAccessTokenModel, newAccesstionTokenModel, tenantCode);
            this.savePastAccessToken(pastAccessTokenModel, tenantCode);
        }
        this.generateOrRefreshTokenUpdateLoginToken(newAccesstionTokenModel, tenantCode);
        TokenSession tokenSession = SecurityUtil.getTokenSession((String)newAccesstionTokenModel.loginTicket, (String)tenantCode);
        UserDetails userDetails = tokenSession.getUserDetails();
        userDetails.setAccessToken(newAccesstionTokenModel.accessToken);
        tokenSession.addUserDetailToTokenSession(userDetails, newAccesstionTokenModel.loginTicket, tenantCode);
        this.hussarSecurityOauthListener.refreshTokenSuccess(oldAccessToken, userDetails);
        return newAccesstionTokenModel;
    }

    private void generateOrRefreshTokenUpdateLoginToken(AccessTokenModel at) {
        this.generateOrRefreshTokenUpdateLoginToken(at, null);
    }

    private void generateOrRefreshTokenUpdateLoginToken(AccessTokenModel at, String tenantCode) {
        ConcurrentHashMap<String, Object> extandsMap = new ConcurrentHashMap<String, Object>();
        extandsMap.put("access_token", at.accessToken);
        extandsMap.put("client_id", at.clientId);
        extandsMap.put("login_id", at.loginId);
        SecurityManager.getStpLogic((String)at.loginType).updateExtendsMapToTokenSign(at.loginTicket, extandsMap, tenantCode);
        SecurityManager.getStpLogic((String)at.loginType).updateAllLoginTokenTimeout(at.loginTicket, at.getRefreshExpiresIn(), tenantCode);
    }

    public AccessTokenModel generateAccessToken(RequestAuthModel ra, boolean isCreateRt, String loginToken, String loginType) {
        return this.generateAccessToken(ra, isCreateRt, loginToken, loginType, null);
    }

    public AccessTokenModel generateAccessToken(RequestAuthModel ra, boolean isCreateRt, String loginToken, String loginType, String tenantCode) {
        String newAtValue = HussarUtils.isNotEmpty((Object)ra.specifyAccessToken) ? ra.specifyAccessToken : this.randomAccessToken(ra.clientId, ra.loginId, ra.scope);
        AccessTokenModel at = new AccessTokenModel(newAtValue, ra.clientId, ra.loginId, ra.scope);
        at.tenantCode = tenantCode;
        at.openid = this.getOpenid(ra.clientId, ra.loginId);
        at.loginTicket = loginToken;
        at.loginType = loginType;
        SecurityClientModel clientModel = this.getClientModel(ra.clientId);
        if (HussarUtils.isEmpty((Object)clientModel)) {
            SecurityOAuth2Exception.throwBy(true, "\u8ba4\u8bc1\u5931\u8d25\uff0cclientid \u4e0d\u5b58\u5728");
        }
        at.expiresTime = System.currentTimeMillis() + ra.getExpiresTime() * 1000L;
        at.refreshExpiresTime = System.currentTimeMillis() + ra.refreshExpiresTime * 1000L;
        if (isCreateRt) {
            RefreshTokenModel rt = this.converAccessTokenToRefreshToken(at);
            rt.tenantCode = tenantCode;
            this.saveRefreshToken(rt, tenantCode);
            this.saveRefreshTokenIndex(rt, newAtValue, tenantCode);
        }
        this.saveAccessToken(at, tenantCode);
        this.saveAccessTokenIndex(at, tenantCode);
        this.generateOrRefreshTokenUpdateLoginToken(at, tenantCode);
        return at;
    }

    public ClientTokenModel generateClientToken(SecurityClientModel securityClientModel, String scope, String tenantCode) {
        String clientTokenValue = this.getClientTokenValue(securityClientModel.getClientId(), tenantCode);
        if (HussarUtils.isNotEmpty((Object)clientTokenValue)) {
            this.deleteClientToken(clientTokenValue, tenantCode);
        }
        this.deleteClientTokenIndex(securityClientModel.getClientId(), tenantCode);
        ClientTokenModel ct = new ClientTokenModel(this.randomClientToken(securityClientModel.getClientId(), scope), securityClientModel.getClientId(), scope);
        ct.expiresTime = System.currentTimeMillis() + securityClientModel.getAccessTokenValidTime() * 1000L;
        this.saveClientToken(ct);
        this.saveClientTokenIndex(ct);
        return ct;
    }

    public ClientTokenModel generateClientTokenSavePast(SecurityClientModel securityClientModel, String scope, String tenantCode) {
        ClientTokenModel ct = new ClientTokenModel(this.randomClientToken(securityClientModel.getClientId(), scope), securityClientModel.getClientId(), scope);
        ct.expiresTime = System.currentTimeMillis() + securityClientModel.getAccessTokenValidTime() * 1000L;
        String pastClientTokenValue = this.getPastClientTokenValue(securityClientModel.clientId, tenantCode);
        if (HussarUtils.isNotEmpty((Object)pastClientTokenValue)) {
            this.deletePastClientToken(pastClientTokenValue, tenantCode);
            this.deletePastClientTokenIndex(securityClientModel.getClientId(), tenantCode);
        }
        ClientTokenModel oldClientTokenModel = this.getClientTokenModel(securityClientModel.getClientId(), tenantCode);
        PastClientTokenModel pastClientTokenModel = null;
        if (HussarUtils.isNotEmpty((Object)oldClientTokenModel)) {
            pastClientTokenModel = new PastClientTokenModel();
            pastClientTokenModel.setClientToken(oldClientTokenModel.clientToken);
            pastClientTokenModel.setExpiresTime(oldClientTokenModel.expiresTime);
            pastClientTokenModel.setPermissions(oldClientTokenModel.permissions);
            pastClientTokenModel.setScope(oldClientTokenModel.scope);
            pastClientTokenModel.setClientId(oldClientTokenModel.clientId);
            pastClientTokenModel.setTenantCode(oldClientTokenModel.tenantCode);
            pastClientTokenModel.setNewClientToken(ct.clientToken);
        }
        this.deleteClientToken(oldClientTokenModel.clientToken, tenantCode);
        this.deleteClientTokenIndex(securityClientModel.getClientId(), tenantCode);
        this.saveClientToken(ct);
        this.saveClientTokenIndex(ct);
        this.savePastClientToken(pastClientTokenModel);
        this.savePastClientTokenIndex(pastClientTokenModel);
        return ct;
    }

    public SpecialTokenModel generateSpecialToken(SecurityClientModel securityClientModel, SecurityTokenInfo tokenInfo) {
        SpecialTokenModel sct = new SpecialTokenModel(this.randomSpecialToken(securityClientModel.getClientId(), tokenInfo.getLoginId()), securityClientModel.getClientId());
        sct.setLoginTicket(tokenInfo.getTokenValue());
        sct.setLoginType(tokenInfo.getLoginType());
        sct.expiresTime = System.currentTimeMillis() + securityClientModel.getAccessTokenValidTime() * 1000L;
        sct.setLoginId(tokenInfo.getLoginId());
        this.saveSpecialToken(sct);
        this.saveSpecialTokenIndex(sct);
        ConcurrentHashMap<String, Object> extandsMap = new ConcurrentHashMap<String, Object>();
        extandsMap.put("access_token", sct.accessToken);
        extandsMap.put("client_id", sct.clientId);
        extandsMap.put("login_id", tokenInfo.loginId);
        SecurityManager.getStpLogic((String)sct.loginType).updateExtendsMapToTokenSign(sct.loginTicket, extandsMap);
        SecurityManager.getStpLogic((String)sct.loginType).updateAllLoginTokenTimeout(sct.loginTicket, sct.getExpiresIn());
        return sct;
    }

    public String buildRedirectUri(String redirectUri, String code, String state) {
        String url = SecurityFoxUtil.joinParam((String)redirectUri, (String)SecurityOAuth2Constants.Param.code, (Object)code);
        if (!SecurityFoxUtil.isEmpty((Object)state)) {
            url = SecurityFoxUtil.joinParam((String)url, (String)SecurityOAuth2Constants.Param.state, (Object)state);
        }
        return url;
    }

    public String buildImplicitRedirectUri(String redirectUri, String token, String state) {
        String url = SecurityFoxUtil.joinSharpParam((String)redirectUri, (String)SecurityOAuth2Constants.Param.token, (Object)token);
        if (!SecurityFoxUtil.isEmpty((Object)state)) {
            url = SecurityFoxUtil.joinSharpParam((String)url, (String)SecurityOAuth2Constants.Param.state, (Object)state);
        }
        return url;
    }

    public void revokeAccessToken(String accessToken) {
        this.revokeAccessToken(accessToken, null);
    }

    public void revokeAccessToken(String accessToken, String tenantCode) {
        AccessTokenModel at = this.getAccessToken(accessToken, tenantCode);
        if (at == null) {
            return;
        }
        TokenSession tokenSession = SecurityUtil.getTokenSession((String)at.loginTicket, (String)tenantCode);
        UserDetails userDetails = tokenSession.getUserDetails();
        this.deleteAccessToken(accessToken, tenantCode);
        this.deleteAccessTokenIndex(at.clientId, at.loginId, accessToken, tenantCode);
        PastAccessTokenSign pastAccessTokenValue = this.getPastAccessTokenValue(at.clientId, at.loginId, accessToken, tenantCode);
        if (HussarUtils.isNotEmpty((Object)pastAccessTokenValue)) {
            String oldAccessToken = pastAccessTokenValue.getOldAccessToken();
            this.deletePastAccessToken(oldAccessToken, tenantCode);
        }
        this.deletePastAccessTokenIndex(at.clientId, at.loginId, accessToken, tenantCode);
        this.deleteRefreshToken(at.refreshToken, tenantCode);
        this.deleteRefreshTokenIndex(at.clientId, at.loginId, at.refreshToken, tenantCode);
        SecurityUtil.logoutByTokenValue((String)at.loginTicket, (String)at.loginId.toString(), (String)tenantCode);
        this.hussarSecurityOauthListener.logoutSuccess(userDetails);
    }

    public void revokeAccessTokenNotLoginOutAndRefreshToken(String clientId, String loginId, String accessToken) {
        this.revokeAccessTokenNotLoginOutAndRefreshToken(clientId, loginId, accessToken, null);
    }

    public void revokeAccessTokenNotLoginOutAndRefreshToken(String clientId, String loginId, String accessToken, String tenantCode) {
        this.hussarSecurityOauthListener.displacementSuccess(clientId, loginId, accessToken);
        AccessTokenSign refreshTokenValueByAccessToken = this.getRefreshTokenValueByAccessToken(clientId, loginId, accessToken, tenantCode);
        if (HussarUtils.isEmpty((Object)refreshTokenValueByAccessToken)) {
            this.deleteAccessTokenIndex(clientId, loginId, accessToken, tenantCode);
            this.deleteRefreshTokenIndexByAccessToken(clientId, loginId, accessToken, tenantCode);
            return;
        }
        this.deleteAccessToken(accessToken, tenantCode);
        this.deleteAccessTokenIndex(clientId, loginId, accessToken, tenantCode);
        this.deleteRefreshToken(refreshTokenValueByAccessToken.getRefreshToken(), tenantCode);
        this.deleteRefreshTokenIndex(clientId, loginId, refreshTokenValueByAccessToken.getRefreshToken(), tenantCode);
    }

    public void revokeSpecialAccessTokenNotLoginOut(String clientId, String loginId, String accessToken) {
        this.revokeSpecialAccessTokenNotLoginOut(clientId, loginId, accessToken, null);
    }

    public void revokeSpecialAccessTokenNotLoginOut(String clientId, String loginId, String accessToken, String tenantCode) {
        this.hussarSecurityOauthListener.displacementSuccess(clientId, loginId, accessToken);
        this.deleteSpecialToken(accessToken, tenantCode);
        this.deleteSpecialTokenIndex(clientId, loginId, accessToken, tenantCode);
    }

    public void revokeClientToken(String clientId, String tenantCode) {
        ClientTokenModel clientTokenModel = this.getClientTokenModel(clientId, tenantCode);
        if (HussarUtils.isEmpty((Object)clientTokenModel) || HussarUtils.isEmpty((Object)clientTokenModel.clientToken)) {
            return;
        }
        String pastTokenValue = this.getPastClientTokenValue(clientId, tenantCode);
        if (HussarUtils.isNotEmpty((Object)pastTokenValue)) {
            this.deletePastClientTokenIndex(clientId, tenantCode);
            this.deletePastClientToken(pastTokenValue, tenantCode);
        }
        this.deleteClientToken(clientTokenModel.clientToken, tenantCode);
        this.deleteClientTokenIndex(clientId, tenantCode);
    }

    public void updateClientPermissions(String clientId, String tenantCode, List<String> permissions) {
        PastClientTokenModel pastClientTokenModel;
        ClientTokenModel clientTokenModel = this.getClientTokenModel(clientId, tenantCode);
        if (HussarUtils.isEmpty((Object)clientTokenModel) || HussarUtils.isEmpty((Object)clientTokenModel.clientToken)) {
            return;
        }
        String pastTokenValue = this.getPastClientTokenValue(clientId, tenantCode);
        if (HussarUtils.isNotEmpty((Object)pastTokenValue) && HussarUtils.isNotEmpty((Object)(pastClientTokenModel = this.getPastClientToken(pastTokenValue, tenantCode)))) {
            pastClientTokenModel.setPermissions(permissions);
            this.savePastClientToken(pastClientTokenModel);
        }
        clientTokenModel.permissions = permissions;
        this.saveClientToken(clientTokenModel);
    }

    public void revokeSpecialToken(String specialToken) {
        SpecialTokenModel st = this.getSpecialToken(specialToken);
        if (st == null) {
            return;
        }
        TokenSession tokenSession = SecuritySpecialUtil.getTokenSession((String)st.loginTicket);
        UserDetails userDetails = tokenSession.getUserDetails();
        this.deleteSpecialToken(specialToken);
        this.deleteSpecialTokenIndex(st.clientId, st.loginId, specialToken);
        SecurityManager.getStpLogic((String)st.loginType).logoutByTokenValue(st.loginTicket, st.loginId.toString());
        this.hussarSecurityOauthListener.logoutSuccess(userDetails);
    }

    public boolean isGrant(Object loginId, String clientId, String scope) {
        List grantScopeList = SecurityFoxUtil.convertStringToList((String)this.getGrantScope(clientId, loginId));
        List scopeList = SecurityFoxUtil.convertStringToList((String)scope);
        return scopeList.size() == 0 || grantScopeList.containsAll(scopeList);
    }

    public void checkContract(String clientId, String scope) {
        List scopelist;
        List<String> clientScopeList = Arrays.asList(this.checkClientModel((String)clientId).contractScope);
        if (!clientScopeList.containsAll(scopelist = SecurityFoxUtil.convertStringToList((String)scope))) {
            throw new SecurityOAuth2Exception("\u8bf7\u6c42\u7684Scope\u6682\u672a\u7b7e\u7ea6");
        }
    }

    public void checkRightUrl(String clientId, String url) {
        List allowList;
        if (!SecurityFoxUtil.isUrl((String)url)) {
            throw new SecurityOAuth2Exception("\u65e0\u6548redirect_url\uff1a" + url);
        }
        int qIndex = url.indexOf("?");
        if (qIndex != -1) {
            url = url.substring(0, qIndex);
        }
        if (!((Boolean)SecurityStrategy.me.hasElement.apply(allowList = SecurityFoxUtil.convertStringToList((String)this.checkClientModel((String)clientId).allowUrl), url)).booleanValue()) {
            throw new SecurityOAuth2Exception("\u975e\u6cd5redirect_url\uff1a" + url);
        }
    }

    public SecurityClientModel checkClientSecret(String clientId, String clientSecret, String tenantCode) {
        SecurityClientModel cm = this.checkClientModel(clientId, tenantCode);
        SecurityOAuth2Exception.throwBy(cm.clientSecret == null || !cm.clientSecret.equals(clientSecret), "\u65e0\u6548client_secret: " + clientSecret);
        return cm;
    }

    public CodeModel checkGainTokenParam(String code, String clientId, String clientSecret, String redirectUri) {
        CodeModel cm = this.getCode(code);
        SecurityOAuth2Exception.throwBy(cm == null, "\u65e0\u6548code: " + code);
        SecurityOAuth2Exception.throwBy(!cm.clientId.equals(clientId), "\u65e0\u6548client_id: " + clientId);
        String dbSecret = this.checkClientModel((String)clientId).clientSecret;
        SecurityOAuth2Exception.throwBy(dbSecret == null || !dbSecret.equals(clientSecret), "\u65e0\u6548client_secret: " + clientSecret);
        if (!SecurityFoxUtil.isEmpty((Object)redirectUri)) {
            SecurityOAuth2Exception.throwBy(!redirectUri.equals(cm.redirectUri), "\u65e0\u6548redirect_uri: " + redirectUri);
        }
        return cm;
    }

    public RefreshTokenModel checkRefreshTokenParam(String clientId, String clientSecret, String refreshToken) {
        return this.checkRefreshTokenParam(clientId, clientSecret, refreshToken, null);
    }

    public RefreshTokenModel checkRefreshTokenParam(String clientId, String clientSecret, String refreshToken, String tenantCode) {
        RefreshTokenModel rt = this.getRefreshToken(refreshToken, tenantCode);
        SecurityOAuth2Exception.throwBy(rt == null, "\u65e0\u6548refresh_token: " + refreshToken);
        SecurityOAuth2Exception.throwBy(!rt.clientId.equals(clientId), "\u65e0\u6548client_id: " + clientId);
        String dbSecret = this.checkClientModel((String)clientId).clientSecret;
        return rt;
    }

    public AccessTokenModel checkAccessTokenParam(String clientId, String clientSecret, String accessToken, String tenantCode) {
        AccessTokenModel at = this.checkAccessToken(accessToken);
        SecurityOAuth2Exception.throwBy(!at.clientId.equals(clientId), "\u65e0\u6548client_id\uff1a" + clientId);
        this.checkClientSecret(clientId, clientSecret, tenantCode);
        return at;
    }

    public AccessTokenModel converCodeToAccessToken(CodeModel cm) {
        AccessTokenModel at = new AccessTokenModel();
        at.accessToken = this.randomAccessToken(cm.clientId, cm.loginId, cm.scope);
        at.clientId = cm.clientId;
        at.loginId = cm.loginId;
        at.scope = cm.scope;
        at.openid = this.getOpenid(cm.clientId, cm.loginId);
        at.expiresTime = System.currentTimeMillis() + SecurityOAuth2Manager.getConfig().getAccessTokenTimeout() * 1000L;
        return at;
    }

    public RefreshTokenModel converAccessTokenToRefreshToken(AccessTokenModel at) {
        SecurityClientModel clientModel = this.getClientModel(at.clientId);
        if (HussarUtils.isEmpty((Object)clientModel)) {
            SecurityOAuth2Exception.throwBy(true, "\u8ba4\u8bc1\u5931\u8d25\uff0cclientid \u4e0d\u5b58\u5728");
        }
        RefreshTokenModel rt = new RefreshTokenModel();
        rt.refreshToken = this.randomRefreshToken(at.clientId, at.loginId, at.scope);
        rt.clientId = at.clientId;
        rt.loginId = at.loginId;
        rt.scope = at.scope;
        rt.openid = at.openid;
        rt.expiresTime = System.currentTimeMillis() + clientModel.getRefreshTokenValidTime() * 1000L;
        rt.loginTicket = at.loginTicket;
        at.refreshToken = rt.refreshToken;
        at.refreshExpiresTime = rt.expiresTime;
        return rt;
    }

    public AccessTokenModel converRefreshTokenToAccessToken(RefreshTokenModel rt, SecurityClientModel clientModel) {
        AccessTokenModel at = new AccessTokenModel();
        at.accessToken = this.randomAccessToken(rt.clientId, rt.loginId, rt.scope);
        at.refreshToken = rt.refreshToken;
        at.clientId = rt.clientId;
        at.loginId = rt.loginId;
        at.scope = rt.scope;
        at.openid = rt.openid;
        at.expiresTime = System.currentTimeMillis() + clientModel.getAccessTokenValidTime() * 1000L;
        at.refreshExpiresTime = rt.expiresTime;
        at.loginTicket = rt.loginTicket;
        at.tenantCode = rt.tenantCode;
        return at;
    }

    public RefreshTokenModel converRefreshTokenToRefreshToken(RefreshTokenModel rt, SecurityClientModel clientModel) {
        RefreshTokenModel newRt = new RefreshTokenModel();
        newRt.refreshToken = this.randomRefreshToken(rt.clientId, rt.loginId, rt.scope);
        newRt.expiresTime = System.currentTimeMillis() + clientModel.getRefreshTokenValidTime() * 1000L;
        newRt.clientId = rt.clientId;
        newRt.scope = rt.scope;
        newRt.loginId = rt.loginId;
        newRt.openid = rt.openid;
        newRt.loginTicket = rt.loginTicket;
        newRt.tenantCode = rt.tenantCode;
        return newRt;
    }

    public void saveCode(CodeModel c) {
        if (c == null) {
            return;
        }
        SecurityManager.getSaTokenDao().setObject(this.splicingCodeSaveKey(c.code), (Object)c, SecurityOAuth2Manager.getConfig().getCodeTimeout());
    }

    public void saveCodeIndex(CodeModel c) {
        if (c == null) {
            return;
        }
        SecurityManager.getSaTokenDao().set(this.splicingCodeIndexKey(c.clientId, c.loginId), c.code, SecurityOAuth2Manager.getConfig().getCodeTimeout());
    }

    public void saveAccessToken(AccessTokenModel at) {
        this.saveAccessToken(at, null);
    }

    public void saveAccessToken(AccessTokenModel at, String tenantCode) {
        if (at == null) {
            return;
        }
        SecurityManager.getSaTokenDao().setObject(this.splicingAccessTokenSaveKey(at.accessToken, tenantCode), (Object)at, at.getExpiresIn());
    }

    public void saveSpecialToken(SpecialTokenModel st) {
        if (st == null) {
            return;
        }
        SecurityManager.getSaTokenDao().setObject(this.splicingSpecialTokenSaveKey(st.accessToken), (Object)st, st.getExpiresIn());
    }

    public void savePastAccessToken(PastAccessTokenModel pat) {
        this.savePastAccessToken(pat, null);
    }

    public void savePastAccessToken(PastAccessTokenModel pat, String tenantCode) {
        if (pat == null) {
            return;
        }
        SecurityManager.getSaTokenDao().setObject(this.splicingPastAccessTokenSaveKey(pat.accessToken, tenantCode), (Object)pat, pat.getExpiresIn());
    }

    public void saveAccessTokenIndex(AccessTokenModel at) {
        this.saveAccessTokenIndex(at, null);
    }

    public void saveAccessTokenIndex(AccessTokenModel at, String tenantCode) {
        if (at == null) {
            return;
        }
        Vector<AccessTokenSign> accessTokenSignList = (Vector<AccessTokenSign>)SecurityManager.getSaTokenDao().getObject(this.splicingAccessTokenIndexKey(at.clientId, at.loginId, tenantCode));
        if (HussarUtils.isEmpty((Object)accessTokenSignList)) {
            accessTokenSignList = new Vector<AccessTokenSign>();
            AccessTokenSign accessTokenSign = new AccessTokenSign(at.accessToken, at.refreshToken, 1);
            accessTokenSignList.add(accessTokenSign);
        } else {
            AccessTokenSign accessTokenSign = new AccessTokenSign(at.accessToken, at.refreshToken, accessTokenSignList.size() + 1);
            accessTokenSignList.add(accessTokenSign);
        }
        SecurityManager.getSaTokenDao().setObject(this.splicingAccessTokenIndexKey(at.clientId, at.loginId, tenantCode), accessTokenSignList, at.getExpiresIn());
    }

    public void saveSpecialTokenIndex(SpecialTokenModel sct) {
        if (sct == null) {
            return;
        }
        Vector<SpecialTokenSign> specialTokenSignList = (Vector<SpecialTokenSign>)SecurityManager.getSaTokenDao().getObject(this.splicingSpecialTokenIndexKey(sct.clientId, sct.loginId));
        if (HussarUtils.isEmpty((Object)specialTokenSignList)) {
            specialTokenSignList = new Vector<SpecialTokenSign>();
            SpecialTokenSign specialTokenSign = new SpecialTokenSign(sct.accessToken, 1);
            specialTokenSignList.add(specialTokenSign);
        } else {
            SpecialTokenSign specialTokenSign = new SpecialTokenSign(sct.accessToken, specialTokenSignList.size() + 1);
            specialTokenSignList.add(specialTokenSign);
        }
        SecurityManager.getSaTokenDao().setObject(this.splicingSpecialTokenIndexKey(sct.clientId, sct.loginId), specialTokenSignList, sct.getExpiresIn());
    }

    public void savePastAccessTokenIndex(PastAccessTokenModel pat, AccessTokenModel accessTokenModel) {
        this.savePastAccessTokenIndex(pat, accessTokenModel, null);
    }

    public void savePastAccessTokenIndex(PastAccessTokenModel pat, AccessTokenModel accessTokenModel, String tenantCode) {
        if (pat == null) {
            return;
        }
        Vector<PastAccessTokenSign> pastAccessTokenSignList = (Vector<PastAccessTokenSign>)SecurityManager.getSaTokenDao().getObject(this.splicingPastAccessTokenIndexKey(pat.clientId, pat.loginId, tenantCode));
        if (HussarUtils.isEmpty((Object)pastAccessTokenSignList)) {
            pastAccessTokenSignList = new Vector<PastAccessTokenSign>();
            PastAccessTokenSign pastAccessTokenSign = new PastAccessTokenSign(pat.accessToken, accessTokenModel.accessToken);
            pastAccessTokenSignList.add(pastAccessTokenSign);
        } else {
            PastAccessTokenSign pastAccessTokenSign = new PastAccessTokenSign(pat.accessToken, accessTokenModel.accessToken);
            pastAccessTokenSignList.add(pastAccessTokenSign);
        }
        SecurityManager.getSaTokenDao().setObject(this.splicingPastAccessTokenIndexKey(pat.clientId, pat.loginId, tenantCode), pastAccessTokenSignList, pat.getExpiresIn());
    }

    public void saveRefreshToken(RefreshTokenModel rt) {
        this.saveRefreshToken(rt, null);
    }

    public void saveRefreshToken(RefreshTokenModel rt, String tenantCode) {
        if (rt == null) {
            return;
        }
        SecurityManager.getSaTokenDao().setObject(this.splicingRefreshTokenSaveKey(rt.refreshToken, tenantCode), (Object)rt, rt.getExpiresIn());
    }

    public void saveRefreshTokenIndex(RefreshTokenModel rt, String accessToken) {
        this.saveRefreshTokenIndex(rt, accessToken, null);
    }

    public void saveRefreshTokenIndex(RefreshTokenModel rt, String accessToken, String tenantCode) {
        if (rt == null) {
            return;
        }
        Vector<AccessTokenSign> refreshTokenSignList = (Vector<AccessTokenSign>)SecurityManager.getSaTokenDao().getObject(this.splicingRefreshTokenIndexKey(rt.clientId, rt.loginId, tenantCode));
        if (HussarUtils.isEmpty((Object)refreshTokenSignList)) {
            refreshTokenSignList = new Vector<AccessTokenSign>();
            AccessTokenSign accessTokenSign = new AccessTokenSign(accessToken, rt.refreshToken, 1);
            refreshTokenSignList.add(accessTokenSign);
        } else {
            AccessTokenSign accessTokenSign = new AccessTokenSign(accessToken, rt.refreshToken, refreshTokenSignList.size() + 1);
            refreshTokenSignList.add(accessTokenSign);
        }
        SecurityManager.getSaTokenDao().setObject(this.splicingRefreshTokenIndexKey(rt.clientId, rt.loginId, tenantCode), refreshTokenSignList, rt.getExpiresIn());
    }

    public void updateAllAccessTokenTimeout(String accessToken, long accessTokenTimeout, long refreshTokenTimeout) {
        this.updateAllAccessTokenTimeout(accessToken, accessTokenTimeout, refreshTokenTimeout, null);
    }

    public void updateAllAccessTokenTimeout(String accessToken, long accessTokenTimeout, long refreshTokenTimeout, String tenantCode) {
        AccessTokenModel accessTokenModel = this.getAccessToken(accessToken, tenantCode);
        if (HussarUtils.isEmpty((Object)accessTokenModel)) {
            return;
        }
        accessTokenModel.expiresTime = System.currentTimeMillis() + accessTokenTimeout * 1000L;
        accessTokenModel.refreshExpiresTime = System.currentTimeMillis() + refreshTokenTimeout * 1000L;
        SecurityManager.getSaTokenDao().updateObjectTimeout(this.splicingAccessTokenIndexKey(accessTokenModel.clientId, accessTokenModel.loginId, tenantCode), accessTokenTimeout);
        SecurityManager.getSaTokenDao().setObject(this.splicingAccessTokenSaveKey(accessToken, tenantCode), (Object)accessTokenModel, accessTokenTimeout);
        RefreshTokenModel refreshTokenModel = this.getRefreshToken(accessTokenModel.refreshToken, tenantCode);
        refreshTokenModel.expiresTime = System.currentTimeMillis() + refreshTokenTimeout * 1000L;
        SecurityManager.getSaTokenDao().updateObjectTimeout(this.splicingRefreshTokenIndexKey(accessTokenModel.clientId, accessTokenModel.loginId, tenantCode), refreshTokenTimeout);
        SecurityManager.getSaTokenDao().setObject(this.splicingRefreshTokenSaveKey(accessTokenModel.refreshToken, tenantCode), (Object)refreshTokenModel, refreshTokenTimeout);
    }

    public void saveClientToken(ClientTokenModel ct) {
        if (ct == null) {
            return;
        }
        SecurityManager.getSaTokenDao().setObject(this.splicingClientTokenSaveKey(ct.clientToken, ct.tenantCode), (Object)ct, ct.getExpiresIn());
    }

    public void saveClientTokenIndex(ClientTokenModel ct) {
        if (ct == null) {
            return;
        }
        SecurityManager.getSaTokenDao().set(this.splicingClientTokenIndexKey(ct.clientId, ct.tenantCode), ct.clientToken, ct.getExpiresIn());
    }

    public void savePastClientToken(PastClientTokenModel ct) {
        if (ct == null) {
            return;
        }
        SecurityManager.getSaTokenDao().setObject(this.splicingPastClientTokenSaveKey(ct.clientToken, ct.tenantCode), (Object)ct, ct.getExpiresIn());
    }

    public void savePastClientTokenIndex(PastClientTokenModel ct) {
        if (ct == null) {
            return;
        }
        SecurityManager.getSaTokenDao().set(this.splicingPastClientTokenIndexKey(ct.clientId, ct.tenantCode), ct.clientToken, ct.getExpiresIn());
    }

    public void savePastTokenIndex(ClientTokenModel ct) {
        if (ct == null) {
            return;
        }
        SecurityManager.getSaTokenDao().set(this.splicingPastTokenIndexKey(ct.clientId), ct.clientToken, ct.getExpiresIn());
    }

    public void saveGrantScope(String clientId, Object loginId, String scope) {
        if (!SecurityFoxUtil.isEmpty((Object)scope)) {
            long ttl = SecurityOAuth2Manager.getConfig().getAccessTokenTimeout();
            SecurityManager.getSaTokenDao().set(this.splicingGrantScopeKey(clientId, loginId), scope, ttl);
        }
    }

    public CodeModel getCode(String code) {
        if (code == null) {
            return null;
        }
        return (CodeModel)SecurityManager.getSaTokenDao().getObject(this.splicingCodeSaveKey(code));
    }

    public String getCodeValue(String clientId, Object loginId) {
        return SecurityManager.getSaTokenDao().get(this.splicingCodeIndexKey(clientId, loginId));
    }

    public AccessTokenModel getAccessToken(String accessToken) {
        return this.getAccessToken(accessToken, null);
    }

    public AccessTokenModel getAccessToken(String accessToken, String tenantCode) {
        if (accessToken == null) {
            return null;
        }
        return (AccessTokenModel)SecurityManager.getSaTokenDao().getObject(this.splicingAccessTokenSaveKey(accessToken, tenantCode));
    }

    public SpecialTokenModel getSpecialToken(String specialToken) {
        if (specialToken == null) {
            return null;
        }
        return (SpecialTokenModel)SecurityManager.getSaTokenDao().getObject(this.splicingSpecialTokenSaveKey(specialToken));
    }

    public PastAccessTokenModel getPastAccessToken(String accessToken) {
        return this.getPastAccessToken(accessToken, null);
    }

    public PastAccessTokenModel getPastAccessToken(String accessToken, String tenantCode) {
        if (accessToken == null) {
            return null;
        }
        return (PastAccessTokenModel)SecurityManager.getSaTokenDao().getObject(this.splicingPastAccessTokenSaveKey(accessToken, tenantCode));
    }

    public TokenModel getPastOrAccessToken(String accessToken) {
        return this.getPastOrAccessToken(accessToken, null);
    }

    public TokenModel getPastOrAccessToken(String accessToken, String tenantCode) {
        if (accessToken == null) {
            return null;
        }
        AccessTokenModel accessTokenModel = this.getAccessToken(accessToken, tenantCode);
        if (HussarUtils.isNotEmpty((Object)accessTokenModel)) {
            return accessTokenModel;
        }
        PastAccessTokenModel pastAccessToken = null;
        if (SecurityOAuth2Manager.getConfig().getRefreshTokenThreshold() > 0L && SecurityOAuth2Manager.getConfig().isEnableSavePastAccessToken()) {
            pastAccessToken = this.getPastAccessToken(accessToken, tenantCode);
        }
        return pastAccessToken;
    }

    public TokenModel getTokenModelByAcessToken(String accessToken, String tenantCode) {
        TokenModel returnTokenModel = null;
        returnTokenModel = this.getPastOrAccessToken(accessToken, tenantCode);
        if (HussarUtils.isNotEmpty((Object)returnTokenModel)) {
            return returnTokenModel;
        }
        returnTokenModel = this.getPastOrClientToken(accessToken, tenantCode);
        if (HussarUtils.isNotEmpty((Object)returnTokenModel)) {
            return returnTokenModel;
        }
        returnTokenModel = this.getSpecialToken(accessToken);
        if (HussarUtils.isNotEmpty((Object)returnTokenModel)) {
            return returnTokenModel;
        }
        return null;
    }

    public List<AccessTokenSign> getAccessTokenValue(String clientId, Object loginId) {
        return (List)SecurityManager.getSaTokenDao().getObject(this.splicingAccessTokenIndexKey(clientId, loginId));
    }

    public List<PastAccessTokenSign> getPastAccessTokenValue(String clientId, Object loginId) {
        return (List)SecurityManager.getSaTokenDao().getObject(this.splicingPastAccessTokenIndexKey(clientId, loginId));
    }

    public PastAccessTokenSign getPastAccessTokenValue(String clientId, Object loginId, String newAccessToken) {
        return this.getPastAccessTokenValue(clientId, loginId, newAccessToken, null);
    }

    public PastAccessTokenSign getPastAccessTokenValue(String clientId, Object loginId, String newAccessToken, String tenantCode) {
        List pastAccessTokenSignList = (List)SecurityManager.getSaTokenDao().getObject(this.splicingPastAccessTokenIndexKey(clientId, loginId, tenantCode));
        if (HussarUtils.isEmpty((Object)pastAccessTokenSignList)) {
            return null;
        }
        Optional<PastAccessTokenSign> first = pastAccessTokenSignList.stream().filter(pastAccessTokenSign -> pastAccessTokenSign.getNewAccessToken().equalsIgnoreCase(newAccessToken)).findFirst();
        return first.orElse(null);
    }

    public RefreshTokenModel getRefreshToken(String refreshToken) {
        return this.getRefreshToken(refreshToken, null);
    }

    public RefreshTokenModel getRefreshToken(String refreshToken, String tenantCode) {
        if (refreshToken == null) {
            return null;
        }
        return (RefreshTokenModel)SecurityManager.getSaTokenDao().getObject(this.splicingRefreshTokenSaveKey(refreshToken, tenantCode));
    }

    public List<AccessTokenSign> getRefreshTokenValue(String clientId, Object loginId) {
        return (List)SecurityManager.getSaTokenDao().getObject(this.splicingRefreshTokenIndexKey(clientId, loginId));
    }

    public AccessTokenSign getRefreshTokenValue(String clientId, Object loginId, String refreshToken) {
        return this.getRefreshTokenValue(clientId, loginId, refreshToken, null);
    }

    public AccessTokenSign getRefreshTokenValue(String clientId, Object loginId, String refreshToken, String tenantCode) {
        List accessTokenSignList = (List)SecurityManager.getSaTokenDao().getObject(this.splicingRefreshTokenIndexKey(clientId, loginId, tenantCode));
        if (HussarUtils.isEmpty((Object)accessTokenSignList)) {
            return null;
        }
        Optional<AccessTokenSign> first = accessTokenSignList.stream().filter(accessTokenSign -> accessTokenSign.getRefreshToken().equalsIgnoreCase(refreshToken)).findFirst();
        return first.orElse(null);
    }

    public AccessTokenSign getRefreshTokenValueByAccessToken(String clientId, Object loginId, String accessToken) {
        return this.getRefreshTokenValueByAccessToken(clientId, loginId, accessToken, null);
    }

    public AccessTokenSign getRefreshTokenValueByAccessToken(String clientId, Object loginId, String accessToken, String tenantCode) {
        List accessTokenSignList = (List)SecurityManager.getSaTokenDao().getObject(this.splicingRefreshTokenIndexKey(clientId, loginId, tenantCode));
        if (HussarUtils.isEmpty((Object)accessTokenSignList)) {
            return null;
        }
        Optional<AccessTokenSign> first = accessTokenSignList.stream().filter(accessTokenSign -> accessTokenSign.getAccessToken().equalsIgnoreCase(accessToken)).findFirst();
        return first.orElse(null);
    }

    public TokenModel getPastOrClientToken(String clientToken, String tenantCode) {
        if (HussarUtils.isEmpty((Object)clientToken)) {
            return null;
        }
        ClientTokenModel clientTokenModel = this.getClientToken(clientToken, tenantCode);
        if (HussarUtils.isNotEmpty((Object)clientTokenModel)) {
            return clientTokenModel;
        }
        PastClientTokenModel pastAccessToken = null;
        if (SecurityOAuth2Manager.getConfig().getClientCreateNewTokenThreshold() > 0L) {
            pastAccessToken = this.getPastClientToken(clientToken, tenantCode);
        }
        return pastAccessToken;
    }

    public TokenModel getPastOrClientTokenByClientId(String clientId, String tenantCode) {
        String clientTokenValue = this.getClientTokenValue(clientId, tenantCode);
        if (HussarUtils.isNotEmpty((Object)clientTokenValue)) {
            ClientTokenModel tokenModel = this.getClientToken(clientTokenValue, tenantCode);
            return tokenModel;
        }
        String pastClientTokenValue = this.getPastClientTokenValue(clientId, tenantCode);
        if (HussarUtils.isNotEmpty((Object)pastClientTokenValue)) {
            PastClientTokenModel tokenModel = this.getPastClientToken(pastClientTokenValue, tenantCode);
            return tokenModel;
        }
        return null;
    }

    public PastClientTokenModel getPastClientToken(String clientToken, String tenantCode) {
        if (clientToken == null) {
            return null;
        }
        return (PastClientTokenModel)SecurityManager.getSaTokenDao().getObject(this.splicingPastClientTokenSaveKey(clientToken, tenantCode));
    }

    public ClientTokenModel getClientToken(String clientToken, String tenantCode) {
        if (clientToken == null) {
            return null;
        }
        return (ClientTokenModel)SecurityManager.getSaTokenDao().getObject(this.splicingClientTokenSaveKey(clientToken, tenantCode));
    }

    public String getPastClientTokenValue(String clientId, String tenantCode) {
        return SecurityManager.getSaTokenDao().get(this.splicingPastClientTokenIndexKey(clientId, tenantCode));
    }

    public String getClientTokenValue(String clientId, String tenantCode) {
        return SecurityManager.getSaTokenDao().get(this.splicingClientTokenIndexKey(clientId, tenantCode));
    }

    public ClientTokenModel getClientTokenModel(String clientId, String tenantCode) {
        String clientTokenValue = this.getClientTokenValue(clientId, tenantCode);
        if (HussarUtils.isEmpty((Object)clientTokenValue)) {
            return null;
        }
        ClientTokenModel clientTokenModel = this.getClientToken(clientTokenValue, tenantCode);
        return clientTokenModel;
    }

    public String getPastTokenValue(String clientId) {
        return SecurityManager.getSaTokenDao().get(this.splicingPastTokenIndexKey(clientId));
    }

    public String getGrantScope(String clientId, Object loginId) {
        return SecurityManager.getSaTokenDao().get(this.splicingGrantScopeKey(clientId, loginId));
    }

    public void deleteCode(String code) {
        if (code != null) {
            SecurityManager.getSaTokenDao().deleteObject(this.splicingCodeSaveKey(code));
        }
    }

    public void deleteCodeIndex(String clientId, Object loginId) {
        SecurityManager.getSaTokenDao().delete(this.splicingCodeIndexKey(clientId, loginId));
    }

    public void deleteAccessToken(String accessToken) {
        this.deleteAccessToken(accessToken, null);
    }

    public void deleteAccessToken(String accessToken, String tenantCode) {
        if (accessToken != null) {
            SecurityManager.getSaTokenDao().deleteObject(this.splicingAccessTokenSaveKey(accessToken, tenantCode));
        }
    }

    public void deleteSpecialToken(String specialToken) {
        this.deleteSpecialToken(specialToken, null);
    }

    public void deleteSpecialToken(String specialToken, String tenantCode) {
        if (specialToken != null) {
            SecurityManager.getSaTokenDao().deleteObject(this.splicingSpecialTokenSaveKey(specialToken, tenantCode));
        }
    }

    public void deletePastAccessToken(String accessToken) {
        this.deletePastAccessToken(accessToken, null);
    }

    public void deletePastAccessToken(String accessToken, String tenantCode) {
        if (accessToken != null) {
            SecurityManager.getSaTokenDao().deleteObject(this.splicingPastAccessTokenSaveKey(accessToken, tenantCode));
        }
    }

    public void deleteSpecialTokenIndex(String clientId, Object loginId, String specialToken) {
        this.deleteSpecialTokenIndex(clientId, loginId, specialToken, null);
    }

    public void deleteSpecialTokenIndex(String clientId, Object loginId, String specialToken, String tenantCode) {
        List specialTokenSignList = (List)SecurityManager.getSaTokenDao().getObject(this.splicingSpecialTokenIndexKey(clientId, loginId, tenantCode));
        if (HussarUtils.isEmpty((Object)specialTokenSignList)) {
            return;
        }
        if (specialTokenSignList.size() == 1) {
            SecurityManager.getSaTokenDao().deleteObject(this.splicingSpecialTokenIndexKey(clientId, loginId, tenantCode));
            return;
        }
        int index = -1;
        SpecialTokenSign ats = null;
        ArrayList<SpecialTokenSign> specialTokenSigns = new ArrayList<SpecialTokenSign>();
        for (int i = 0; i < specialTokenSignList.size(); ++i) {
            ats = (SpecialTokenSign)specialTokenSignList.get(i);
            if (ats.getAccessToken().equalsIgnoreCase(specialToken)) {
                index = i;
                continue;
            }
            specialTokenSigns.add(ats);
        }
        int finalIndex = index;
        specialTokenSigns.forEach(accessTokenSign -> {
            if (accessTokenSign.getCurrentTokenCount() > finalIndex) {
                accessTokenSign.setCurrentTokenCount(accessTokenSign.getCurrentTokenCount() - 1);
            }
        });
        SecurityManager.getSaTokenDao().updateObject(this.splicingSpecialTokenIndexKey(clientId, loginId, tenantCode), specialTokenSigns);
    }

    public void deleteAccessTokenIndex(String clientId, Object loginId, String accessToken) {
        this.deleteAccessTokenIndex(clientId, loginId, accessToken, null);
    }

    public void deleteAccessTokenIndex(String clientId, Object loginId, String accessToken, String tenantCode) {
        List accessTokenSignList = (List)SecurityManager.getSaTokenDao().getObject(this.splicingAccessTokenIndexKey(clientId, loginId, tenantCode));
        if (HussarUtils.isEmpty((Object)accessTokenSignList)) {
            return;
        }
        if (accessTokenSignList.size() == 1) {
            SecurityManager.getSaTokenDao().deleteObject(this.splicingAccessTokenIndexKey(clientId, loginId, tenantCode));
            return;
        }
        int index = -1;
        AccessTokenSign ats = null;
        ArrayList<AccessTokenSign> accessTokenSigns = new ArrayList<AccessTokenSign>();
        for (int i = 0; i < accessTokenSignList.size(); ++i) {
            ats = (AccessTokenSign)accessTokenSignList.get(i);
            if (ats.getAccessToken().equalsIgnoreCase(accessToken)) {
                index = i;
                continue;
            }
            accessTokenSigns.add(ats);
        }
        int finalIndex = index;
        accessTokenSigns.forEach(accessTokenSign -> {
            if (accessTokenSign.getCurrentTokenCount() > finalIndex) {
                accessTokenSign.setCurrentTokenCount(accessTokenSign.getCurrentTokenCount() - 1);
            }
        });
        SecurityManager.getSaTokenDao().updateObject(this.splicingAccessTokenIndexKey(clientId, loginId, tenantCode), accessTokenSigns);
    }

    public void deletePastAccessTokenIndex(String clientId, Object loginId, String newAccessToken) {
        this.deletePastAccessTokenIndex(clientId, loginId, newAccessToken, null);
    }

    public void deletePastAccessTokenIndex(String clientId, Object loginId, String newAccessToken, String tenantCode) {
        List pastAccessTokenSignList = (List)SecurityManager.getSaTokenDao().getObject(this.splicingPastAccessTokenIndexKey(clientId, loginId, tenantCode));
        if (HussarUtils.isEmpty((Object)pastAccessTokenSignList)) {
            return;
        }
        if (pastAccessTokenSignList.size() == 1) {
            SecurityManager.getSaTokenDao().deleteObject(this.splicingPastAccessTokenIndexKey(clientId, loginId, tenantCode));
            return;
        }
        ArrayList<PastAccessTokenSign> pastAccessTokenSigns = new ArrayList<PastAccessTokenSign>();
        for (int i = 0; i < pastAccessTokenSignList.size(); ++i) {
            PastAccessTokenSign pats = (PastAccessTokenSign)pastAccessTokenSignList.get(i);
            if (pats.getNewAccessToken().equalsIgnoreCase(newAccessToken)) continue;
            pastAccessTokenSigns.add(pats);
        }
        SecurityManager.getSaTokenDao().updateObject(this.splicingPastAccessTokenIndexKey(clientId, loginId, tenantCode), pastAccessTokenSigns);
    }

    public void deleteRefreshToken(String refreshToken) {
        this.deleteRefreshToken(refreshToken, null);
    }

    public void deleteRefreshToken(String refreshToken, String tenantCode) {
        if (refreshToken != null) {
            SecurityManager.getSaTokenDao().deleteObject(this.splicingRefreshTokenSaveKey(refreshToken, tenantCode));
        }
    }

    public void deleteRefreshTokenIndex(String clientId, Object loginId, String refreshToken) {
        this.deleteRefreshTokenIndex(clientId, loginId, refreshToken, null);
    }

    public void deleteRefreshTokenIndex(String clientId, Object loginId, String refreshToken, String tenantCode) {
        List refreshTokenSignList = (List)SecurityManager.getSaTokenDao().getObject(this.splicingRefreshTokenIndexKey(clientId, loginId, tenantCode));
        if (HussarUtils.isEmpty((Object)refreshTokenSignList)) {
            return;
        }
        if (refreshTokenSignList.size() == 1) {
            SecurityManager.getSaTokenDao().deleteObject(this.splicingRefreshTokenIndexKey(clientId, loginId, tenantCode));
            return;
        }
        int index = -1;
        AccessTokenSign ats = null;
        ArrayList<AccessTokenSign> refreshTokenSigns = new ArrayList<AccessTokenSign>();
        for (int i = 0; i < refreshTokenSignList.size(); ++i) {
            ats = (AccessTokenSign)refreshTokenSignList.get(i);
            if (ats.getRefreshToken().equalsIgnoreCase(refreshToken)) {
                index = i;
                continue;
            }
            refreshTokenSigns.add(ats);
        }
        int finalIndex = index;
        refreshTokenSigns.forEach(accessTokenSign -> {
            if (accessTokenSign.getCurrentTokenCount() > finalIndex) {
                accessTokenSign.setCurrentTokenCount(accessTokenSign.getCurrentTokenCount() - 1);
            }
        });
        SecurityManager.getSaTokenDao().updateObject(this.splicingRefreshTokenIndexKey(clientId, loginId, tenantCode), refreshTokenSigns);
    }

    public void deleteRefreshTokenIndexByAccessToken(String clientId, Object loginId, String accessToken) {
        this.deleteRefreshTokenIndexByAccessToken(clientId, loginId, accessToken, null);
    }

    public void deleteRefreshTokenIndexByAccessToken(String clientId, Object loginId, String accessToken, String tenantCode) {
        List refreshTokenSignList = (List)SecurityManager.getSaTokenDao().getObject(this.splicingRefreshTokenIndexKey(clientId, loginId, tenantCode));
        if (HussarUtils.isEmpty((Object)refreshTokenSignList)) {
            return;
        }
        if (refreshTokenSignList.size() == 1) {
            SecurityManager.getSaTokenDao().deleteObject(this.splicingRefreshTokenIndexKey(clientId, loginId, tenantCode));
            return;
        }
        int index = -1;
        AccessTokenSign ats = null;
        ArrayList<AccessTokenSign> refreshTokenSigns = new ArrayList<AccessTokenSign>();
        for (int i = 0; i < refreshTokenSignList.size(); ++i) {
            ats = (AccessTokenSign)refreshTokenSignList.get(i);
            if (ats.getAccessToken().equalsIgnoreCase(accessToken)) {
                index = i;
                continue;
            }
            refreshTokenSigns.add(ats);
        }
        int finalIndex = index;
        refreshTokenSigns.forEach(accessTokenSign -> {
            if (accessTokenSign.getCurrentTokenCount() > finalIndex) {
                accessTokenSign.setCurrentTokenCount(accessTokenSign.getCurrentTokenCount() - 1);
            }
        });
        SecurityManager.getSaTokenDao().updateObject(this.splicingRefreshTokenIndexKey(clientId, loginId, tenantCode), refreshTokenSigns);
    }

    public void deleteTokenToIdMapping(String tokenValue, String loginType) {
        if (HussarUtils.isEmpty((Object)tokenValue)) {
            return;
        }
        SecurityManager.getStpLogic((String)loginType).deleteTokenToIdMapping(tokenValue);
    }

    public void deletePastClientToken(String clientToken, String tenantCode) {
        if (clientToken != null) {
            SecurityManager.getSaTokenDao().deleteObject(this.splicingPastClientTokenSaveKey(clientToken, tenantCode));
        }
    }

    public void deletePastClientTokenIndex(String clientId, String tenantCode) {
        SecurityManager.getSaTokenDao().delete(this.splicingPastClientTokenIndexKey(clientId, tenantCode));
    }

    public void deleteClientToken(String clientToken, String tenantCode) {
        if (clientToken != null) {
            SecurityManager.getSaTokenDao().deleteObject(this.splicingClientTokenSaveKey(clientToken, tenantCode));
        }
    }

    public void deleteClientTokenIndex(String clientId, String tenantCode) {
        SecurityManager.getSaTokenDao().delete(this.splicingClientTokenIndexKey(clientId, tenantCode));
    }

    public void deletePastTokenIndex(String clientId) {
        SecurityManager.getSaTokenDao().delete(this.splicingPastTokenIndexKey(clientId));
    }

    public void deleteGrantScope(String clientId, Object loginId) {
        SecurityManager.getSaTokenDao().delete(this.splicingGrantScopeKey(clientId, loginId));
    }

    public String randomCode(String clientId, Object loginId, String scope) {
        return SecurityFoxUtil.getRandomString((int)60);
    }

    public String randomAccessToken(String clientId, Object loginId, String scope) {
        return SecurityFoxUtil.getRandomString((int)60);
    }

    public String randomSpecialToken(String clientId, Object loginId) {
        return SecurityFoxUtil.getRandomString((int)60);
    }

    public String randomRefreshToken(String clientId, Object loginId, String scope) {
        return SecurityFoxUtil.getRandomString((int)60);
    }

    public String randomClientToken(String clientId, String scope) {
        return SecurityFoxUtil.getRandomString((int)60);
    }

    public String splicingCodeSaveKey(String code) {
        return SecurityManager.getConfig().getTokenName() + ":oauth2:code:" + code;
    }

    public String splicingCodeIndexKey(String clientId, Object loginId) {
        return SecurityManager.getConfig().getTokenName() + ":oauth2:code-index:" + clientId + ":" + loginId;
    }

    public String splicingAccessTokenSaveKey(String accessToken) {
        return this.splicingAccessTokenSaveKey(accessToken, null);
    }

    public String splicingAccessTokenSaveKey(String accessToken, String tenantCode) {
        if (HussarUtils.isNotEmpty((Object)tenantCode)) {
            return SecurityManager.getConfig().getTokenName() + ":oauth2:access-token:" + tenantCode + ":" + accessToken;
        }
        return SecurityManager.getConfig().getTokenName() + ":oauth2:access-token:" + accessToken;
    }

    public String splicingSpecialTokenSaveKey(String accessToken) {
        return this.splicingSpecialTokenSaveKey(accessToken, null);
    }

    public String splicingSpecialTokenSaveKey(String accessToken, String tenantCode) {
        if (HussarUtils.isNotEmpty((Object)tenantCode)) {
            return SecurityManager.getConfig().getTokenName() + ":oauth2:special-token:" + tenantCode + ":" + accessToken;
        }
        return SecurityManager.getConfig().getTokenName() + ":oauth2:special-token:" + accessToken;
    }

    public String splicingPastAccessTokenSaveKey(String accessToken) {
        return this.splicingPastAccessTokenSaveKey(accessToken, null);
    }

    public String splicingPastAccessTokenSaveKey(String accessToken, String tenantCode) {
        if (HussarUtils.isNotEmpty((Object)tenantCode)) {
            return SecurityManager.getConfig().getTokenName() + ":oauth2:past:access-token:" + tenantCode + ":" + accessToken;
        }
        return SecurityManager.getConfig().getTokenName() + ":oauth2:past:access-token:" + accessToken;
    }

    public String splicingAccessTokenIndexKey(String clientId, Object loginId) {
        return this.splicingAccessTokenIndexKey(clientId, loginId, null);
    }

    public String splicingAccessTokenIndexKey(String clientId, Object loginId, String tenantCode) {
        if (HussarUtils.isNotEmpty((Object)tenantCode)) {
            return SecurityManager.getConfig().getTokenName() + ":oauth2:access-token-index:" + tenantCode + ":" + clientId + ":" + loginId;
        }
        return SecurityManager.getConfig().getTokenName() + ":oauth2:access-token-index:" + clientId + ":" + loginId;
    }

    public String splicingSpecialTokenIndexKey(String clientId, Object loginId) {
        return this.splicingSpecialTokenIndexKey(clientId, loginId, null);
    }

    public String splicingSpecialTokenIndexKey(String clientId, Object loginId, String tenantCode) {
        if (HussarUtils.isNotEmpty((Object)tenantCode)) {
            return SecurityManager.getConfig().getTokenName() + ":oauth2:special-token-index:" + tenantCode + ":" + clientId + ":" + loginId;
        }
        return SecurityManager.getConfig().getTokenName() + ":oauth2:special-token-index:" + clientId + ":" + loginId;
    }

    public String splicingPastAccessTokenIndexKey(String clientId, Object loginId) {
        return this.splicingPastAccessTokenIndexKey(clientId, loginId, null);
    }

    public String splicingPastAccessTokenIndexKey(String clientId, Object loginId, String tenantCode) {
        if (HussarUtils.isNotEmpty((Object)tenantCode)) {
            return SecurityManager.getConfig().getTokenName() + ":oauth2:past:access-token-index:" + tenantCode + ":" + clientId + ":" + loginId;
        }
        return SecurityManager.getConfig().getTokenName() + ":oauth2:past:access-token-index:" + clientId + ":" + loginId;
    }

    public String splicingRefreshTokenSaveKey(String refreshToken) {
        return this.splicingRefreshTokenSaveKey(refreshToken, null);
    }

    public String splicingRefreshTokenSaveKey(String refreshToken, String tenantCode) {
        if (HussarUtils.isNotEmpty((Object)tenantCode)) {
            return SecurityManager.getConfig().getTokenName() + ":oauth2:refresh-token:" + tenantCode + ":" + refreshToken;
        }
        return SecurityManager.getConfig().getTokenName() + ":oauth2:refresh-token:" + refreshToken;
    }

    public String splicingRefreshTokenIndexKey(String clientId, Object loginId) {
        return this.splicingRefreshTokenIndexKey(clientId, loginId, null);
    }

    public String splicingRefreshTokenIndexKey(String clientId, Object loginId, String tenantCode) {
        if (HussarUtils.isNotEmpty((Object)tenantCode)) {
            return SecurityManager.getConfig().getTokenName() + ":oauth2:refresh-token-index:" + tenantCode + ":" + clientId + ":" + loginId;
        }
        return SecurityManager.getConfig().getTokenName() + ":oauth2:refresh-token-index:" + clientId + ":" + loginId;
    }

    public String splicingPastClientTokenSaveKey(String clientToken, String tenantCode) {
        if (HussarUtils.isNotEmpty((Object)tenantCode)) {
            return SecurityManager.getConfig().getTokenName() + ":oauth2:client-token:past:" + tenantCode + ":" + clientToken;
        }
        return SecurityManager.getConfig().getTokenName() + ":oauth2:client-token:past:" + clientToken;
    }

    public String splicingClientTokenSaveKey(String clientToken, String tenantCode) {
        if (HussarUtils.isNotEmpty((Object)tenantCode)) {
            return SecurityManager.getConfig().getTokenName() + ":oauth2:client-token:" + tenantCode + ":" + clientToken;
        }
        return SecurityManager.getConfig().getTokenName() + ":oauth2:client-token:" + clientToken;
    }

    public String splicingPastClientTokenIndexKey(String clientId, String tenantCode) {
        if (HussarUtils.isNotEmpty((Object)tenantCode)) {
            return SecurityManager.getConfig().getTokenName() + ":oauth2:client-token-index:past:" + tenantCode + ":" + clientId;
        }
        return SecurityManager.getConfig().getTokenName() + ":oauth2:client-token-index:past:" + clientId;
    }

    public String splicingClientTokenIndexKey(String clientId, String tenantCode) {
        if (HussarUtils.isNotEmpty((Object)tenantCode)) {
            return SecurityManager.getConfig().getTokenName() + ":oauth2:client-token-index:" + tenantCode + ":" + clientId;
        }
        return SecurityManager.getConfig().getTokenName() + ":oauth2:client-token-index:" + clientId;
    }

    public String splicingPastTokenIndexKey(String clientId) {
        return SecurityManager.getConfig().getTokenName() + ":oauth2:past-token-index:" + clientId;
    }

    public String splicingGrantScopeKey(String clientId, Object loginId) {
        return SecurityManager.getConfig().getTokenName() + ":oauth2:grant-scope:" + clientId + ":" + loginId;
    }
}

