/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.hussar.support.security.plugin.oauth2.enums;

import com.jxdinfo.hussar.platform.core.utils.EnumUtil;
import com.jxdinfo.hussar.support.security.plugin.oauth2.logic.SecurityOAuth2Constants;
import com.jxdinfo.hussar.support.security.plugin.oauth2.model.AccessTokenModel;
import com.jxdinfo.hussar.support.security.plugin.oauth2.model.ClientTokenModel;
import com.jxdinfo.hussar.support.security.plugin.oauth2.model.PastAccessTokenModel;
import com.jxdinfo.hussar.support.security.plugin.oauth2.model.PastClientTokenModel;
import com.jxdinfo.hussar.support.security.plugin.oauth2.model.SpecialTokenModel;
import java.util.Optional;

public enum Auth2TypeEnum {
    CLIENT_CREDENTIALS(SecurityOAuth2Constants.GrantType.client_credentials, ClientTokenModel.class, "\u5ba2\u6237\u7aef\u767b\u5f55", false),
    PAST_CLIENT_CREDENTIALS(SecurityOAuth2Constants.GrantType.client_credentials, PastClientTokenModel.class, "\u5ba2\u6237\u7aef\u767b\u5f55", false),
    AUTHORIZATION_CODE(SecurityOAuth2Constants.GrantType.authorization_code, AccessTokenModel.class, "\u6388\u6743\u7801\u767b\u5f55", true),
    PASSWORD_RENEW(SecurityOAuth2Constants.GrantType.authorization_code, PastAccessTokenModel.class, "\u5bc6\u7801\u6a21\u5f0f\u7eed\u671f", true),
    SPECIAL_TOKEN(SecurityOAuth2Constants.GrantType.other_special, SpecialTokenModel.class, "\u7279\u6b8a\u6a21\u5f0f\u7eed\u671f", true),
    PASSWORD(SecurityOAuth2Constants.GrantType.password, AccessTokenModel.class, "\u5bc6\u7801\u6a21\u5f0f\u767b\u5f55", true);

    private String grantType;
    private Class clz;
    private String desc;
    private boolean enableAuthority;

    public static Auth2TypeEnum getAuth2TypeEnumByType(Class type) {
        Optional optionalAuth2TypeEnum = EnumUtil.nameof(Auth2TypeEnum.class, e -> e.getClz().equals(type));
        return optionalAuth2TypeEnum.isPresent() ? (Auth2TypeEnum)((Object)optionalAuth2TypeEnum.get()) : null;
    }

    private Auth2TypeEnum(String grantType, Class clz, String desc, boolean enableAuthority) {
        this.grantType = grantType;
        this.clz = clz;
        this.desc = desc;
        this.enableAuthority = enableAuthority;
    }

    public String getGrantType() {
        return this.grantType;
    }

    public void setGrantType(String grantType) {
        this.grantType = grantType;
    }

    public Class getClz() {
        return this.clz;
    }

    public void setClz(Class clz) {
        this.clz = clz;
    }

    public String getDesc() {
        return this.desc;
    }

    public void setDesc(String desc) {
        this.desc = desc;
    }

    public boolean isEnableAuthority() {
        return this.enableAuthority;
    }

    public void setEnableAuthority(boolean enableAuthority) {
        this.enableAuthority = enableAuthority;
    }
}

