/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.hussar.support.security.plugin.oauth2.model;

import com.jxdinfo.hussar.support.security.plugin.oauth2.logic.SecurityOAuth2Constants;
import com.jxdinfo.hussar.support.security.plugin.oauth2.model.support.TokenModel;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;

public class ClientTokenModel
implements TokenModel {
    private static final long serialVersionUID = -6541180061782004705L;
    public String clientToken;
    public long expiresTime;
    public String clientId;
    public String scope;
    public List<String> permissions;
    public String tenantCode;

    public ClientTokenModel() {
    }

    public ClientTokenModel(String accessToken, String clientId, String scope) {
        this.clientToken = accessToken;
        this.clientId = clientId;
        this.scope = scope;
    }

    public String toString() {
        return "ClientTokenModel [clientToken=" + this.clientToken + ", expiresTime=" + this.expiresTime + ", clientId=" + this.clientId + ", scope=" + this.scope + ", permissions=" + this.permissions.toString() + ", tenantCode=" + this.tenantCode + "]";
    }

    public long getExpiresIn() {
        long s = (this.expiresTime - System.currentTimeMillis()) / 1000L;
        return s < 1L ? -2L : s;
    }

    public Map<String, Object> toLineMap() {
        LinkedHashMap<String, Object> map = new LinkedHashMap<String, Object>();
        map.put(SecurityOAuth2Constants.Param.client_token, this.clientToken);
        map.put(SecurityOAuth2Constants.Param.expires_in, this.getExpiresIn());
        map.put(SecurityOAuth2Constants.Param.client_id, this.clientId);
        map.put(SecurityOAuth2Constants.Param.scope, this.scope);
        map.put(SecurityOAuth2Constants.Param.tenant_code, this.tenantCode);
        return map;
    }

    @Override
    public String getValidClientId() {
        return this.clientId;
    }
}

