/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.hussar.support.security.plugin.oauth2.handler;

import com.jxdinfo.hussar.platform.core.utils.HussarUtils;
import com.jxdinfo.hussar.support.security.core.SecurityManager;
import com.jxdinfo.hussar.support.security.core.config.SecurityTokenConfig;
import com.jxdinfo.hussar.support.security.core.context.model.SecurityRequest;
import com.jxdinfo.hussar.support.security.core.context.model.SecurityResponse;
import com.jxdinfo.hussar.support.security.core.handler.InnerHandler;
import com.jxdinfo.hussar.support.security.core.router.SecurityRouter;
import com.jxdinfo.hussar.support.security.plugin.oauth2.SecurityOAuth2Manager;
import com.jxdinfo.hussar.support.security.plugin.oauth2.config.SecurityOAuth2Config;
import com.jxdinfo.hussar.support.security.plugin.oauth2.exception.SecurityOAuth2Exception;
import com.jxdinfo.hussar.support.security.plugin.oauth2.handler.Oauth2HandlerInterceptor;
import com.jxdinfo.hussar.support.security.plugin.oauth2.logic.SecurityOAuth2Constants;
import com.jxdinfo.hussar.support.security.plugin.oauth2.logic.SecurityOAuth2Util;
import com.jxdinfo.hussar.support.security.plugin.oauth2.model.support.TokenModel;
import java.util.List;
import org.springframework.web.method.HandlerMethod;

public abstract class AbstractOauth2HandlerInterceptor
implements Oauth2HandlerInterceptor {
    private List<String> distinctIgnoreList;

    public abstract boolean extendPreHandler(SecurityRequest var1, SecurityResponse var2, Object var3);

    @Override
    public String getOauth2Token(SecurityRequest securityRequest) {
        SecurityOAuth2Config securityOAuth2Config = SecurityOAuth2Manager.getConfig();
        SecurityTokenConfig tokenConfig = SecurityManager.getConfig();
        String accessToken = null;
        String accessTokenKey = securityOAuth2Config.getHeaderTokenKey();
        if (accessToken == null && tokenConfig.getIsReadBody().booleanValue()) {
            accessToken = securityRequest.getParam(accessTokenKey);
        }
        if (accessToken == null && tokenConfig.getIsReadHead().booleanValue()) {
            accessToken = securityRequest.getHeader(accessTokenKey);
        }
        if (accessToken == null && tokenConfig.getIsReadCookie().booleanValue()) {
            accessToken = securityRequest.getCookieValue(accessTokenKey);
        }
        return accessToken;
    }

    @Override
    public boolean isPrehandler(SecurityRequest securityRequest, SecurityResponse securityResponse, Object handler) {
        if (!(handler instanceof HandlerMethod)) {
            return true;
        }
        this.distinctIgnoreList = InnerHandler.getIgnoreList((SecurityRequest)securityRequest, (Object)handler);
        if (SecurityRouter.isMatchCurrURI(this.distinctIgnoreList)) {
            return true;
        }
        SecurityOAuth2Config config = SecurityOAuth2Manager.getConfig();
        if (!config.isEnableIsolateFeign() && HussarUtils.isNotEmpty((Object)securityRequest.getHeader(config.getFeignKey())) && config.getFeignSign().equals(securityRequest.getHeader(config.getFeignKey()))) {
            return true;
        }
        boolean preHandler = this.extendPreHandler(securityRequest, securityResponse, handler);
        return preHandler;
    }

    @Override
    public TokenModel getTokenModel(SecurityRequest securityRequest) {
        String oauth2Token = this.getOauth2Token(securityRequest);
        String tenantCode = securityRequest.getHeader(SecurityOAuth2Constants.Param.tenant_code);
        if (HussarUtils.isEmpty((Object)oauth2Token)) {
            return null;
        }
        return this.getTokenModel(oauth2Token, tenantCode);
    }

    @Override
    public TokenModel getTokenModel(String accessToken, String tenantCode) {
        if (HussarUtils.isEmpty((Object)accessToken)) {
            return null;
        }
        TokenModel tokenModel = SecurityOAuth2Util.getTokenModelByAcessToken(accessToken, tenantCode);
        return tokenModel;
    }

    @Override
    public void validateTokenModel(SecurityRequest securityRequest, SecurityResponse securityResponse, Object handler) {
        String authAcessToken = this.getOauth2Token(securityRequest);
        SecurityOAuth2Exception.throwBy(HussarUtils.isEmpty((Object)authAcessToken), "\u8bf7\u6c42\u5931\u8d25,\u672a\u4f20\u9012token=[" + authAcessToken + "]");
        String tenantCode = securityRequest.getHeader(SecurityOAuth2Constants.Param.tenant_code);
        String clientId = securityRequest.getHeaderNotNull(SecurityOAuth2Constants.Param.client_id);
        TokenModel tokenModel = this.getTokenModel(authAcessToken, tenantCode);
        SecurityOAuth2Exception.throwBy(HussarUtils.isEmpty((Object)tokenModel), "\u8bf7\u6c42\u5931\u8d25\uff0ctoken=[" + authAcessToken + "]\u65e0\u6548");
        SecurityOAuth2Exception.throwBy(!HussarUtils.equals((Object)tokenModel.getValidClientId(), (Object)clientId), "\u8bf7\u6c42\u5931\u8d25\uff0ctoken=[" + authAcessToken + "]\u65e0\u6548,\u5bf9\u5e94clientid\u6709\u8bef");
        SecurityRouter.match((String[])new String[]{"/**"}).notMatch(this.getDistinctIgnoreList()).check(() -> SecurityOAuth2Util.checkOauthToken(tokenModel, securityRequest, securityResponse, handler));
    }

    public List<String> getDistinctIgnoreList() {
        return this.distinctIgnoreList;
    }

    public void setDistinctIgnoreList(List<String> distinctIgnoreList) {
        this.distinctIgnoreList = distinctIgnoreList;
    }
}

