/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.hussar.support.security.plugin.oauth2.handler;

import com.jxdinfo.hussar.platform.core.utils.HussarUtils;
import com.jxdinfo.hussar.support.security.core.SecurityManager;
import com.jxdinfo.hussar.support.security.core.config.SecurityTokenConfig;
import com.jxdinfo.hussar.support.security.core.context.model.SecurityRequest;
import com.jxdinfo.hussar.support.security.core.context.model.SecurityResponse;
import com.jxdinfo.hussar.support.security.core.handler.InnerHandler;
import com.jxdinfo.hussar.support.security.core.router.SecurityRouter;
import com.jxdinfo.hussar.support.security.plugin.oauth2.SecurityOAuth2Manager;
import com.jxdinfo.hussar.support.security.plugin.oauth2.config.SecurityOAuth2Config;
import com.jxdinfo.hussar.support.security.plugin.oauth2.handler.Oauth2HandlerInterceptor;
import com.jxdinfo.hussar.support.security.plugin.oauth2.logic.SecurityOAuth2Constants;
import com.jxdinfo.hussar.support.security.plugin.oauth2.logic.SecurityOAuth2Util;
import com.jxdinfo.hussar.support.security.plugin.oauth2.model.support.TokenModel;
import java.util.List;
import org.springframework.web.method.HandlerMethod;

public abstract class AbstractOauth2HandlerInterceptor
implements Oauth2HandlerInterceptor {
    private List<String> distinctIgnoreList;

    public abstract boolean extendPreHandler(SecurityRequest var1, SecurityResponse var2, Object var3);

    @Override
    public String getOauth2Token(SecurityRequest securityRequest) {
        SecurityOAuth2Config securityOAuth2Config = SecurityOAuth2Manager.getConfig();
        SecurityTokenConfig tokenConfig = SecurityManager.getConfig();
        String accessToken = null;
        String accessTokenKey = securityOAuth2Config.getHeaderTokenKey();
        if (accessToken == null && tokenConfig.getIsReadBody().booleanValue()) {
            accessToken = securityRequest.getParam(accessTokenKey);
        }
        if (accessToken == null && tokenConfig.getIsReadHead().booleanValue()) {
            accessToken = securityRequest.getHeader(accessTokenKey);
        }
        if (accessToken == null && tokenConfig.getIsReadCookie().booleanValue()) {
            accessToken = securityRequest.getCookieValue(accessTokenKey);
        }
        return accessToken;
    }

    @Override
    public boolean isPrehandler(SecurityRequest securityRequest, SecurityResponse securityResponse, Object handler) {
        if (!(handler instanceof HandlerMethod)) {
            return true;
        }
        this.distinctIgnoreList = InnerHandler.getIgnoreList((SecurityRequest)securityRequest, (Object)handler);
        if (SecurityRouter.isMatchCurrURI(this.distinctIgnoreList)) {
            return true;
        }
        SecurityOAuth2Config config = SecurityOAuth2Manager.getConfig();
        if (!config.isEnableIsolateFeign() && HussarUtils.isNotEmpty((Object)securityRequest.getHeader(config.getFeignKey())) && config.getFeignSign().equals(securityRequest.getHeader(config.getFeignKey()))) {
            return true;
        }
        boolean preHandler = this.extendPreHandler(securityRequest, securityResponse, handler);
        return preHandler;
    }

    @Override
    public TokenModel getTokenModel(SecurityRequest securityRequest) {
        String oauth2Token = this.getOauth2Token(securityRequest);
        String tenantCode = securityRequest.getHeader(SecurityOAuth2Constants.Param.tenant_code);
        if (HussarUtils.isEmpty((Object)oauth2Token)) {
            return null;
        }
        return this.getTokenModel(oauth2Token, tenantCode);
    }

    @Override
    public TokenModel getTokenModel(String accessToken, String tenantCode) {
        if (HussarUtils.isEmpty((Object)accessToken)) {
            return null;
        }
        TokenModel tokenModel = SecurityOAuth2Util.getTokenModelByAcessToken(accessToken, tenantCode);
        return tokenModel;
    }

    public List<String> getDistinctIgnoreList() {
        return this.distinctIgnoreList;
    }

    public void setDistinctIgnoreList(List<String> distinctIgnoreList) {
        this.distinctIgnoreList = distinctIgnoreList;
    }
}

