/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.hussar.support.security.plugin.oauth2.logic;

import com.jxdinfo.hussar.platform.core.support.service.dto.UserDetails;
import com.jxdinfo.hussar.platform.core.utils.HussarUtils;
import com.jxdinfo.hussar.support.security.core.SecurityManager;
import com.jxdinfo.hussar.support.security.core.context.model.SecurityRequest;
import com.jxdinfo.hussar.support.security.core.context.model.SecurityResponse;
import com.jxdinfo.hussar.support.security.core.session.TokenSession;
import com.jxdinfo.hussar.support.security.core.stp.SecuritySpecialUtil;
import com.jxdinfo.hussar.support.security.core.stp.SecurityTokenInfo;
import com.jxdinfo.hussar.support.security.core.stp.SecurityUtil;
import com.jxdinfo.hussar.support.security.core.strategy.SecurityStrategy;
import com.jxdinfo.hussar.support.security.core.util.SecurityFoxUtil;
import com.jxdinfo.hussar.support.security.plugin.oauth2.SecurityOAuth2Manager;
import com.jxdinfo.hussar.support.security.plugin.oauth2.exception.SecurityOAuth2Exception;
import com.jxdinfo.hussar.support.security.plugin.oauth2.listener.HussarSecurityOauthListener;
import com.jxdinfo.hussar.support.security.plugin.oauth2.logic.SecurityOAuth2Constants;
import com.jxdinfo.hussar.support.security.plugin.oauth2.logic.SecurityOAuth2Util;
import com.jxdinfo.hussar.support.security.plugin.oauth2.model.AccessTokenModel;
import com.jxdinfo.hussar.support.security.plugin.oauth2.model.AccessTokenSign;
import com.jxdinfo.hussar.support.security.plugin.oauth2.model.ClientTokenModel;
import com.jxdinfo.hussar.support.security.plugin.oauth2.model.CodeModel;
import com.jxdinfo.hussar.support.security.plugin.oauth2.model.PastAccessTokenModel;
import com.jxdinfo.hussar.support.security.plugin.oauth2.model.PastAccessTokenSign;
import com.jxdinfo.hussar.support.security.plugin.oauth2.model.RefreshTokenModel;
import com.jxdinfo.hussar.support.security.plugin.oauth2.model.RequestAuthModel;
import com.jxdinfo.hussar.support.security.plugin.oauth2.model.SecurityClientModel;
import com.jxdinfo.hussar.support.security.plugin.oauth2.model.SpecialTokenModel;
import com.jxdinfo.hussar.support.security.plugin.oauth2.model.SpecialTokenSign;
import com.jxdinfo.hussar.support.security.plugin.oauth2.model.support.TokenModel;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Optional;
import java.util.Vector;
import org.springframework.beans.factory.annotation.Autowired;

public class SecurityOAuth2Template {
    @Autowired
    private HussarSecurityOauthListener hussarSecurityOauthListener;

    public SecurityClientModel getClientModel(String clientId) {
        return null;
    }

    public String getOpenid(String clientId, Object loginId) {
        return null;
    }

    public SecurityClientModel checkClientModel(String clientId) {
        SecurityClientModel clientModel = this.getClientModel(clientId);
        if (clientModel == null) {
            throw new SecurityOAuth2Exception("\u65e0\u6548client_id: " + clientId);
        }
        return clientModel;
    }

    public boolean checkOauthToken(TokenModel tokenModel, SecurityRequest securityRequest, SecurityResponse response, Object handler) {
        return true;
    }

    public boolean checkClientGrantype(String grantType, String clientId) {
        SecurityClientModel clientModel = this.getClientModel(clientId);
        SecurityOAuth2Exception.throwBy(HussarUtils.isEmpty((Object)clientModel) || HussarUtils.isEmpty((Object)grantType), "\u8ba4\u8bc1\u5931\u8d25\uff0c\u672a\u67e5\u5230\u6b64client\uff0c\u83b7\u53d6granttype\u4e3a\u7a7a");
        Object[] grantTypes = clientModel.getGrantTypes();
        SecurityOAuth2Exception.throwBy(HussarUtils.isEmpty((Object[])grantTypes), "\u8ba4\u8bc1\u5931\u8d25\uff0cclientId=[" + clientId + "]\uff0c\u672a\u8bbe\u7f6e\u8ba4\u8bc1\u7c7b\u578bgrantType");
        boolean isGrantType = Arrays.stream(grantTypes).anyMatch(str -> str.equalsIgnoreCase(grantType));
        return isGrantType;
    }

    public boolean checkClientGrantype(String grantType, SecurityClientModel securityClientModel) {
        SecurityOAuth2Exception.throwBy(HussarUtils.isEmpty((Object)securityClientModel) || HussarUtils.isEmpty((Object)grantType), "\u8ba4\u8bc1\u5931\u8d25\uff0c\u672a\u67e5\u5230\u6b64client\uff0c\u83b7\u53d6granttype\u4e3a\u7a7a");
        Object[] grantTypes = securityClientModel.getGrantTypes();
        SecurityOAuth2Exception.throwBy(HussarUtils.isEmpty((Object[])grantTypes), "\u8ba4\u8bc1\u5931\u8d25\uff0cclientId=[" + securityClientModel.getClientId() + "]\uff0c\u672a\u8bbe\u7f6e\u8ba4\u8bc1\u7c7b\u578bgrantType");
        boolean isGrantType = Arrays.stream(grantTypes).anyMatch(str -> str.equalsIgnoreCase(grantType));
        return isGrantType;
    }

    public void checkClientScope(String scope, SecurityClientModel securityClientModel) {
        SecurityOAuth2Exception.throwBy(HussarUtils.isEmpty((Object)securityClientModel) || HussarUtils.isEmpty((Object)scope), "\u8ba4\u8bc1\u5931\u8d25\uff0c\u672a\u67e5\u5230\u6b64client\uff0c\u83b7\u53d6scope\u4e3a\u7a7a");
    }

    public AccessTokenModel checkAccessToken(String accessToken) {
        AccessTokenModel at = this.getAccessToken(accessToken);
        SecurityOAuth2Exception.throwBy(at == null, "\u65e0\u6548access_token\uff1a" + accessToken);
        return at;
    }

    public ClientTokenModel checkClientToken(String clientToken) {
        ClientTokenModel ct = this.getClientToken(clientToken);
        SecurityOAuth2Exception.throwBy(ct == null, "\u65e0\u6548\uff1aclient_token" + ct);
        return ct;
    }

    public Object getLoginIdByAccessToken(String accessToken) {
        return this.checkAccessToken((String)accessToken).loginId;
    }

    public void checkScope(String accessToken, String ... scopes) {
        if (scopes == null || scopes.length == 0) {
            return;
        }
        AccessTokenModel at = this.checkAccessToken(accessToken);
        List scopeList = SecurityFoxUtil.convertStringToList((String)at.scope);
        for (String scope : scopes) {
            SecurityOAuth2Exception.throwBy(!scopeList.contains(scope), "\u8be5 Access-Token \u4e0d\u5177\u5907 Scope\uff1a" + scope);
        }
    }

    public RequestAuthModel generateRequestAuth(SecurityRequest req, Object loginId) {
        RequestAuthModel ra = new RequestAuthModel();
        ra.clientId = req.getHeaderNotNull(SecurityOAuth2Constants.Param.client_id);
        ra.responseType = req.getParamNotNull(SecurityOAuth2Constants.Param.response_type);
        ra.redirectUri = req.getParamNotNull(SecurityOAuth2Constants.Param.redirect_uri);
        ra.state = req.getParam(SecurityOAuth2Constants.Param.state);
        ra.scope = req.getParam(SecurityOAuth2Constants.Param.scope, "");
        ra.loginId = loginId;
        return ra;
    }

    public CodeModel generateCode(RequestAuthModel ra) {
        this.deleteCode(this.getCodeValue(ra.clientId, ra.loginId));
        String code = this.randomCode(ra.clientId, ra.loginId, ra.scope);
        CodeModel cm = new CodeModel(code, ra.clientId, ra.scope, ra.loginId, ra.redirectUri);
        this.saveCode(cm);
        this.saveCodeIndex(cm);
        return cm;
    }

    public AccessTokenModel generateAccessToken(String code) {
        CodeModel cm = this.getCode(code);
        SecurityOAuth2Exception.throwBy(cm == null, "\u65e0\u6548code");
        AccessTokenModel at = this.converCodeToAccessToken(cm);
        RefreshTokenModel rt = this.converAccessTokenToRefreshToken(at);
        at.refreshToken = rt.refreshToken;
        at.refreshExpiresTime = rt.expiresTime;
        this.saveAccessToken(at);
        this.saveAccessTokenIndex(at);
        this.saveRefreshToken(rt);
        this.saveRefreshTokenIndex(rt, at.accessToken);
        this.deleteCode(code);
        this.deleteCodeIndex(cm.clientId, cm.loginId);
        return at;
    }

    public AccessTokenModel refreshAccessToken(String refreshToken) {
        String oldAccessToken;
        AccessTokenModel oldAccessTokenModel;
        RefreshTokenModel rt = this.getRefreshToken(refreshToken);
        SecurityOAuth2Exception.throwBy(rt == null, "\u65e0\u6548refresh_token: " + refreshToken);
        AccessTokenSign refreshTokenSign = this.getRefreshTokenValue(rt.clientId, rt.loginId, refreshToken);
        SecurityOAuth2Exception.throwByNull((Object)refreshTokenSign, (String)"\u5237\u65b0token\u5931\u8d25\uff0c\u672a\u627e\u5230\u6b64refreshtoken");
        SecurityClientModel clientModel = this.getClientModel(rt.clientId);
        if (HussarUtils.isEmpty((Object)clientModel)) {
            SecurityOAuth2Exception.throwBy(true, "\u5237\u65b0token\u5931\u8d25,\u672a\u627e\u5230\u6b64client_id=[" + rt.clientId + "]");
        }
        AccessTokenSign refreshAccessToken = SecurityOAuth2Util.getRefreshAccessToken(rt.clientId, rt.loginId, rt.refreshToken);
        if (SecurityOAuth2Manager.getConfig().getIsNewRefresh().booleanValue()) {
            this.deleteRefreshToken(rt.refreshToken);
            rt = this.converRefreshTokenToRefreshToken(rt, clientModel);
        }
        if (HussarUtils.isNotEmpty((Object)(oldAccessTokenModel = this.getAccessToken(oldAccessToken = refreshTokenSign.getAccessToken())))) {
            this.deleteAccessToken(oldAccessTokenModel.accessToken);
            this.deleteAccessTokenIndex(rt.clientId, rt.loginId, oldAccessTokenModel.accessToken);
        }
        this.deleteRefreshTokenIndex(rt.clientId, rt.loginId, refreshTokenSign.getRefreshToken());
        AccessTokenModel newAccesstionTokenModel = this.converRefreshTokenToAccessToken(rt, clientModel);
        this.saveRefreshToken(rt);
        this.saveRefreshTokenIndex(rt, newAccesstionTokenModel.accessToken);
        this.saveAccessToken(newAccesstionTokenModel);
        this.saveAccessTokenIndex(newAccesstionTokenModel);
        if (SecurityOAuth2Manager.getConfig().getRefreshTokenThreshold() > 0L && SecurityOAuth2Manager.getConfig().isEnableSavePastAccessToken()) {
            PastAccessTokenModel pastAccessTokenModel = new PastAccessTokenModel();
            pastAccessTokenModel.setAccessToken(oldAccessTokenModel.accessToken);
            pastAccessTokenModel.setClientId(oldAccessTokenModel.clientId);
            pastAccessTokenModel.setExpiresTime(System.currentTimeMillis() + SecurityOAuth2Manager.getConfig().getRefreshTokenThreshold() * 1000L);
            pastAccessTokenModel.setLoginId(oldAccessTokenModel.loginId);
            pastAccessTokenModel.setOpenid(oldAccessTokenModel.openid);
            pastAccessTokenModel.setLoginTicket(newAccesstionTokenModel.loginTicket);
            pastAccessTokenModel.setScope(oldAccessTokenModel.scope);
            pastAccessTokenModel.setLoginType(oldAccessTokenModel.loginType);
            this.savePastAccessTokenIndex(pastAccessTokenModel, newAccesstionTokenModel);
            this.savePastAccessToken(pastAccessTokenModel);
        }
        this.generateOrRefreshTokenUpdateLoginToken(newAccesstionTokenModel);
        TokenSession tokenSession = SecurityUtil.getTokenSession((String)newAccesstionTokenModel.loginTicket);
        UserDetails userDetails = tokenSession.getUserDetails();
        userDetails.setAccessToken(newAccesstionTokenModel.accessToken);
        tokenSession.addUserDetailToTokenSession(userDetails, newAccesstionTokenModel.loginTicket);
        this.hussarSecurityOauthListener.refreshTokenSuccess(oldAccessToken, userDetails);
        return newAccesstionTokenModel;
    }

    private void generateOrRefreshTokenUpdateLoginToken(AccessTokenModel at) {
        HashMap<String, Object> extandsMap = new HashMap<String, Object>();
        extandsMap.put("access_token", at.accessToken);
        extandsMap.put("client_id", at.clientId);
        extandsMap.put("login_id", at.loginId);
        SecurityManager.getStpLogic((String)at.loginType).updateExtendsMapToTokenSign(at.loginTicket, extandsMap);
        SecurityManager.getStpLogic((String)at.loginType).updateAllLoginTokenTimeout(at.loginTicket, at.getRefreshExpiresIn());
    }

    public AccessTokenModel generateAccessToken(RequestAuthModel ra, boolean isCreateRt, String loginToken, String loginType) {
        String newAtValue = this.randomAccessToken(ra.clientId, ra.loginId, ra.scope);
        AccessTokenModel at = new AccessTokenModel(newAtValue, ra.clientId, ra.loginId, ra.scope);
        at.openid = this.getOpenid(ra.clientId, ra.loginId);
        at.loginTicket = loginToken;
        at.loginType = loginType;
        SecurityClientModel clientModel = this.getClientModel(ra.clientId);
        if (HussarUtils.isEmpty((Object)clientModel)) {
            SecurityOAuth2Exception.throwBy(true, "\u8ba4\u8bc1\u5931\u8d25\uff0cclientid \u4e0d\u5b58\u5728");
        }
        at.expiresTime = System.currentTimeMillis() + ra.getExpiresTime() * 1000L;
        at.refreshExpiresTime = System.currentTimeMillis() + ra.refreshExpiresTime * 1000L;
        if (isCreateRt) {
            RefreshTokenModel rt = this.converAccessTokenToRefreshToken(at);
            this.saveRefreshToken(rt);
            this.saveRefreshTokenIndex(rt, newAtValue);
        }
        this.saveAccessToken(at);
        this.saveAccessTokenIndex(at);
        this.generateOrRefreshTokenUpdateLoginToken(at);
        return at;
    }

    public ClientTokenModel generateClientToken(SecurityClientModel securityClientModel, String scope) {
        String clientTokenValue = this.getClientTokenValue(securityClientModel.getClientId());
        if (HussarUtils.isNotEmpty((Object)clientTokenValue)) {
            this.deleteClientToken(clientTokenValue);
        }
        this.deleteClientTokenIndex(securityClientModel.getClientId());
        ClientTokenModel ct = new ClientTokenModel(this.randomClientToken(securityClientModel.getClientId(), scope), securityClientModel.getClientId(), scope);
        ct.expiresTime = System.currentTimeMillis() + securityClientModel.getAccessTokenValidTime() * 1000L;
        this.saveClientToken(ct);
        this.saveClientTokenIndex(ct);
        return ct;
    }

    public SpecialTokenModel generateSpecialToken(SecurityClientModel securityClientModel, SecurityTokenInfo tokenInfo) {
        SpecialTokenModel sct = new SpecialTokenModel(this.randomSpecialToken(securityClientModel.getClientId(), tokenInfo.getLoginId()), securityClientModel.getClientId());
        sct.setLoginTicket(tokenInfo.getTokenValue());
        sct.setLoginType(tokenInfo.getLoginType());
        sct.expiresTime = System.currentTimeMillis() + securityClientModel.getAccessTokenValidTime() * 1000L;
        sct.setLoginId(tokenInfo.getLoginId());
        this.saveSpecialToken(sct);
        this.saveSpecialTokenIndex(sct);
        HashMap<String, Object> extandsMap = new HashMap<String, Object>();
        extandsMap.put("access_token", sct.accessToken);
        extandsMap.put("client_id", sct.clientId);
        extandsMap.put("login_id", tokenInfo.loginId);
        SecurityManager.getStpLogic((String)sct.loginType).updateExtendsMapToTokenSign(sct.loginTicket, extandsMap);
        SecurityManager.getStpLogic((String)sct.loginType).updateAllLoginTokenTimeout(sct.loginTicket, sct.getExpiresIn());
        return sct;
    }

    public String buildRedirectUri(String redirectUri, String code, String state) {
        String url = SecurityFoxUtil.joinParam((String)redirectUri, (String)SecurityOAuth2Constants.Param.code, (Object)code);
        if (!SecurityFoxUtil.isEmpty((Object)state)) {
            url = SecurityFoxUtil.joinParam((String)url, (String)SecurityOAuth2Constants.Param.state, (Object)state);
        }
        return url;
    }

    public String buildImplicitRedirectUri(String redirectUri, String token, String state) {
        String url = SecurityFoxUtil.joinSharpParam((String)redirectUri, (String)SecurityOAuth2Constants.Param.token, (Object)token);
        if (!SecurityFoxUtil.isEmpty((Object)state)) {
            url = SecurityFoxUtil.joinSharpParam((String)url, (String)SecurityOAuth2Constants.Param.state, (Object)state);
        }
        return url;
    }

    public void revokeAccessToken(String accessToken) {
        AccessTokenModel at = this.getAccessToken(accessToken);
        if (at == null) {
            return;
        }
        TokenSession tokenSession = SecurityUtil.getTokenSession((String)at.loginTicket);
        UserDetails userDetails = tokenSession.getUserDetails();
        this.deleteAccessToken(accessToken);
        this.deleteAccessTokenIndex(at.clientId, at.loginId, accessToken);
        PastAccessTokenSign pastAccessTokenValue = this.getPastAccessTokenValue(at.clientId, at.loginId, accessToken);
        if (HussarUtils.isNotEmpty((Object)pastAccessTokenValue)) {
            String oldAccessToken = pastAccessTokenValue.getOldAccessToken();
            this.deletePastAccessToken(oldAccessToken);
        }
        this.deletePastAccessTokenIndex(at.clientId, at.loginId, accessToken);
        this.deleteRefreshToken(at.refreshToken);
        this.deleteRefreshTokenIndex(at.clientId, at.loginId, at.refreshToken);
        SecurityUtil.logoutByTokenValue((String)at.loginTicket, (String)at.loginId.toString());
        this.hussarSecurityOauthListener.logoutSuccess(userDetails);
    }

    public void revokeAccessTokenNotLoginOutAndRefreshToken(String clientId, String loginId, String accessToken) {
        this.hussarSecurityOauthListener.displacementSuccess(clientId, loginId, accessToken);
        AccessTokenSign refreshTokenValueByAccessToken = this.getRefreshTokenValueByAccessToken(clientId, loginId, accessToken);
        if (HussarUtils.isEmpty((Object)refreshTokenValueByAccessToken)) {
            this.deleteAccessTokenIndex(clientId, loginId, accessToken);
            this.deleteRefreshTokenIndexByAccessToken(clientId, loginId, accessToken);
            return;
        }
        this.deleteAccessToken(accessToken);
        this.deleteAccessTokenIndex(clientId, loginId, accessToken);
        this.deleteRefreshToken(refreshTokenValueByAccessToken.getRefreshToken());
        this.deleteRefreshTokenIndex(clientId, loginId, refreshTokenValueByAccessToken.getRefreshToken());
    }

    public void revokeSpecialAccessTokenNotLoginOut(String clientId, String loginId, String accessToken) {
        this.hussarSecurityOauthListener.displacementSuccess(clientId, loginId, accessToken);
        this.deleteSpecialToken(accessToken);
        this.deleteSpecialTokenIndex(clientId, loginId, accessToken);
    }

    public void revokeSpecialToken(String specialToken) {
        SpecialTokenModel st = this.getSpecialToken(specialToken);
        if (st == null) {
            return;
        }
        TokenSession tokenSession = SecuritySpecialUtil.getTokenSession((String)st.loginTicket);
        UserDetails userDetails = tokenSession.getUserDetails();
        this.deleteSpecialToken(specialToken);
        this.deleteSpecialTokenIndex(st.clientId, st.loginId, specialToken);
        SecurityManager.getStpLogic((String)st.loginType).logoutByTokenValue(st.loginTicket, st.loginId.toString());
        this.hussarSecurityOauthListener.logoutSuccess(userDetails);
    }

    public boolean isGrant(Object loginId, String clientId, String scope) {
        List grantScopeList = SecurityFoxUtil.convertStringToList((String)this.getGrantScope(clientId, loginId));
        List scopeList = SecurityFoxUtil.convertStringToList((String)scope);
        return scopeList.size() == 0 || grantScopeList.containsAll(scopeList);
    }

    public void checkContract(String clientId, String scope) {
        List scopelist;
        List<String> clientScopeList = Arrays.asList(this.checkClientModel((String)clientId).contractScope);
        if (!clientScopeList.containsAll(scopelist = SecurityFoxUtil.convertStringToList((String)scope))) {
            throw new SecurityOAuth2Exception("\u8bf7\u6c42\u7684Scope\u6682\u672a\u7b7e\u7ea6");
        }
    }

    public void checkRightUrl(String clientId, String url) {
        List allowList;
        if (!SecurityFoxUtil.isUrl((String)url)) {
            throw new SecurityOAuth2Exception("\u65e0\u6548redirect_url\uff1a" + url);
        }
        int qIndex = url.indexOf("?");
        if (qIndex != -1) {
            url = url.substring(0, qIndex);
        }
        if (!((Boolean)SecurityStrategy.me.hasElement.apply(allowList = SecurityFoxUtil.convertStringToList((String)this.checkClientModel((String)clientId).allowUrl), url)).booleanValue()) {
            throw new SecurityOAuth2Exception("\u975e\u6cd5redirect_url\uff1a" + url);
        }
    }

    public SecurityClientModel checkClientSecret(String clientId, String clientSecret) {
        SecurityClientModel cm = this.checkClientModel(clientId);
        SecurityOAuth2Exception.throwBy(cm.clientSecret == null || !cm.clientSecret.equals(clientSecret), "\u65e0\u6548client_secret: " + clientSecret);
        return cm;
    }

    public CodeModel checkGainTokenParam(String code, String clientId, String clientSecret, String redirectUri) {
        CodeModel cm = this.getCode(code);
        SecurityOAuth2Exception.throwBy(cm == null, "\u65e0\u6548code: " + code);
        SecurityOAuth2Exception.throwBy(!cm.clientId.equals(clientId), "\u65e0\u6548client_id: " + clientId);
        String dbSecret = this.checkClientModel((String)clientId).clientSecret;
        SecurityOAuth2Exception.throwBy(dbSecret == null || !dbSecret.equals(clientSecret), "\u65e0\u6548client_secret: " + clientSecret);
        if (!SecurityFoxUtil.isEmpty((Object)redirectUri)) {
            SecurityOAuth2Exception.throwBy(!redirectUri.equals(cm.redirectUri), "\u65e0\u6548redirect_uri: " + redirectUri);
        }
        return cm;
    }

    public RefreshTokenModel checkRefreshTokenParam(String clientId, String clientSecret, String refreshToken) {
        RefreshTokenModel rt = this.getRefreshToken(refreshToken);
        SecurityOAuth2Exception.throwBy(rt == null, "\u65e0\u6548refresh_token: " + refreshToken);
        SecurityOAuth2Exception.throwBy(!rt.clientId.equals(clientId), "\u65e0\u6548client_id: " + clientId);
        String dbSecret = this.checkClientModel((String)clientId).clientSecret;
        return rt;
    }

    public AccessTokenModel checkAccessTokenParam(String clientId, String clientSecret, String accessToken) {
        AccessTokenModel at = this.checkAccessToken(accessToken);
        SecurityOAuth2Exception.throwBy(!at.clientId.equals(clientId), "\u65e0\u6548client_id\uff1a" + clientId);
        this.checkClientSecret(clientId, clientSecret);
        return at;
    }

    public AccessTokenModel converCodeToAccessToken(CodeModel cm) {
        AccessTokenModel at = new AccessTokenModel();
        at.accessToken = this.randomAccessToken(cm.clientId, cm.loginId, cm.scope);
        at.clientId = cm.clientId;
        at.loginId = cm.loginId;
        at.scope = cm.scope;
        at.openid = this.getOpenid(cm.clientId, cm.loginId);
        at.expiresTime = System.currentTimeMillis() + SecurityOAuth2Manager.getConfig().getAccessTokenTimeout() * 1000L;
        return at;
    }

    public RefreshTokenModel converAccessTokenToRefreshToken(AccessTokenModel at) {
        SecurityClientModel clientModel = this.getClientModel(at.clientId);
        if (HussarUtils.isEmpty((Object)clientModel)) {
            SecurityOAuth2Exception.throwBy(true, "\u8ba4\u8bc1\u5931\u8d25\uff0cclientid \u4e0d\u5b58\u5728");
        }
        RefreshTokenModel rt = new RefreshTokenModel();
        rt.refreshToken = this.randomRefreshToken(at.clientId, at.loginId, at.scope);
        rt.clientId = at.clientId;
        rt.loginId = at.loginId;
        rt.scope = at.scope;
        rt.openid = at.openid;
        rt.expiresTime = System.currentTimeMillis() + clientModel.getRefreshTokenValidTime() * 1000L;
        rt.loginTicket = at.loginTicket;
        at.refreshToken = rt.refreshToken;
        at.refreshExpiresTime = rt.expiresTime;
        return rt;
    }

    public AccessTokenModel converRefreshTokenToAccessToken(RefreshTokenModel rt, SecurityClientModel clientModel) {
        AccessTokenModel at = new AccessTokenModel();
        at.accessToken = this.randomAccessToken(rt.clientId, rt.loginId, rt.scope);
        at.refreshToken = rt.refreshToken;
        at.clientId = rt.clientId;
        at.loginId = rt.loginId;
        at.scope = rt.scope;
        at.openid = rt.openid;
        at.expiresTime = System.currentTimeMillis() + clientModel.getAccessTokenValidTime() * 1000L;
        at.refreshExpiresTime = rt.expiresTime;
        at.loginTicket = rt.loginTicket;
        return at;
    }

    public RefreshTokenModel converRefreshTokenToRefreshToken(RefreshTokenModel rt, SecurityClientModel clientModel) {
        RefreshTokenModel newRt = new RefreshTokenModel();
        newRt.refreshToken = this.randomRefreshToken(rt.clientId, rt.loginId, rt.scope);
        newRt.expiresTime = System.currentTimeMillis() + clientModel.getRefreshTokenValidTime() * 1000L;
        newRt.clientId = rt.clientId;
        newRt.scope = rt.scope;
        newRt.loginId = rt.loginId;
        newRt.openid = rt.openid;
        newRt.loginTicket = rt.loginTicket;
        return newRt;
    }

    public void saveCode(CodeModel c) {
        if (c == null) {
            return;
        }
        SecurityManager.getSaTokenDao().setObject(this.splicingCodeSaveKey(c.code), (Object)c, SecurityOAuth2Manager.getConfig().getCodeTimeout());
    }

    public void saveCodeIndex(CodeModel c) {
        if (c == null) {
            return;
        }
        SecurityManager.getSaTokenDao().set(this.splicingCodeIndexKey(c.clientId, c.loginId), c.code, SecurityOAuth2Manager.getConfig().getCodeTimeout());
    }

    public void saveAccessToken(AccessTokenModel at) {
        if (at == null) {
            return;
        }
        SecurityManager.getSaTokenDao().setObject(this.splicingAccessTokenSaveKey(at.accessToken), (Object)at, at.getExpiresIn());
    }

    public void saveSpecialToken(SpecialTokenModel st) {
        if (st == null) {
            return;
        }
        SecurityManager.getSaTokenDao().setObject(this.splicingSpecialTokenSaveKey(st.accessToken), (Object)st, st.getExpiresIn());
    }

    public void savePastAccessToken(PastAccessTokenModel pat) {
        if (pat == null) {
            return;
        }
        SecurityManager.getSaTokenDao().setObject(this.splicingPastAccessTokenSaveKey(pat.accessToken), (Object)pat, pat.getExpiresIn());
    }

    public void saveAccessTokenIndex(AccessTokenModel at) {
        if (at == null) {
            return;
        }
        Vector<AccessTokenSign> accessTokenSignList = (Vector<AccessTokenSign>)SecurityManager.getSaTokenDao().getObject(this.splicingAccessTokenIndexKey(at.clientId, at.loginId));
        if (HussarUtils.isEmpty((Object)accessTokenSignList)) {
            accessTokenSignList = new Vector<AccessTokenSign>();
            AccessTokenSign accessTokenSign = new AccessTokenSign(at.accessToken, at.refreshToken, 1);
            accessTokenSignList.add(accessTokenSign);
        } else {
            AccessTokenSign accessTokenSign = new AccessTokenSign(at.accessToken, at.refreshToken, accessTokenSignList.size() + 1);
            accessTokenSignList.add(accessTokenSign);
        }
        SecurityManager.getSaTokenDao().setObject(this.splicingAccessTokenIndexKey(at.clientId, at.loginId), accessTokenSignList, at.getExpiresIn());
    }

    public void saveSpecialTokenIndex(SpecialTokenModel sct) {
        if (sct == null) {
            return;
        }
        Vector<SpecialTokenSign> specialTokenSignList = (Vector<SpecialTokenSign>)SecurityManager.getSaTokenDao().getObject(this.splicingSpecialTokenIndexKey(sct.clientId, sct.loginId));
        if (HussarUtils.isEmpty((Object)specialTokenSignList)) {
            specialTokenSignList = new Vector<SpecialTokenSign>();
            SpecialTokenSign specialTokenSign = new SpecialTokenSign(sct.accessToken, 1);
            specialTokenSignList.add(specialTokenSign);
        } else {
            SpecialTokenSign specialTokenSign = new SpecialTokenSign(sct.accessToken, specialTokenSignList.size() + 1);
            specialTokenSignList.add(specialTokenSign);
        }
        SecurityManager.getSaTokenDao().setObject(this.splicingSpecialTokenIndexKey(sct.clientId, sct.loginId), specialTokenSignList, sct.getExpiresIn());
    }

    public void savePastAccessTokenIndex(PastAccessTokenModel pat, AccessTokenModel accessTokenModel) {
        if (pat == null) {
            return;
        }
        Vector<PastAccessTokenSign> pastAccessTokenSignList = (Vector<PastAccessTokenSign>)SecurityManager.getSaTokenDao().getObject(this.splicingPastAccessTokenIndexKey(pat.clientId, pat.loginId));
        if (HussarUtils.isEmpty((Object)pastAccessTokenSignList)) {
            pastAccessTokenSignList = new Vector<PastAccessTokenSign>();
            PastAccessTokenSign pastAccessTokenSign = new PastAccessTokenSign(pat.accessToken, accessTokenModel.accessToken);
            pastAccessTokenSignList.add(pastAccessTokenSign);
        } else {
            PastAccessTokenSign pastAccessTokenSign = new PastAccessTokenSign(pat.accessToken, accessTokenModel.accessToken);
            pastAccessTokenSignList.add(pastAccessTokenSign);
        }
        SecurityManager.getSaTokenDao().setObject(this.splicingPastAccessTokenIndexKey(pat.clientId, pat.loginId), pastAccessTokenSignList, pat.getExpiresIn());
    }

    public void saveRefreshToken(RefreshTokenModel rt) {
        if (rt == null) {
            return;
        }
        SecurityManager.getSaTokenDao().setObject(this.splicingRefreshTokenSaveKey(rt.refreshToken), (Object)rt, rt.getExpiresIn());
    }

    public void saveRefreshTokenIndex(RefreshTokenModel rt, String accessToken) {
        if (rt == null) {
            return;
        }
        Vector<AccessTokenSign> refreshTokenSignList = (Vector<AccessTokenSign>)SecurityManager.getSaTokenDao().getObject(this.splicingRefreshTokenIndexKey(rt.clientId, rt.loginId));
        if (HussarUtils.isEmpty((Object)refreshTokenSignList)) {
            refreshTokenSignList = new Vector<AccessTokenSign>();
            AccessTokenSign accessTokenSign = new AccessTokenSign(accessToken, rt.refreshToken, 1);
            refreshTokenSignList.add(accessTokenSign);
        } else {
            AccessTokenSign accessTokenSign = new AccessTokenSign(accessToken, rt.refreshToken, refreshTokenSignList.size() + 1);
            refreshTokenSignList.add(accessTokenSign);
        }
        SecurityManager.getSaTokenDao().setObject(this.splicingRefreshTokenIndexKey(rt.clientId, rt.loginId), refreshTokenSignList, rt.getExpiresIn());
    }

    public void updateAllAccessTokenTimeout(String accessToken, long accessTokenTimeout, long refreshTokenTimeout) {
        AccessTokenModel accessTokenModel = this.getAccessToken(accessToken);
        if (HussarUtils.isEmpty((Object)accessTokenModel)) {
            return;
        }
        accessTokenModel.expiresTime = System.currentTimeMillis() + accessTokenTimeout * 1000L;
        accessTokenModel.refreshExpiresTime = System.currentTimeMillis() + refreshTokenTimeout * 1000L;
        SecurityManager.getSaTokenDao().updateObjectTimeout(this.splicingAccessTokenIndexKey(accessTokenModel.clientId, accessTokenModel.loginId), accessTokenTimeout);
        SecurityManager.getSaTokenDao().setObject(this.splicingAccessTokenSaveKey(accessToken), (Object)accessTokenModel, accessTokenTimeout);
        RefreshTokenModel refreshTokenModel = this.getRefreshToken(accessTokenModel.refreshToken);
        refreshTokenModel.expiresTime = System.currentTimeMillis() + refreshTokenTimeout * 1000L;
        SecurityManager.getSaTokenDao().updateObjectTimeout(this.splicingRefreshTokenIndexKey(accessTokenModel.clientId, accessTokenModel.loginId), refreshTokenTimeout);
        SecurityManager.getSaTokenDao().setObject(this.splicingRefreshTokenSaveKey(accessTokenModel.refreshToken), (Object)refreshTokenModel, refreshTokenTimeout);
    }

    public void saveClientToken(ClientTokenModel ct) {
        if (ct == null) {
            return;
        }
        SecurityManager.getSaTokenDao().setObject(this.splicingClientTokenSaveKey(ct.clientToken), (Object)ct, ct.getExpiresIn());
    }

    public void saveClientTokenIndex(ClientTokenModel ct) {
        if (ct == null) {
            return;
        }
        SecurityManager.getSaTokenDao().set(this.splicingClientTokenIndexKey(ct.clientId), ct.clientToken, ct.getExpiresIn());
    }

    public void savePastTokenIndex(ClientTokenModel ct) {
        if (ct == null) {
            return;
        }
        SecurityManager.getSaTokenDao().set(this.splicingPastTokenIndexKey(ct.clientId), ct.clientToken, ct.getExpiresIn());
    }

    public void saveGrantScope(String clientId, Object loginId, String scope) {
        if (!SecurityFoxUtil.isEmpty((Object)scope)) {
            long ttl = SecurityOAuth2Manager.getConfig().getAccessTokenTimeout();
            SecurityManager.getSaTokenDao().set(this.splicingGrantScopeKey(clientId, loginId), scope, ttl);
        }
    }

    public CodeModel getCode(String code) {
        if (code == null) {
            return null;
        }
        return (CodeModel)SecurityManager.getSaTokenDao().getObject(this.splicingCodeSaveKey(code));
    }

    public String getCodeValue(String clientId, Object loginId) {
        return SecurityManager.getSaTokenDao().get(this.splicingCodeIndexKey(clientId, loginId));
    }

    public AccessTokenModel getAccessToken(String accessToken) {
        if (accessToken == null) {
            return null;
        }
        return (AccessTokenModel)SecurityManager.getSaTokenDao().getObject(this.splicingAccessTokenSaveKey(accessToken));
    }

    public SpecialTokenModel getSpecialToken(String specialToken) {
        if (specialToken == null) {
            return null;
        }
        return (SpecialTokenModel)SecurityManager.getSaTokenDao().getObject(this.splicingSpecialTokenSaveKey(specialToken));
    }

    public PastAccessTokenModel getPastAccessToken(String accessToken) {
        if (accessToken == null) {
            return null;
        }
        return (PastAccessTokenModel)SecurityManager.getSaTokenDao().getObject(this.splicingPastAccessTokenSaveKey(accessToken));
    }

    public TokenModel getPastOrAccessToken(String accessToken) {
        if (accessToken == null) {
            return null;
        }
        AccessTokenModel accessTokenModel = this.getAccessToken(accessToken);
        if (HussarUtils.isNotEmpty((Object)accessTokenModel)) {
            return accessTokenModel;
        }
        PastAccessTokenModel pastAccessToken = null;
        if (SecurityOAuth2Manager.getConfig().getRefreshTokenThreshold() > 0L && SecurityOAuth2Manager.getConfig().isEnableSavePastAccessToken()) {
            pastAccessToken = this.getPastAccessToken(accessToken);
        }
        return pastAccessToken;
    }

    public TokenModel getTokenModelByAcessToken(String accessToken) {
        TokenModel returnTokenModel = null;
        returnTokenModel = this.getPastOrAccessToken(accessToken);
        if (HussarUtils.isNotEmpty((Object)returnTokenModel)) {
            return returnTokenModel;
        }
        returnTokenModel = this.getClientToken(accessToken);
        if (HussarUtils.isNotEmpty((Object)returnTokenModel)) {
            return returnTokenModel;
        }
        returnTokenModel = this.getSpecialToken(accessToken);
        if (HussarUtils.isNotEmpty((Object)returnTokenModel)) {
            return returnTokenModel;
        }
        return null;
    }

    public List<AccessTokenSign> getAccessTokenValue(String clientId, Object loginId) {
        return (List)SecurityManager.getSaTokenDao().getObject(this.splicingAccessTokenIndexKey(clientId, loginId));
    }

    public List<PastAccessTokenSign> getPastAccessTokenValue(String clientId, Object loginId) {
        return (List)SecurityManager.getSaTokenDao().getObject(this.splicingPastAccessTokenIndexKey(clientId, loginId));
    }

    public PastAccessTokenSign getPastAccessTokenValue(String clientId, Object loginId, String newAccessToken) {
        List pastAccessTokenSignList = (List)SecurityManager.getSaTokenDao().getObject(this.splicingPastAccessTokenIndexKey(clientId, loginId));
        if (HussarUtils.isEmpty((Object)pastAccessTokenSignList)) {
            return null;
        }
        Optional<PastAccessTokenSign> first = pastAccessTokenSignList.stream().filter(pastAccessTokenSign -> pastAccessTokenSign.getNewAccessToken().equalsIgnoreCase(newAccessToken)).findFirst();
        return first.orElse(null);
    }

    public RefreshTokenModel getRefreshToken(String refreshToken) {
        if (refreshToken == null) {
            return null;
        }
        return (RefreshTokenModel)SecurityManager.getSaTokenDao().getObject(this.splicingRefreshTokenSaveKey(refreshToken));
    }

    public List<AccessTokenSign> getRefreshTokenValue(String clientId, Object loginId) {
        return (List)SecurityManager.getSaTokenDao().getObject(this.splicingRefreshTokenIndexKey(clientId, loginId));
    }

    public AccessTokenSign getRefreshTokenValue(String clientId, Object loginId, String refreshToken) {
        List accessTokenSignList = (List)SecurityManager.getSaTokenDao().getObject(this.splicingRefreshTokenIndexKey(clientId, loginId));
        if (HussarUtils.isEmpty((Object)accessTokenSignList)) {
            return null;
        }
        Optional<AccessTokenSign> first = accessTokenSignList.stream().filter(accessTokenSign -> accessTokenSign.getRefreshToken().equalsIgnoreCase(refreshToken)).findFirst();
        return first.orElse(null);
    }

    public AccessTokenSign getRefreshTokenValueByAccessToken(String clientId, Object loginId, String accessToken) {
        List accessTokenSignList = (List)SecurityManager.getSaTokenDao().getObject(this.splicingRefreshTokenIndexKey(clientId, loginId));
        if (HussarUtils.isEmpty((Object)accessTokenSignList)) {
            return null;
        }
        Optional<AccessTokenSign> first = accessTokenSignList.stream().filter(accessTokenSign -> accessTokenSign.getAccessToken().equalsIgnoreCase(accessToken)).findFirst();
        return first.orElse(null);
    }

    public ClientTokenModel getClientToken(String clientToken) {
        if (clientToken == null) {
            return null;
        }
        return (ClientTokenModel)SecurityManager.getSaTokenDao().getObject(this.splicingClientTokenSaveKey(clientToken));
    }

    public String getClientTokenValue(String clientId) {
        return SecurityManager.getSaTokenDao().get(this.splicingClientTokenIndexKey(clientId));
    }

    public String getPastTokenValue(String clientId) {
        return SecurityManager.getSaTokenDao().get(this.splicingPastTokenIndexKey(clientId));
    }

    public String getGrantScope(String clientId, Object loginId) {
        return SecurityManager.getSaTokenDao().get(this.splicingGrantScopeKey(clientId, loginId));
    }

    public void deleteCode(String code) {
        if (code != null) {
            SecurityManager.getSaTokenDao().deleteObject(this.splicingCodeSaveKey(code));
        }
    }

    public void deleteCodeIndex(String clientId, Object loginId) {
        SecurityManager.getSaTokenDao().delete(this.splicingCodeIndexKey(clientId, loginId));
    }

    public void deleteAccessToken(String accessToken) {
        if (accessToken != null) {
            SecurityManager.getSaTokenDao().deleteObject(this.splicingAccessTokenSaveKey(accessToken));
        }
    }

    public void deleteSpecialToken(String specialToken) {
        if (specialToken != null) {
            SecurityManager.getSaTokenDao().deleteObject(this.splicingSpecialTokenSaveKey(specialToken));
        }
    }

    public void deletePastAccessToken(String accessToken) {
        if (accessToken != null) {
            SecurityManager.getSaTokenDao().deleteObject(this.splicingPastAccessTokenSaveKey(accessToken));
        }
    }

    public void deleteSpecialTokenIndex(String clientId, Object loginId, String specialToken) {
        List specialTokenSignList = (List)SecurityManager.getSaTokenDao().getObject(this.splicingSpecialTokenIndexKey(clientId, loginId));
        if (HussarUtils.isEmpty((Object)specialTokenSignList)) {
            return;
        }
        if (specialTokenSignList.size() == 1) {
            SecurityManager.getSaTokenDao().deleteObject(this.splicingSpecialTokenIndexKey(clientId, loginId));
            return;
        }
        int index = -1;
        SpecialTokenSign ats = null;
        ArrayList<SpecialTokenSign> specialTokenSigns = new ArrayList<SpecialTokenSign>();
        for (int i = 0; i < specialTokenSignList.size(); ++i) {
            ats = (SpecialTokenSign)specialTokenSignList.get(i);
            if (ats.getAccessToken().equalsIgnoreCase(specialToken)) {
                index = i;
                continue;
            }
            specialTokenSigns.add(ats);
        }
        int finalIndex = index;
        specialTokenSigns.forEach(accessTokenSign -> {
            if (accessTokenSign.getCurrentTokenCount() > finalIndex) {
                accessTokenSign.setCurrentTokenCount(accessTokenSign.getCurrentTokenCount() - 1);
            }
        });
        SecurityManager.getSaTokenDao().updateObject(this.splicingSpecialTokenIndexKey(clientId, loginId), specialTokenSigns);
    }

    public void deleteAccessTokenIndex(String clientId, Object loginId, String accessToken) {
        List accessTokenSignList = (List)SecurityManager.getSaTokenDao().getObject(this.splicingAccessTokenIndexKey(clientId, loginId));
        if (HussarUtils.isEmpty((Object)accessTokenSignList)) {
            return;
        }
        if (accessTokenSignList.size() == 1) {
            SecurityManager.getSaTokenDao().deleteObject(this.splicingAccessTokenIndexKey(clientId, loginId));
            return;
        }
        int index = -1;
        AccessTokenSign ats = null;
        ArrayList<AccessTokenSign> accessTokenSigns = new ArrayList<AccessTokenSign>();
        for (int i = 0; i < accessTokenSignList.size(); ++i) {
            ats = (AccessTokenSign)accessTokenSignList.get(i);
            if (ats.getAccessToken().equalsIgnoreCase(accessToken)) {
                index = i;
                continue;
            }
            accessTokenSigns.add(ats);
        }
        int finalIndex = index;
        accessTokenSigns.forEach(accessTokenSign -> {
            if (accessTokenSign.getCurrentTokenCount() > finalIndex) {
                accessTokenSign.setCurrentTokenCount(accessTokenSign.getCurrentTokenCount() - 1);
            }
        });
        SecurityManager.getSaTokenDao().updateObject(this.splicingAccessTokenIndexKey(clientId, loginId), accessTokenSigns);
    }

    public void deletePastAccessTokenIndex(String clientId, Object loginId, String newAccessToken) {
        List pastAccessTokenSignList = (List)SecurityManager.getSaTokenDao().getObject(this.splicingPastAccessTokenIndexKey(clientId, loginId));
        if (HussarUtils.isEmpty((Object)pastAccessTokenSignList)) {
            return;
        }
        if (pastAccessTokenSignList.size() == 1) {
            SecurityManager.getSaTokenDao().deleteObject(this.splicingPastAccessTokenIndexKey(clientId, loginId));
            return;
        }
        ArrayList<PastAccessTokenSign> pastAccessTokenSigns = new ArrayList<PastAccessTokenSign>();
        for (int i = 0; i < pastAccessTokenSignList.size(); ++i) {
            PastAccessTokenSign pats = (PastAccessTokenSign)pastAccessTokenSignList.get(i);
            if (pats.getNewAccessToken().equalsIgnoreCase(newAccessToken)) continue;
            pastAccessTokenSigns.add(pats);
        }
        SecurityManager.getSaTokenDao().updateObject(this.splicingPastAccessTokenIndexKey(clientId, loginId), pastAccessTokenSigns);
    }

    public void deleteRefreshToken(String refreshToken) {
        if (refreshToken != null) {
            SecurityManager.getSaTokenDao().deleteObject(this.splicingRefreshTokenSaveKey(refreshToken));
        }
    }

    public void deleteRefreshTokenIndex(String clientId, Object loginId, String refreshToken) {
        List refreshTokenSignList = (List)SecurityManager.getSaTokenDao().getObject(this.splicingRefreshTokenIndexKey(clientId, loginId));
        if (HussarUtils.isEmpty((Object)refreshTokenSignList)) {
            return;
        }
        if (refreshTokenSignList.size() == 1) {
            SecurityManager.getSaTokenDao().deleteObject(this.splicingRefreshTokenIndexKey(clientId, loginId));
            return;
        }
        int index = -1;
        AccessTokenSign ats = null;
        ArrayList<AccessTokenSign> refreshTokenSigns = new ArrayList<AccessTokenSign>();
        for (int i = 0; i < refreshTokenSignList.size(); ++i) {
            ats = (AccessTokenSign)refreshTokenSignList.get(i);
            if (ats.getRefreshToken().equalsIgnoreCase(refreshToken)) {
                index = i;
                continue;
            }
            refreshTokenSigns.add(ats);
        }
        int finalIndex = index;
        refreshTokenSigns.forEach(accessTokenSign -> {
            if (accessTokenSign.getCurrentTokenCount() > finalIndex) {
                accessTokenSign.setCurrentTokenCount(accessTokenSign.getCurrentTokenCount() - 1);
            }
        });
        SecurityManager.getSaTokenDao().updateObject(this.splicingRefreshTokenIndexKey(clientId, loginId), refreshTokenSigns);
    }

    public void deleteRefreshTokenIndexByAccessToken(String clientId, Object loginId, String accessToken) {
        List refreshTokenSignList = (List)SecurityManager.getSaTokenDao().getObject(this.splicingRefreshTokenIndexKey(clientId, loginId));
        if (HussarUtils.isEmpty((Object)refreshTokenSignList)) {
            return;
        }
        if (refreshTokenSignList.size() == 1) {
            SecurityManager.getSaTokenDao().deleteObject(this.splicingRefreshTokenIndexKey(clientId, loginId));
            return;
        }
        int index = -1;
        AccessTokenSign ats = null;
        ArrayList<AccessTokenSign> refreshTokenSigns = new ArrayList<AccessTokenSign>();
        for (int i = 0; i < refreshTokenSignList.size(); ++i) {
            ats = (AccessTokenSign)refreshTokenSignList.get(i);
            if (ats.getAccessToken().equalsIgnoreCase(accessToken)) {
                index = i;
                continue;
            }
            refreshTokenSigns.add(ats);
        }
        int finalIndex = index;
        refreshTokenSigns.forEach(accessTokenSign -> {
            if (accessTokenSign.getCurrentTokenCount() > finalIndex) {
                accessTokenSign.setCurrentTokenCount(accessTokenSign.getCurrentTokenCount() - 1);
            }
        });
        SecurityManager.getSaTokenDao().updateObject(this.splicingRefreshTokenIndexKey(clientId, loginId), refreshTokenSigns);
    }

    public void deleteTokenToIdMapping(String tokenValue, String loginType) {
        if (HussarUtils.isEmpty((Object)tokenValue)) {
            return;
        }
        SecurityManager.getStpLogic((String)loginType).deleteTokenToIdMapping(tokenValue);
    }

    public void deleteClientToken(String clientToken) {
        if (clientToken != null) {
            SecurityManager.getSaTokenDao().deleteObject(this.splicingClientTokenSaveKey(clientToken));
        }
    }

    public void deleteClientTokenIndex(String clientId) {
        SecurityManager.getSaTokenDao().delete(this.splicingClientTokenIndexKey(clientId));
    }

    public void deletePastTokenIndex(String clientId) {
        SecurityManager.getSaTokenDao().delete(this.splicingPastTokenIndexKey(clientId));
    }

    public void deleteGrantScope(String clientId, Object loginId) {
        SecurityManager.getSaTokenDao().delete(this.splicingGrantScopeKey(clientId, loginId));
    }

    public String randomCode(String clientId, Object loginId, String scope) {
        return SecurityFoxUtil.getRandomString((int)60);
    }

    public String randomAccessToken(String clientId, Object loginId, String scope) {
        return SecurityFoxUtil.getRandomString((int)60);
    }

    public String randomSpecialToken(String clientId, Object loginId) {
        return SecurityFoxUtil.getRandomString((int)60);
    }

    public String randomRefreshToken(String clientId, Object loginId, String scope) {
        return SecurityFoxUtil.getRandomString((int)60);
    }

    public String randomClientToken(String clientId, String scope) {
        return SecurityFoxUtil.getRandomString((int)60);
    }

    public String splicingCodeSaveKey(String code) {
        return SecurityManager.getConfig().getTokenName() + ":oauth2:code:" + code;
    }

    public String splicingCodeIndexKey(String clientId, Object loginId) {
        return SecurityManager.getConfig().getTokenName() + ":oauth2:code-index:" + clientId + ":" + loginId;
    }

    public String splicingAccessTokenSaveKey(String accessToken) {
        return SecurityManager.getConfig().getTokenName() + ":oauth2:access-token:" + accessToken;
    }

    public String splicingSpecialTokenSaveKey(String accessToken) {
        return SecurityManager.getConfig().getTokenName() + ":oauth2:special-token:" + accessToken;
    }

    public String splicingPastAccessTokenSaveKey(String accessToken) {
        return SecurityManager.getConfig().getTokenName() + ":oauth2:past:access-token:" + accessToken;
    }

    public String splicingAccessTokenIndexKey(String clientId, Object loginId) {
        return SecurityManager.getConfig().getTokenName() + ":oauth2:access-token-index:" + clientId + ":" + loginId;
    }

    public String splicingSpecialTokenIndexKey(String clientId, Object loginId) {
        return SecurityManager.getConfig().getTokenName() + ":oauth2:special-token-index:" + clientId + ":" + loginId;
    }

    public String splicingPastAccessTokenIndexKey(String clientId, Object loginId) {
        return SecurityManager.getConfig().getTokenName() + ":oauth2:past:access-token-index:" + clientId + ":" + loginId;
    }

    public String splicingRefreshTokenSaveKey(String refreshToken) {
        return SecurityManager.getConfig().getTokenName() + ":oauth2:refresh-token:" + refreshToken;
    }

    public String splicingRefreshTokenIndexKey(String clientId, Object loginId) {
        return SecurityManager.getConfig().getTokenName() + ":oauth2:refresh-token-index:" + clientId + ":" + loginId;
    }

    public String splicingClientTokenSaveKey(String clientToken) {
        return SecurityManager.getConfig().getTokenName() + ":oauth2:client-token:" + clientToken;
    }

    public String splicingClientTokenIndexKey(String clientId) {
        return SecurityManager.getConfig().getTokenName() + ":oauth2:client-token-index:" + clientId;
    }

    public String splicingPastTokenIndexKey(String clientId) {
        return SecurityManager.getConfig().getTokenName() + ":oauth2:past-token-index:" + clientId;
    }

    public String splicingGrantScopeKey(String clientId, Object loginId) {
        return SecurityManager.getConfig().getTokenName() + ":oauth2:grant-scope:" + clientId + ":" + loginId;
    }
}

