/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.hussar.support.security.plugin.oauth2.logic;

import com.jxdinfo.hussar.platform.core.base.apiresult.ApiResponse;
import com.jxdinfo.hussar.platform.core.base.apiresult.ResultCode;
import com.jxdinfo.hussar.platform.core.support.service.dto.LoginUser;
import com.jxdinfo.hussar.platform.core.support.service.dto.UserDetails;
import com.jxdinfo.hussar.platform.core.utils.HussarUtils;
import com.jxdinfo.hussar.support.security.core.context.SecurityHolder;
import com.jxdinfo.hussar.support.security.core.context.model.SecurityRequest;
import com.jxdinfo.hussar.support.security.core.context.model.SecurityResponse;
import com.jxdinfo.hussar.support.security.core.stp.SecurityTokenInfo;
import com.jxdinfo.hussar.support.security.core.stp.SecurityUtil;
import com.jxdinfo.hussar.support.security.core.util.SecurityFoxUtil;
import com.jxdinfo.hussar.support.security.plugin.oauth2.SecurityOAuth2Manager;
import com.jxdinfo.hussar.support.security.plugin.oauth2.config.SecurityOAuth2Config;
import com.jxdinfo.hussar.support.security.plugin.oauth2.exception.SecurityOAuth2Exception;
import com.jxdinfo.hussar.support.security.plugin.oauth2.listener.HussarSecurityOauthListener;
import com.jxdinfo.hussar.support.security.plugin.oauth2.logic.SecurityOAuth2Constants;
import com.jxdinfo.hussar.support.security.plugin.oauth2.logic.SecurityOAuth2Util;
import com.jxdinfo.hussar.support.security.plugin.oauth2.logic.service.SecurityOAuth2HandleService;
import com.jxdinfo.hussar.support.security.plugin.oauth2.model.AccessTokenModel;
import com.jxdinfo.hussar.support.security.plugin.oauth2.model.ClientTokenModel;
import com.jxdinfo.hussar.support.security.plugin.oauth2.model.CodeModel;
import com.jxdinfo.hussar.support.security.plugin.oauth2.model.RequestAuthModel;
import com.jxdinfo.hussar.support.security.plugin.oauth2.model.SecurityClientModel;
import java.util.List;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;

public class DefaultSecurityOAuth2HandleService
implements SecurityOAuth2HandleService {
    private static Logger LOGGER = LoggerFactory.getLogger(DefaultSecurityOAuth2HandleService.class);
    @Autowired
    private HussarSecurityOauthListener hussarSecurityOauthListener;

    @Override
    public Object oauth2Request() {
        SecurityRequest req = SecurityHolder.getRequest();
        SecurityResponse res = SecurityHolder.getResponse();
        SecurityOAuth2Config cfg = SecurityOAuth2Manager.getConfig();
        if (req.isPath(SecurityOAuth2Constants.Api.authorize) && req.isParam(SecurityOAuth2Constants.Param.response_type, SecurityOAuth2Constants.ResponseType.code) && cfg.isCode.booleanValue()) {
            return this.authorize(req, res, cfg);
        }
        if (req.isPath(SecurityOAuth2Constants.Api.token) && req.isParam(SecurityOAuth2Constants.Param.grant_type, SecurityOAuth2Constants.GrantType.authorization_code)) {
            return this.token(req, res, cfg);
        }
        if (req.isPath(SecurityOAuth2Constants.Api.refresh) && req.isParam(SecurityOAuth2Constants.Param.grant_type, SecurityOAuth2Constants.GrantType.refresh_token)) {
            return this.refreshToken(req);
        }
        if (req.isPath(SecurityOAuth2Constants.Api.revoke)) {
            return this.revokeToken(req);
        }
        if (req.isPath(SecurityOAuth2Constants.Api.doLogin)) {
            return this.doLogin(req, res, cfg);
        }
        if (req.isPath(SecurityOAuth2Constants.Api.doConfirm)) {
            return this.doConfirm(req);
        }
        if (req.isPath(SecurityOAuth2Constants.Api.authorize) && req.isParam(SecurityOAuth2Constants.Param.response_type, SecurityOAuth2Constants.ResponseType.token) && cfg.isImplicit.booleanValue()) {
            return this.authorize(req, res, cfg);
        }
        if (req.isPath(SecurityOAuth2Constants.Api.token) && req.isParam(SecurityOAuth2Constants.Param.grant_type, SecurityOAuth2Constants.GrantType.password) && cfg.isPassword.booleanValue()) {
            return this.password(req, res, cfg);
        }
        if (req.isPath(SecurityOAuth2Constants.Api.client_token) && req.isParam(SecurityOAuth2Constants.Param.grant_type, SecurityOAuth2Constants.GrantType.client_credentials) && cfg.isClient.booleanValue()) {
            return this.clientToken(req, res, cfg);
        }
        SecurityOAuth2Exception.throwBy(true, "\u8ba4\u8bc1\u65b9\u6cd5\u4e2d\u65e0{\"msg\": \"not handle\"}");
        return "{\"msg\": \"not handle\"}";
    }

    @Override
    public Object authorize(SecurityRequest req, SecurityResponse res, SecurityOAuth2Config cfg) {
        if (!SecurityUtil.isLogin()) {
            return cfg.notLoginView.get();
        }
        RequestAuthModel ra = SecurityOAuth2Util.generateRequestAuth(req, SecurityUtil.getLoginId());
        SecurityOAuth2Util.checkRightUrl(ra.clientId, ra.redirectUri);
        SecurityOAuth2Util.checkContract(ra.clientId, ra.scope);
        boolean isGrant = SecurityOAuth2Util.isGrant(ra.loginId, ra.clientId, ra.scope);
        if (!isGrant) {
            return cfg.confirmView.apply(ra.clientId, ra.scope);
        }
        if (SecurityOAuth2Constants.ResponseType.code.equals(ra.responseType)) {
            CodeModel codeModel = SecurityOAuth2Util.generateCode(ra);
            String redirectUri = SecurityOAuth2Util.buildRedirectUri(ra.redirectUri, codeModel.code, ra.state);
            return res.redirect(redirectUri);
        }
        if (SecurityOAuth2Constants.ResponseType.token.equals(ra.responseType)) {
            SecurityTokenInfo tokenInfo = SecurityUtil.getTokenInfo();
            AccessTokenModel at = SecurityOAuth2Util.generateAccessToken(ra, false, tokenInfo.getTokenValue(), tokenInfo.getLoginType());
            String redirectUri = SecurityOAuth2Util.buildImplicitRedirectUri(ra.redirectUri, at.accessToken, ra.state);
            return res.redirect(redirectUri);
        }
        throw new SecurityOAuth2Exception("\u65e0\u6548response_type: " + ra.responseType);
    }

    @Override
    public Object token(SecurityRequest req, SecurityResponse res, SecurityOAuth2Config cfg) {
        String code = req.getParamNotNull(SecurityOAuth2Constants.Param.code);
        String clientId = req.getHeaderNotNull(SecurityOAuth2Constants.Param.client_id);
        String clientSecret = req.getHeaderNotNull(SecurityOAuth2Constants.Param.client_secret);
        String redirectUri = req.getParam(SecurityOAuth2Constants.Param.redirect_uri);
        SecurityOAuth2Util.checkGainTokenParam(code, clientId, clientSecret, redirectUri);
        AccessTokenModel token = SecurityOAuth2Util.generateAccessToken(code);
        return ApiResponse.success(token.toLineMap());
    }

    @Override
    public Object doLogin(SecurityRequest req, SecurityResponse res, SecurityOAuth2Config cfg) {
        String username = req.getParamNotNull(SecurityOAuth2Constants.Param.name);
        String password = req.getParamNotNull(SecurityOAuth2Constants.Param.pwd);
        String tenantCode = req.getParam(SecurityOAuth2Constants.Param.tenant_code);
        String clientId = req.getHeaderNotNull(SecurityOAuth2Constants.Param.client_id);
        LoginUser loginUser = new LoginUser();
        loginUser.setUserName(username);
        loginUser.setPassword(password);
        loginUser.setTenantCode(tenantCode);
        loginUser.setClientId(clientId);
        return cfg.doLoginHandle.apply(loginUser);
    }

    @Override
    public Object doConfirm(SecurityRequest req) {
        String clientId = req.getHeaderNotNull(SecurityOAuth2Constants.Param.client_id);
        String scope = req.getParamNotNull(SecurityOAuth2Constants.Param.scope);
        Object loginId = SecurityUtil.getLoginId();
        SecurityOAuth2Util.saveGrantScope(clientId, loginId, scope);
        return ApiResponse.success((String)"\u64cd\u4f5c\u6210\u529f");
    }

    @Override
    public Object password(SecurityRequest req, SecurityResponse res, SecurityOAuth2Config cfg) {
        String username = req.getParamNotNull(SecurityOAuth2Constants.Param.username);
        String password = req.getParamNotNull(SecurityOAuth2Constants.Param.password);
        String clientId = req.getHeaderNotNull(SecurityOAuth2Constants.Param.client_id);
        String tenantCode = req.getParam(SecurityOAuth2Constants.Param.tenant_code);
        SecurityClientModel securityClientModel = SecurityOAuth2Util.checkClientModel(clientId);
        boolean isGrantype = SecurityOAuth2Util.checkClientGrantype(SecurityOAuth2Constants.GrantType.password, securityClientModel);
        SecurityOAuth2Exception.throwBy(!isGrantype, "\u8ba4\u8bc1\u5931\u8d25\uff0c\u6b64clientId=" + clientId + ",\u4e0d\u652f\u6301\u5bc6\u7801\u6a21\u5f0f\u767b\u9646");
        SecurityHolder.getStorage().set(SecurityUtil.securityLogic.splicingKeyJustCreatedSave(), (Object)"no-token");
        LoginUser loginUser = new LoginUser();
        loginUser.setPassword(password).setUserName(username).setTenantCode(tenantCode).setClientId(clientId);
        List excludeList = SecurityFoxUtil.toList((String[])new String[]{SecurityOAuth2Constants.Param.username, SecurityOAuth2Constants.Param.password, SecurityOAuth2Constants.Param.client_id, SecurityOAuth2Constants.Param.tenant_code});
        Map paramsMapExcludeParam = SecurityFoxUtil.getParamsMapExcludeParam((List)excludeList, (Map)req.getParamsMap());
        loginUser.setExtendMap(paramsMapExcludeParam);
        ApiResponse retObj = (ApiResponse)cfg.doLoginHandle.apply(loginUser);
        if (HussarUtils.isEmpty((Object)retObj) || retObj.getCode() != ResultCode.SUCCESS.getCode() && HussarUtils.isEmpty((Object)retObj.getData())) {
            SecurityOAuth2Exception.throwBy(true, "\u8ba4\u8bc1\u5931\u8d25\uff01");
        }
        UserDetails data = (UserDetails)retObj.getData();
        if (!SecurityUtil.isLogin()) {
            return retObj;
        }
        RequestAuthModel ra = new RequestAuthModel();
        ra.clientId = clientId;
        ra.loginId = data.getLoginId();
        ra.scope = req.getParam(SecurityOAuth2Constants.Param.scope, "");
        ra.expiresTime = securityClientModel.getAccessTokenValidTime();
        ra.refreshExpiresTime = securityClientModel.getRefreshTokenValidTime();
        AccessTokenModel at = SecurityOAuth2Util.generateAccessToken(ra, true, data.getTokenValue(), data.getLoginType());
        UserDetails userDetails = SecurityUtil.getTokenSession().getUserDetails();
        userDetails.setAccessToken(at.accessToken);
        SecurityUtil.getTokenSession().addUserDetailToTokenSession(userDetails, data.getTokenValue());
        this.hussarSecurityOauthListener.loginSuccess(userDetails);
        return ApiResponse.success(at.toLineMap());
    }

    @Override
    public Object clientToken(SecurityRequest req, SecurityResponse res, SecurityOAuth2Config cfg) {
        String clientId = req.getHeaderNotNull(SecurityOAuth2Constants.Param.client_id);
        String clientSecret = req.getHeaderNotNull(SecurityOAuth2Constants.Param.client_secret);
        String scope = req.getParam(SecurityOAuth2Constants.Param.scope);
        SecurityClientModel securityClientModel = SecurityOAuth2Util.checkClientSecret(clientId, clientSecret);
        boolean isGrantype = SecurityOAuth2Util.checkClientGrantype(SecurityOAuth2Constants.GrantType.client_credentials, securityClientModel);
        SecurityOAuth2Exception.throwBy(!isGrantype, "\u8ba4\u8bc1\u5931\u8d25\uff0c\u6b64clientId=" + clientId + ",\u4e0d\u652f\u6301\u5ba2\u6237\u7aef\u6a21\u5f0f");
        SecurityOAuth2Util.checkClientScope(scope, securityClientModel);
        ClientTokenModel ct = SecurityOAuth2Util.generateClientToken(securityClientModel, scope);
        return ApiResponse.success(ct.toLineMap());
    }

    @Override
    public Object refreshToken(SecurityRequest req) {
        String clientId = req.getHeaderNotNull(SecurityOAuth2Constants.Param.client_id);
        String clientSecret = req.getHeader(SecurityOAuth2Constants.Param.client_secret);
        String refreshToken = req.getParamNotNull(SecurityOAuth2Constants.Param.refresh_token);
        SecurityOAuth2Config oAuth2Config = SecurityOAuth2Manager.getConfig();
        String accessToken = req.getHeaderNotNull(oAuth2Config.getHeaderTokenKey());
        SecurityOAuth2Exception.throwBy(HussarUtils.isEmpty((Object)accessToken), "accesstoken \u4e3a\u7a7a\uff0c\u5237\u65b0token\u5931\u8d25");
        AccessTokenModel accessTokenModel = SecurityOAuth2Util.getAccessToken(accessToken);
        SecurityOAuth2Exception.throwBy(HussarUtils.isEmpty((Object)accessTokenModel), "\u5237\u65b0token\u5931\u8d25,accesstoken=[" + accessToken + "],\u5df2\u7ecf\u8fc7\u671f\uff0c\u5efa\u8bae\u5728token\u8fc7\u671f\u4e4b\u524d\u8fdb\u884c\u5237\u65b0token");
        SecurityOAuth2Exception.throwBy(HussarUtils.isEmpty((Object)accessTokenModel.refreshToken) || accessTokenModel.getRefreshExpiresIn() <= 0L, "accesstoken \u4e3a\u7a7a\u6216\u8005\u5237\u65b0token\u5df2\u7ecf\u8fc7\u671f\uff0c\u5237\u65b0token\u5931\u8d25");
        SecurityOAuth2Exception.throwBy(!HussarUtils.equals((Object)accessTokenModel.refreshToken, (Object)refreshToken), "\u4f20\u9012refreshtoken\u6709\u8bef\uff0c\u65e0\u6cd5\u5237\u65b0token");
        if (oAuth2Config.getRefreshTokenThreshold() > 0L && accessTokenModel.getExpiresIn() > oAuth2Config.getRefreshTokenThreshold()) {
            return ApiResponse.success(accessTokenModel.toLineMap());
        }
        SecurityOAuth2Util.checkRefreshTokenParam(clientId, clientSecret, refreshToken);
        Map<String, Object> data = SecurityOAuth2Util.refreshAccessToken(refreshToken).toLineMap();
        return ApiResponse.success(data);
    }

    @Override
    public Object revokeToken(SecurityRequest req) {
        String clientId = req.getHeaderNotNull(SecurityOAuth2Constants.Param.client_id);
        SecurityOAuth2Config securityOAuth2Config = SecurityOAuth2Manager.getConfig();
        String accessToken = req.getHeaderNotNull(securityOAuth2Config.getHeaderTokenKey());
        AccessTokenModel accessTokenModel = SecurityOAuth2Util.getAccessToken(accessToken);
        SecurityOAuth2Exception.throwBy(HussarUtils.isEmpty((Object)accessTokenModel) || !HussarUtils.equals((Object)accessTokenModel.clientId, (Object)clientId), "\u53c2\u6570\u6709\u8bef\uff0c\u64cd\u4f5c\u5931\u8d25");
        SecurityOAuth2Util.checkClientModel(clientId);
        SecurityOAuth2Util.revokeAccessToken(accessToken);
        return ApiResponse.success((String)"\u64cd\u4f5c\u6210\u529f");
    }
}

