/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.hussar.support.security.plugin.oauth2.model;

import com.jxdinfo.hussar.support.security.plugin.oauth2.SecurityOAuth2Manager;
import java.io.Serializable;
import java.util.Arrays;

public class SecurityClientModel
implements Serializable {
    private static final long serialVersionUID = -6541180061782004705L;
    public String clientId;
    public String clientSecret;
    public String[] contractScope;
    public String allowUrl;
    private long accessTokenValidTime;
    private long refreshTokenValidTime;
    private String publicKey;
    private String privateKey;
    private String[] grantTypes;

    public SecurityClientModel() {
    }

    public SecurityClientModel(String clientId, String clientSecret, String[] contractScope, String allowUrl) {
        this.clientId = clientId;
        this.clientSecret = clientSecret;
        this.contractScope = contractScope;
        this.allowUrl = allowUrl;
    }

    public String getClientId() {
        return this.clientId;
    }

    public SecurityClientModel setClientId(String clientId) {
        this.clientId = clientId;
        return this;
    }

    public String getClientSecret() {
        return this.clientSecret;
    }

    public SecurityClientModel setClientSecret(String clientSecret) {
        this.clientSecret = clientSecret;
        return this;
    }

    public String[] getContractScope() {
        return this.contractScope;
    }

    public SecurityClientModel setContractScope(String[] contractScope) {
        this.contractScope = contractScope;
        return this;
    }

    public String getAllowUrl() {
        return this.allowUrl;
    }

    public SecurityClientModel setAllowUrl(String allowUrl) {
        this.allowUrl = allowUrl;
        return this;
    }

    public long getAccessTokenValidTime() {
        if (this.accessTokenValidTime == 0L) {
            return SecurityOAuth2Manager.getConfig().getAccessTokenTimeout();
        }
        return this.accessTokenValidTime;
    }

    public SecurityClientModel setAccessTokenValidTime(long accessTokenValidTime) {
        this.accessTokenValidTime = accessTokenValidTime;
        return this;
    }

    public long getRefreshTokenValidTime() {
        if (this.refreshTokenValidTime == 0L) {
            return SecurityOAuth2Manager.getConfig().getRefreshTokenTimeout();
        }
        return this.refreshTokenValidTime;
    }

    public SecurityClientModel setRefreshTokenValidTime(long refreshTokenValidTime) {
        this.refreshTokenValidTime = refreshTokenValidTime;
        return this;
    }

    public String getPublicKey() {
        return this.publicKey;
    }

    public SecurityClientModel setPublicKey(String publicKey) {
        this.publicKey = publicKey;
        return this;
    }

    public String getPrivateKey() {
        return this.privateKey;
    }

    public SecurityClientModel setPrivateKey(String privateKey) {
        this.privateKey = privateKey;
        return this;
    }

    public String[] getGrantTypes() {
        return this.grantTypes;
    }

    public SecurityClientModel setGrantTypes(String[] grantTypes) {
        this.grantTypes = grantTypes;
        return this;
    }

    public String toString() {
        return "SaClientModel [clientId=" + this.clientId + ", clientSecret=" + this.clientSecret + ", contractScope=" + Arrays.toString(this.contractScope) + ", allowUrl=" + this.allowUrl + "]";
    }
}

