## 关于当前模块
    本模块为客户端认证使用的sdk,会统一进行调用的封装。
    减少对接我司项目的开发难度。
    后续版本的接口应该与之前版本的接口兼容。
    理论上应该提供java/python/c++等主流语言的代码，此模块仅考虑java调用。

## 服务器针对token的不同模式时的处理方案
### 已发放token,有效期缩短。
    每次请求发放新的token，同时老的token在n秒后自动过期。token获取时告知2小时过期，实际不足2小时，token将不再可用。
    安全性最高，参考微信公众号的token获取。
    示例：
        客户端a获取tokenA, 返回tokenA有效期=2小时。
        客户端b获取tokenB, 则平台返回新的tokenB有效期=2小时, 并且历史发放的tokenA将在5分钟后自动过期。
        tokenA获取时告知2小时过期，但是当客户端触发获取token动作时，tokenA的过期时间锐减到5分钟。
        sdk的缓存为本地缓存，不能感知到过期时间的变化，不能支撑该交互方式。
    因为本sdk包不依赖公共组建，所以需要引入当前sdk的项目自行处理。
    1. 首先保证各个服务器时间一致。
    2. 获取tokenInfo后，将token信息放置到公共缓存中。（redis/db等，同时注意测试环境和正式环境同时调用的问题）
    3. 每次进行获取时，先读取公共缓存，公共缓存不存在，再调用sdk真实发送网络请求进行读取。
    此时：本地缓存将自动失效，因为公共缓存token有效期>=当前缓存时间。
    此时：refreshTokenThreshold配置将不再生效，需要获取到公共缓存时，自行处理阈值信息。

### 服务端设置的过期阈值较小，
    第一次请求后发放新token, 后续发放老的token，老的token有效期逐渐减少。
    在老的token临近过期时（不足120秒），仍然不发放新的token.
    当前系统默认配置：refreshTokenThreshold=120秒，
    token有效期不足120秒，每次请求都将重新获取token，不再通过缓存返回数据。
    如果服务端的token刷新阈值<120秒，请同步调整配置文件中的refreshTokenThreshold信息。
    当前组件库的默认配置为clientCreateNewTokenThreshold=5分钟。
    

    
## 关于jdk版本
    本模块采用jdk1.8版本进行编写，最低jdk运行环境为1.8， 如需要使用更低版本请联系开发人员，或自行开发。

## 关于该sdk的的使用
    通过maven等方式引入jar包。
    项目启动完毕后，调用HussarLoginClientUtils.init方法，传递properties对象。（可选）
    如果只有一个配置信息可以直接调用getToken获取token信息。（调用init，并且只有一项配置）
    如果有多个配置信息，可以直接调用getToken(String),传递客户端id,获取token信息。（调用init）
    如果有多个配置信息，可以直接调用getToken(Properties),传递客户端配置,获取token信息。

## properties配置项说明
    serverUrl: 提供授权服务的服务器地址，只需填写ip+端口
    key： 唯一标识，缺省为客户端id,当不同服务器提供的客户端id重复时使用该标识。
    clientId： 客户端id, 页面：运维管理--> 客户端管理--> 客户端ID
    clientSecret： 客户端密钥, 页面：运维管理--> 客户端管理--> 客户端密钥
    refreshTokenThreshold： token刷新时间，小于多少时间时，再次请求服务器进行认证，缺省2分钟
    connectTimeout: 链接超时时间，缺省5秒
    readTimeout: 客户端请求的超时时间，缺省5秒

## 程序处理出现异常，会统一抛出LoginException
    请注意异常的捕获和处理。

## 关于缓存问题
    本项目使用的为本地的缓存，当项目重启等情况可能导致缓存失效。

## jar包使用示例
```java

import com.jxdinfo.hussar.support.security.plugin.loginclient.config.HussarLoginClientProperties;
import com.jxdinfo.hussar.support.security.plugin.loginclient.util.HussarLoginClientUtils;
public class HussarLoginClientDemo {
    public static void main(String[] args) {
        HussarLoginClientProperties hussarLoginClientProperties = new HussarLoginClientProperties();
        hussarLoginClientProperties.setClientId("xxx");
        hussarLoginClientProperties.setClientSecret("xxx");
        hussarLoginClientProperties.setServerUrl("http://xxxx:8280");
        // 数据初始化方法，推荐程序启动后调用初始化发方法进行数据初始化，方便后续简化调用。
        HussarLoginClientUtils.init(hussarLoginClientProperties);

        // 只传递clientId，调用过init且，该clientId的配置已经传递
        HussarLoginClientUtils.getToken("xxx");
        // 传递完整信息，适用于自定义的配置传递，无需提前调用init方法。
        HussarLoginClientUtils.getToken(hussarLoginClientProperties);

        //-----------以下接口，获取数据内包含过期时间，当需要统一进行过期维护时进行调用--------------------//

        // 只传递clientId，调用过init且，该clientId的配置已经传递
        HussarLoginClientUtils.getTokenInfo("xxx");
        // 传递完整信息，适用于自定义的配置传递，无需提前调用init方法。
        HussarLoginClientUtils.getTokenInfo(hussarLoginClientProperties);

        //-----------以下接口，进行过期token的清理，当服务器token过期未通知客户端，客户端调用失败主动清理--------------------//
        // 清理全部的token,谨慎使用，频繁调用，本地缓存将失效，token每次通过服务器获取，增加服务器及本机压力
        HussarLoginClientUtils.clearToken();
        // 直接传递clientId/key进行清理
        HussarLoginClientUtils.removeToken("xxx","yyy");
        // 传递完整信息，包含clientId/key
        HussarLoginClientUtils.removeToken(hussarLoginClientProperties);


        //-----------以下接口，进行配置项的清理--------------------//
        // 直接传递clientId/key进行清理
        HussarLoginClientUtils.removeProperties("xxx","yyy");
        // 传递完整信息，包含clientId/key
        HussarLoginClientUtils.removeProperties(hussarLoginClientProperties);
    }
}
```

## feign调用示例：

创建统一header填充类,实现RequestInterceptor
```java

import com.jxdinfo.hussar.support.security.plugin.loginclient.config.HussarLoginClientConstants;
import com.jxdinfo.hussar.support.security.plugin.loginclient.util.HussarLoginClientUtils;
import feign.RequestInterceptor;
import feign.RequestTemplate;

import java.util.Collection;
import java.util.Map;


/**
 * 增加统一的请求头信息
 * **该类不要被spring管理**
 * 否则每个FeignClient都会执行，存在令牌泄露风险。
 **/
public class HussarLoginConfig implements RequestInterceptor {

    @Override
    public void apply(RequestTemplate requestTemplate) {
        // 获取所有请求头
        Map<String, Collection<String>> headers = requestTemplate.headers();
        String clientId = null;
        // 从当前请求的header中查找clientId。
        Collection<String> clientIdHeaders = headers.get(HussarLoginClientConstants.CLIENT_ID);
        if (clientIdHeaders != null && !clientIdHeaders.isEmpty()) {
            clientId = clientIdHeaders.iterator().next();
        }
        if (clientId == null || clientId.trim().length() == 0) {
            // 根据自定义的规则填充clientId信息。
            clientId="";
        }
        // 调用工具类获取token信息。需在项目启动后调用HussarLoginClientUtils.init(properties);方法
        LoginClientTokenInfoDTO tokenInfo = HussarLoginClientUtils.getTokenInfo(clientId);
        // 设置请求的clientId和authorization信息。
        requestTemplate.header(HussarLoginClientConstants.CLIENT_ID, tokenInfo.getClientId());
        requestTemplate.header(HussarLoginClientConstants.AUTHORIZATION, tokenInfo.getToken());
    }
}
```
feign接口指定configuration,
接口方法显示声明header信息（优先级最高）
其他自定义方式传递clientId(可选，例如线程缓存，attribute等)
不传递clientId(当前环境有且只有一套配置，默认取该配置)
```java
import com.jxdinfo.hussar.support.security.plugin.loginclient.config.HussarLoginClientConstants;
import org.springframework.cloud.openfeign.FeignClient;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestHeader;

/**
 * 调用hussar平台的feign接口, 设置configuration指向统一的token填充类。
 */
@FeignClient(name="hussarRequestService",url = "http://localhost:9502",configuration = HussarLoginConfig.class)
public interface HussarRequestService {

    /**
     * 期望在接口调用时，显示传递header信息，
     * 如果
     * @param keywords
     * @param clientId
     * @return
     */
    @GetMapping("/this_is_request_url?keywords={keywords}")
    String demoRequest(@PathVariable("keywords") String keywords, @RequestHeader(HussarLoginClientConstants.CLIENT_ID) String clientId);
    @GetMapping("/this_is_request_url2?keywords={keywords}")
    String demoRequest2(@PathVariable("keywords") String keywords);
}
```
项目初始化完毕后，根据配置文件执行
HussarLoginClientUtils.init(properties);方法

## 查看当前客户端拥有的资源信息
    SELECT Resource_name,path FROM SYS_CLIENT_PERMISSION
    left join SYS_RESOURCES on SYS_RESOURCES.RESOURCE_ID = SYS_CLIENT_PERMISSION.PERMISSION_ID
    where client_id = 'xxx'