/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.hussar.support.security.plugin.loginclient.util;

import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.jxdinfo.hussar.support.security.plugin.loginclient.config.HussarLoginClientConstants;
import com.jxdinfo.hussar.support.security.plugin.loginclient.config.HussarLoginClientProperties;
import com.jxdinfo.hussar.support.security.plugin.loginclient.dto.LoginClientDataDTO;
import com.jxdinfo.hussar.support.security.plugin.loginclient.dto.LoginClientResponseDTO;
import com.jxdinfo.hussar.support.security.plugin.loginclient.dto.LoginClientTokenInfoDTO;
import com.jxdinfo.hussar.support.security.plugin.loginclient.exception.LoginException;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.net.HttpURLConnection;
import java.net.MalformedURLException;
import java.net.ProtocolException;
import java.net.URL;
import java.util.Arrays;
import java.util.Map;
import java.util.Objects;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.TimeUnit;
import java.util.stream.Collectors;

public class HussarLoginClientUtils {
    private static final ObjectMapper JSON_INSTANCE = new ObjectMapper();
    private static final Map<String, HussarLoginClientProperties> ID_2_PROPERTIES = new ConcurrentHashMap<String, HussarLoginClientProperties>();
    private static final Map<String, LoginClientTokenInfoDTO> ID_2_TOKEN = new ConcurrentHashMap<String, LoginClientTokenInfoDTO>();

    public static void init(HussarLoginClientProperties properties) {
        if (properties == null || properties.getKey() == null || properties.getKey().trim().length() <= 0) {
            throw LoginException.build(LoginException.LoginExceptionEnum.NO_CLIENT_ID);
        }
        ID_2_PROPERTIES.put(properties.getKey(), properties);
    }

    public static String getToken(String clientId) throws LoginException {
        return HussarLoginClientUtils.getTokenInfo(clientId).getToken();
    }

    public static LoginClientTokenInfoDTO getTokenInfo(String clientId) throws LoginException {
        if (clientId == null || clientId.trim().length() == 0) {
            if (ID_2_PROPERTIES.size() == 1) {
                return HussarLoginClientUtils.getTokenInfo(ID_2_PROPERTIES.values().stream().findFirst().get());
            }
            throw LoginException.build(LoginException.LoginExceptionEnum.NO_CLIENT_ID);
        }
        return HussarLoginClientUtils.getTokenInfo(ID_2_PROPERTIES.get(clientId));
    }

    public static String getToken(HussarLoginClientProperties properties) throws LoginException {
        return HussarLoginClientUtils.getTokenInfo(properties).getToken();
    }

    public static LoginClientTokenInfoDTO getTokenInfo(HussarLoginClientProperties properties) throws LoginException {
        HussarLoginClientUtils.checkProperties(properties);
        String key = properties.getKey();
        LoginClientTokenInfoDTO cacheTokenInfo = ID_2_TOKEN.get(key);
        if (cacheTokenInfo != null && cacheTokenInfo.getExpiresIn() > properties.getRefreshTokenThreshold()) {
            return cacheTokenInfo;
        }
        try {
            String result = HussarLoginClientUtils.doClientLogin(properties);
            LoginClientResponseDTO loginClientResponseDTO = (LoginClientResponseDTO)JSON_INSTANCE.readValue(result, LoginClientResponseDTO.class);
            loginClientResponseDTO.checkParam();
            LoginClientDataDTO data = loginClientResponseDTO.getData();
            LoginClientTokenInfoDTO loginClientTokenInfoDTO = data.getLoginClientTokenInfoDTO();
            long expireTime = System.currentTimeMillis() + TimeUnit.SECONDS.toMillis(data.getExpiresIn());
            loginClientTokenInfoDTO.setExpireTime(expireTime -= Math.max(HussarLoginClientConstants.EXPIRE_TIME_OFF_SET, (long)(properties.getConnectTimeout() + properties.getReadTimeout())));
            String token = loginClientTokenInfoDTO.getToken();
            if (token != null && token.trim().length() > 0) {
                ID_2_TOKEN.put(key, loginClientTokenInfoDTO);
            }
            return loginClientTokenInfoDTO;
        }
        catch (JsonProcessingException e) {
            throw new LoginException(LoginException.LoginExceptionEnum.JSON_PROCESSING_ERROR, (Throwable)e);
        }
        catch (MalformedURLException e) {
            throw new LoginException(LoginException.LoginExceptionEnum.HTTP_MALFORMED_URL_EXCEPTION, (Throwable)e);
        }
        catch (IOException e) {
            throw new LoginException(LoginException.LoginExceptionEnum.HTTP_IO_EXCEPTION, (Throwable)e);
        }
    }

    private static void checkProperties(HussarLoginClientProperties properties) {
        if (properties == null) {
            throw LoginException.build(LoginException.LoginExceptionEnum.NO_CONFIG);
        }
        String clientId = properties.getClientId();
        if (clientId == null || clientId.trim().length() == 0) {
            throw LoginException.build(LoginException.LoginExceptionEnum.NO_CLIENT_ID);
        }
        String clientSecret = properties.getClientSecret();
        if (clientSecret == null || clientSecret.trim().length() == 0) {
            throw LoginException.build(LoginException.LoginExceptionEnum.NO_SECRET);
        }
        String serverUrl = properties.getServerUrl();
        if (serverUrl == null || serverUrl.trim().length() == 0) {
            throw LoginException.build(LoginException.LoginExceptionEnum.NO_SERVER_URL);
        }
    }

    private static String doClientLogin(HussarLoginClientProperties properties) throws IOException, ProtocolException, MalformedURLException {
        URL url = new URL(properties.getServerUrl() + "/oauth2/client_token?grant_type=client_credentials");
        HttpURLConnection connection = (HttpURLConnection)url.openConnection();
        connection.setRequestMethod("GET");
        connection.setRequestProperty("client-id", properties.getClientId());
        connection.setRequestProperty("client-secret", properties.getClientSecret());
        connection.setConnectTimeout(properties.getConnectTimeout());
        connection.setReadTimeout(properties.getReadTimeout());
        StringBuilder response = new StringBuilder();
        int responseCode = connection.getResponseCode();
        if (responseCode != 200) {
            throw LoginException.build(LoginException.LoginExceptionEnum.HTTP_STATUS_NOT_OK_EXCEPTION);
        }
        try (InputStream inputStream = connection.getInputStream();
             InputStreamReader inputStreamReader = new InputStreamReader(inputStream);
             BufferedReader bufferedReader = new BufferedReader(inputStreamReader);){
            String inputLine;
            while ((inputLine = bufferedReader.readLine()) != null) {
                response.append(inputLine);
            }
        }
        catch (IOException e) {
            throw new LoginException(LoginException.LoginExceptionEnum.HTTP_IO_EXCEPTION, (Throwable)e);
        }
        connection.disconnect();
        return response.toString();
    }

    public static boolean removeToken(HussarLoginClientProperties properties) {
        return HussarLoginClientUtils.removeToken(properties.getKey(), properties.getClientId());
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static boolean removeToken(String ... keys) {
        if (keys == null) return false;
        if (Arrays.stream(keys).filter(Objects::nonNull).map(ID_2_TOKEN::remove).filter(Objects::nonNull).collect(Collectors.toSet()).size() <= 0) return false;
        return true;
    }

    public static void clearToken() {
        ID_2_TOKEN.clear();
    }

    public static boolean removeProperties(HussarLoginClientProperties properties) {
        return HussarLoginClientUtils.removeProperties(properties.getKey(), properties.getClientId());
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static boolean removeProperties(String ... keys) {
        if (keys == null) return false;
        if (Arrays.stream(keys).filter(Objects::nonNull).map(ID_2_PROPERTIES::remove).filter(Objects::nonNull).collect(Collectors.toSet()).size() <= 0) return false;
        return true;
    }
}

