/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.hussar.support.security.plugin.loginclient.dto;

import com.jxdinfo.hussar.support.security.plugin.loginclient.dto.LoginClientDataDTO;
import com.jxdinfo.hussar.support.security.plugin.loginclient.exception.LoginException;

public class LoginClientResponseDTO {
    private Integer code;
    private String msg;
    private Boolean success;
    private LoginClientDataDTO data;

    public Integer getCode() {
        return this.code;
    }

    public void setCode(Integer code) {
        this.code = code;
    }

    public String getMsg() {
        return this.msg;
    }

    public void setMsg(String msg) {
        this.msg = msg;
    }

    public Boolean getSuccess() {
        return this.success;
    }

    public void setSuccess(Boolean success) {
        this.success = success;
    }

    public LoginClientDataDTO getData() {
        return this.data;
    }

    public void setData(LoginClientDataDTO data) {
        this.data = data;
    }

    public String toString() {
        return "LoginClientResponseDTO{code=" + this.code + ", msg='" + this.msg + '\'' + ", success=" + this.success + ", data=" + this.data + '}';
    }

    public void checkParam() {
        if (this.getSuccess() == null || !this.getSuccess().booleanValue()) {
            throw LoginException.build(LoginException.LoginExceptionEnum.HTTP_RESULT_SUCCESS_ERROR);
        }
        LoginClientDataDTO data = this.getData();
        if (data == null) {
            throw LoginException.build(LoginException.LoginExceptionEnum.HTTP_RESULT_DATA_ERROR);
        }
        if (data.getClientToken() == null || data.getClientToken().trim().length() == 0) {
            throw LoginException.build(LoginException.LoginExceptionEnum.HTTP_RESULT_DATA_TOKEN_ERROR);
        }
        Long expiresIn = data.getExpiresIn();
        if (expiresIn == null || expiresIn <= 0L) {
            throw LoginException.build(LoginException.LoginExceptionEnum.HTTP_RESULT_DATA_EXPIRES_ERROR);
        }
    }
}

