/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.hussar.support.security.plugin.dao.cache.config;

import com.jxdinfo.hussar.support.security.core.context.SecurityTokenContext;
import com.jxdinfo.hussar.support.security.core.tokenservice.SecurityTokenDao;
import com.jxdinfo.hussar.support.security.plugin.dao.cache.SecurityTokenDaoCacheImpl;
import com.jxdinfo.hussar.support.security.plugin.dao.cache.SecurityTokenDaoCacheProxy;
import com.jxdinfo.hussar.support.security.plugin.dao.cache.properties.SecurityCacheProperties;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.boot.context.properties.EnableConfigurationProperties;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;

@Configuration
@EnableConfigurationProperties(value={SecurityCacheProperties.class})
@ConditionalOnProperty(prefix="hussar.security", name={"enable"}, havingValue="true", matchIfMissing=true)
public class SecurityCacheDaoConfiguration {
    private static final Logger logger = LoggerFactory.getLogger(SecurityCacheDaoConfiguration.class);
    private final SecurityCacheProperties securityCacheProperties;

    public SecurityCacheDaoConfiguration(SecurityCacheProperties securityCacheProperties) {
        this.securityCacheProperties = securityCacheProperties;
    }

    @Bean
    @ConditionalOnProperty(prefix="hussar.security", value={"dao-prefetch"}, havingValue="true")
    public SecurityTokenDao securityTokenDaoPrefetchProxy(SecurityTokenContext context) {
        logger.info("\u542f\u7528\u8ba4\u8bc1\u7f13\u5b58\u9884\u52a0\u8f7d");
        SecurityTokenDaoCacheImpl cacheDao = new SecurityTokenDaoCacheImpl(this.securityCacheProperties);
        return new SecurityTokenDaoCacheProxy(context, this.securityCacheProperties, cacheDao);
    }

    @Bean
    @ConditionalOnMissingBean(value={SecurityTokenDao.class})
    public SecurityTokenDao securityTokenDaoCacheImpl() {
        logger.info("\u7981\u7528\u8ba4\u8bc1\u7f13\u5b58\u9884\u52a0\u8f7d");
        return new SecurityTokenDaoCacheImpl(this.securityCacheProperties);
    }
}

