/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.hussar.support.security.plugin.dao.cache;

import com.fasterxml.jackson.databind.DeserializationFeature;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import com.jxdinfo.hussar.platform.core.utils.HussarUtils;
import com.jxdinfo.hussar.support.security.core.tokenservice.SecurityTokenDao;
import com.jxdinfo.hussar.support.security.core.util.SecurityFoxUtil;
import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.TimeUnit;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.dao.DataAccessException;
import org.springframework.data.redis.connection.RedisConnectionFactory;
import org.springframework.data.redis.core.RedisOperations;
import org.springframework.data.redis.core.RedisTemplate;
import org.springframework.data.redis.core.SessionCallback;
import org.springframework.data.redis.core.StringRedisTemplate;
import org.springframework.data.redis.serializer.GenericJackson2JsonRedisSerializer;
import org.springframework.data.redis.serializer.RedisSerializer;
import org.springframework.data.redis.serializer.StringRedisSerializer;

public class SecurityTokenDaoRedisJackson
implements SecurityTokenDao {
    public ObjectMapper objectMapper;
    public StringRedisTemplate stringRedisTemplate;
    public RedisTemplate<String, Object> objectRedisTemplate;
    public boolean isInit;

    @Autowired
    public void init(RedisConnectionFactory connectionFactory) {
        StringRedisSerializer keySerializer = new StringRedisSerializer();
        GenericJackson2JsonRedisSerializer valueSerializer = new GenericJackson2JsonRedisSerializer();
        try {
            Field field = GenericJackson2JsonRedisSerializer.class.getDeclaredField("mapper");
            field.setAccessible(true);
            ObjectMapper objectMapper = (ObjectMapper)field.get(valueSerializer);
            objectMapper.configure(DeserializationFeature.FAIL_ON_UNKNOWN_PROPERTIES, false);
            this.objectMapper = objectMapper;
        }
        catch (Exception e) {
            System.err.println(e.getMessage());
        }
        StringRedisTemplate stringTemplate = new StringRedisTemplate();
        stringTemplate.setConnectionFactory(connectionFactory);
        stringTemplate.afterPropertiesSet();
        RedisTemplate template = new RedisTemplate();
        template.setConnectionFactory(connectionFactory);
        template.setKeySerializer((RedisSerializer)keySerializer);
        template.setHashKeySerializer((RedisSerializer)keySerializer);
        template.setValueSerializer((RedisSerializer)valueSerializer);
        template.setHashValueSerializer((RedisSerializer)valueSerializer);
        template.afterPropertiesSet();
        if (!this.isInit) {
            this.stringRedisTemplate = stringTemplate;
            this.objectRedisTemplate = template;
            this.isInit = true;
        }
    }

    public String get(String key) {
        return (String)this.stringRedisTemplate.opsForValue().get((Object)key);
    }

    public void set(String key, String value, long timeout) {
        if (timeout == 0L || timeout <= -2L) {
            return;
        }
        if (timeout == -1L) {
            this.stringRedisTemplate.opsForValue().set((Object)key, (Object)value);
        } else {
            this.stringRedisTemplate.opsForValue().set((Object)key, (Object)value, timeout, TimeUnit.SECONDS);
        }
    }

    public void update(String key, String value) {
        long expire = this.getTimeout(key);
        if (expire == -2L) {
            return;
        }
        this.set(key, value, expire);
    }

    public void delete(String key) {
        this.stringRedisTemplate.delete((Object)key);
    }

    public long getTimeout(String key) {
        return this.stringRedisTemplate.getExpire((Object)key);
    }

    public void updateTimeout(String key, long timeout) {
        if (timeout == -1L) {
            long expire = this.getTimeout(key);
            if (expire != -1L) {
                this.set(key, this.get(key), timeout);
            }
            return;
        }
        this.stringRedisTemplate.expire((Object)key, timeout, TimeUnit.SECONDS);
    }

    public <T> T getObject(String key) {
        return (T)this.objectRedisTemplate.opsForValue().get((Object)key);
    }

    public void setObject(String key, Object object, long timeout) {
        if (timeout == 0L || timeout <= -2L) {
            return;
        }
        if (timeout == -1L) {
            this.objectRedisTemplate.opsForValue().set((Object)key, object);
        } else {
            this.objectRedisTemplate.opsForValue().set((Object)key, object, timeout, TimeUnit.SECONDS);
        }
    }

    public void updateObject(String key, Object object) {
        long expire = this.getObjectTimeout(key);
        if (expire == -2L) {
            return;
        }
        this.setObject(key, object, expire);
    }

    public void deleteObject(String key) {
        this.objectRedisTemplate.delete((Object)key);
    }

    public long getObjectTimeout(String key) {
        return this.objectRedisTemplate.getExpire((Object)key);
    }

    public void updateObjectTimeout(String key, long timeout) {
        if (timeout == -1L) {
            long expire = this.getObjectTimeout(key);
            if (expire != -1L) {
                this.setObject(key, this.getObject(key), timeout);
            }
            return;
        }
        this.objectRedisTemplate.expire((Object)key, timeout, TimeUnit.SECONDS);
    }

    public List<String> searchData(String prefix, String keyword, int start, int size) {
        Set keys = this.stringRedisTemplate.keys((Object)(prefix + "*" + keyword + "*"));
        ArrayList list = new ArrayList(keys);
        return SecurityFoxUtil.searchList(list, (int)start, (int)size);
    }

    public void putSet(final String key, final Set<Object> value, final long timeout) {
        this.objectRedisTemplate.execute((SessionCallback)new SessionCallback<Object>(){

            public Object execute(RedisOperations operations) throws DataAccessException {
                operations.multi();
                operations.opsForSet().add((Object)key, value.toArray());
                operations.expire((Object)key, timeout, TimeUnit.SECONDS);
                return operations.exec();
            }
        });
    }

    public void updateSet(final String key, final Set<Object> values) {
        this.objectRedisTemplate.execute((SessionCallback)new SessionCallback<Object>(){

            public Object execute(RedisOperations operations) throws DataAccessException {
                Sets.SetView addValues;
                operations.multi();
                Set originValues = operations.opsForSet().members((Object)key);
                if (HussarUtils.isEmpty((Object)originValues)) {
                    operations.opsForSet().add((Object)key, values.toArray());
                    return operations.exec();
                }
                Sets.SetView delValues = Sets.difference((Set)originValues, (Set)values);
                if (HussarUtils.isNotEmpty((Object)delValues)) {
                    operations.opsForSet().remove((Object)key, delValues.toArray());
                }
                if (HussarUtils.isNotEmpty((Object)(addValues = Sets.difference((Set)values, (Set)originValues)))) {
                    operations.opsForSet().add((Object)key, addValues.toArray());
                }
                return operations.exec();
            }
        });
    }

    public Boolean containsValue(String key, Object value) {
        return Boolean.TRUE.equals(this.objectRedisTemplate.opsForSet().isMember((Object)key, value));
    }

    public Set<Object> getSetObject(String key) {
        return this.objectRedisTemplate.opsForSet().members((Object)key);
    }

    public Map<Object, Boolean> containsValues(String key, List<Object> values) {
        if (HussarUtils.isBlank((CharSequence)key) || HussarUtils.isEmpty(values)) {
            return Maps.newHashMapWithExpectedSize((int)0);
        }
        Map isMemberMap = this.objectRedisTemplate.opsForSet().isMember((Object)key, values.toArray());
        if (HussarUtils.isEmpty((Object)isMemberMap)) {
            return Maps.newHashMapWithExpectedSize((int)0);
        }
        return isMemberMap;
    }

    public void updateKeyTimeout(String key, long timeout) {
        this.objectRedisTemplate.expire((Object)key, timeout, TimeUnit.SECONDS);
    }
}

