/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.hussar.support.security.plugin.dao.cache.prefetch;

import com.jxdinfo.hussar.platform.core.utils.CollectionUtil;
import com.jxdinfo.hussar.support.security.core.prefetch.SecurityDaoPrefetchCache;
import java.util.Collection;
import java.util.List;
import java.util.function.Function;
import org.springframework.data.redis.core.RedisTemplate;
import org.springframework.data.redis.serializer.StringRedisSerializer;

public class SecurityDaoPrefetchTask<T> {
    private final T key;
    private byte[] rawKey;
    private final boolean value;
    private final boolean timeout;

    private SecurityDaoPrefetchTask(T key, boolean value, boolean timeout) {
        this.key = key;
        this.value = value;
        this.timeout = timeout;
    }

    public static <T> SecurityDaoPrefetchTask<T> valueOf(T key) {
        return new SecurityDaoPrefetchTask<T>(key, true, false);
    }

    public static <T> SecurityDaoPrefetchTask<T> valueAndTimeoutOf(T key) {
        return new SecurityDaoPrefetchTask<T>(key, true, true);
    }

    public static void prefetchAll(RedisTemplate<Object, Object> redisTemplate, String tokenName, SecurityDaoPrefetchCache cache, List<SecurityDaoPrefetchTask<String>> tasks) {
        Function<String, byte[]> serializer = key -> SecurityDaoPrefetchTask.rawPrefetchTaskKey(tokenName, key);
        tasks.forEach(task -> task.serialize(serializer));
        List results = redisTemplate.executePipelined(connection -> {
            for (SecurityDaoPrefetchTask task : tasks) {
                if (task.isValue()) {
                    connection.get(task.getRawKey());
                }
                if (!task.isTimeout()) continue;
                connection.ttl(task.getRawKey());
            }
            return null;
        });
        int i = 0;
        for (SecurityDaoPrefetchTask<String> task2 : tasks) {
            long ttl;
            Object rawTtl;
            String key2 = task2.getKey();
            Object value = null;
            Long timeout = null;
            if (task2.isValue()) {
                value = CollectionUtil.get((Collection)results, (int)i++);
            }
            if (task2.isTimeout() && (rawTtl = CollectionUtil.get((Collection)results, (int)i++)) instanceof Number && (ttl = ((Number)rawTtl).longValue()) >= 0L) {
                timeout = ttl;
            }
            if (timeout == null) {
                cache.set(key2, value);
                continue;
            }
            cache.set(key2, value, timeout);
        }
    }

    private static byte[] rawPrefetchTaskKey(String prefix, String key) {
        return StringRedisSerializer.UTF_8.serialize(prefix + "::" + key);
    }

    public void serialize(Function<T, byte[]> serializer) {
        this.setRawKey(serializer.apply(this.key));
    }

    public T getKey() {
        return this.key;
    }

    public byte[] getRawKey() {
        return this.rawKey;
    }

    public void setRawKey(byte[] rawKey) {
        this.rawKey = rawKey;
    }

    public boolean isValue() {
        return this.value;
    }

    public boolean isTimeout() {
        return this.timeout;
    }
}

