/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.hussar.support.security.plugin.dao.cache;

import com.jxdinfo.hussar.support.security.core.context.SecurityTokenContext;
import com.jxdinfo.hussar.support.security.core.prefetch.SecurityDaoPrefetchCache;
import com.jxdinfo.hussar.support.security.core.tokenservice.SecurityTokenDao;
import com.jxdinfo.hussar.support.security.plugin.dao.cache.defer.SecurityDaoDeferredCommand;
import com.jxdinfo.hussar.support.security.plugin.dao.cache.defer.SecurityDaoDeferredQueue;
import com.jxdinfo.hussar.support.security.plugin.dao.cache.properties.SecurityCacheProperties;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;

public class SecurityTokenDaoCacheProxy
implements SecurityTokenDao {
    private final SecurityTokenContext context;
    private final SecurityCacheProperties properties;
    private final SecurityTokenDao delegate;

    public SecurityTokenDaoCacheProxy(SecurityTokenContext context, SecurityCacheProperties properties, SecurityTokenDao delegate) {
        this.context = context;
        this.properties = properties;
        this.delegate = delegate;
    }

    public String get(String key) {
        SecurityDaoPrefetchCache cache = this.getCache();
        if (cache != null && cache.contains(key)) {
            return (String)cache.get(key);
        }
        return this.delegate.get(key);
    }

    public void set(String key, String value, long timeout) {
        boolean hit;
        SecurityDaoPrefetchCache cache = this.getCache();
        boolean bl = hit = cache != null && cache.contains(key);
        if (hit) {
            cache.set(key, (Object)value);
        }
        SecurityDaoDeferredQueue queue = this.getQueue();
        if (hit && queue != null) {
            queue.add(SecurityDaoDeferredCommand.set(this.getRedisKey(key), value, timeout));
        } else {
            this.delegate.set(key, value, timeout);
        }
    }

    public void update(String key, String value) {
        boolean hit;
        SecurityDaoPrefetchCache cache = this.getCache();
        boolean bl = hit = cache != null && cache.contains(key);
        if (hit) {
            cache.set(key, (Object)value);
        }
        SecurityDaoDeferredQueue queue = this.getQueue();
        if (hit && queue != null) {
            queue.add(SecurityDaoDeferredCommand.set(this.getRedisKey(key), value));
        } else {
            this.delegate.update(key, value);
        }
    }

    public void delete(String key) {
        boolean hit;
        SecurityDaoPrefetchCache cache = this.getCache();
        boolean bl = hit = cache != null && cache.contains(key);
        if (hit) {
            cache.remove(key);
        }
        SecurityDaoDeferredQueue queue = this.getQueue();
        if (hit && queue != null) {
            queue.add(SecurityDaoDeferredCommand.delete(this.getRedisKey(key)));
        } else {
            this.delegate.delete(key);
        }
    }

    public long getTimeout(String key) {
        Long timeout;
        SecurityDaoPrefetchCache cache = this.getCache();
        if (cache != null && cache.contains(key) && (timeout = cache.getTimeout(key)) != null) {
            return timeout;
        }
        return this.delegate.getTimeout(key);
    }

    public void updateTimeout(String key, long timeout) {
        SecurityDaoPrefetchCache cache = this.getCache();
        SecurityDaoDeferredQueue queue = this.getQueue();
        if (queue != null && cache != null && cache.contains(key)) {
            queue.add(SecurityDaoDeferredCommand.setTimeout(this.getRedisKey(key), timeout));
        } else {
            this.delegate.updateTimeout(key, timeout);
        }
    }

    public <T> T getObject(String key) {
        SecurityDaoPrefetchCache cache = this.getCache();
        if (cache != null && cache.contains(key)) {
            return (T)cache.get(key);
        }
        return (T)this.delegate.getObject(key);
    }

    public void setObject(String key, Object object, long timeout) {
        boolean hit;
        SecurityDaoPrefetchCache cache = this.getCache();
        boolean bl = hit = cache != null && cache.contains(key);
        if (hit) {
            cache.set(key, object);
        }
        SecurityDaoDeferredQueue queue = this.getQueue();
        if (hit && queue != null) {
            queue.add(SecurityDaoDeferredCommand.setObject(this.getRedisKey(key), object, timeout));
        } else {
            this.delegate.setObject(key, object, timeout);
        }
    }

    public void updateObject(String key, Object object) {
        boolean hit;
        SecurityDaoPrefetchCache cache = this.getCache();
        boolean bl = hit = cache != null && cache.contains(key);
        if (hit) {
            cache.set(key, object);
        }
        SecurityDaoDeferredQueue queue = this.getQueue();
        if (hit && queue != null) {
            queue.add(SecurityDaoDeferredCommand.setObject(this.getRedisKey(key), object));
        } else {
            this.delegate.updateObject(key, object);
        }
    }

    public void deleteObject(String key) {
        boolean hit;
        SecurityDaoPrefetchCache cache = this.getCache();
        boolean bl = hit = cache != null && cache.contains(key);
        if (hit) {
            cache.remove(key);
        }
        SecurityDaoDeferredQueue queue = this.getQueue();
        if (hit && queue != null) {
            queue.add(SecurityDaoDeferredCommand.delete(this.getRedisKey(key)));
        } else {
            this.delegate.deleteObject(key);
        }
    }

    public long getObjectTimeout(String key) {
        Long timeout;
        SecurityDaoPrefetchCache cache = this.getCache();
        if (cache != null && cache.contains(key) && (timeout = cache.getTimeout(key)) != null) {
            return timeout;
        }
        return this.delegate.getObjectTimeout(key);
    }

    public void updateObjectTimeout(String key, long timeout) {
        SecurityDaoPrefetchCache cache = this.getCache();
        SecurityDaoDeferredQueue queue = this.getQueue();
        if (queue != null && cache != null && cache.contains(key)) {
            queue.add(SecurityDaoDeferredCommand.setTimeout(this.getRedisKey(key), timeout));
        } else {
            this.delegate.updateObjectTimeout(key, timeout);
        }
    }

    public List<String> searchData(String prefix, String keyword, int start, int size) {
        return this.delegate.searchData(prefix, keyword, start, size);
    }

    public void putSet(String key, Set<Object> values, long timeout) {
        SecurityDaoPrefetchCache cache = this.getCache();
        SecurityDaoDeferredQueue queue = this.getQueue();
        if (queue != null && cache != null && cache.contains(key)) {
            queue.add(SecurityDaoDeferredCommand.setObject(this.getRedisKey(key), values, timeout));
        } else {
            this.delegate.putSet(key, values, timeout);
        }
    }

    public void updateSet(String key, Set<Object> values) {
        SecurityDaoPrefetchCache cache = this.getCache();
        SecurityDaoDeferredQueue queue = this.getQueue();
        if (queue != null && cache != null && cache.contains(key)) {
            queue.add(SecurityDaoDeferredCommand.setObject(this.getRedisKey(key), values));
        } else {
            this.delegate.updateSet(key, values);
        }
    }

    public Boolean containsValue(String key, Object value) {
        SecurityDaoPrefetchCache cache = this.getCache();
        if (cache != null && cache.contains(key)) {
            Map result = (Map)cache.get(key);
            return (Boolean)result.get(value);
        }
        return this.delegate.containsValue(key, value);
    }

    public Set<Object> getSetObject(String key) {
        SecurityDaoPrefetchCache cache = this.getCache();
        if (cache != null && cache.contains(key)) {
            Map result = (Map)cache.get(key);
            return result.keySet();
        }
        return this.delegate.getSetObject(key);
    }

    public Map<Object, Boolean> containsValues(String key, List<Object> values) {
        SecurityDaoPrefetchCache cache = this.getCache();
        if (cache != null && cache.contains(key)) {
            Map cacheResult = (Map)cache.get(key);
            return values.stream().collect(Collectors.toMap(k -> k, k -> (Boolean)cacheResult.get(values)));
        }
        return this.delegate.containsValues(key, values);
    }

    public void updateKeyTimeout(String key, long timeout) {
        SecurityDaoPrefetchCache cache = this.getCache();
        SecurityDaoDeferredQueue queue = this.getQueue();
        if (queue != null && cache != null && cache.contains(key)) {
            queue.add(SecurityDaoDeferredCommand.setTimeout(this.getRedisKey(key), timeout));
        } else {
            this.delegate.updateKeyTimeout(key, timeout);
        }
    }

    private SecurityDaoPrefetchCache getCache() {
        Object rawPrefetchCache = this.context.getStorage().get("dao_prefetch_cache");
        if (rawPrefetchCache instanceof SecurityDaoPrefetchCache) {
            return (SecurityDaoPrefetchCache)rawPrefetchCache;
        }
        return null;
    }

    private SecurityDaoDeferredQueue getQueue() {
        Object rawDeferredQueue = this.context.getStorage().get("dao_deferred_queue");
        if (rawDeferredQueue instanceof SecurityDaoDeferredQueue) {
            return (SecurityDaoDeferredQueue)rawDeferredQueue;
        }
        return null;
    }

    private String getRedisKey(String key) {
        return this.properties.getTokenName() + "::" + key;
    }
}

