/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.hussar.support.security.plugin.dao.cache.defer;

import java.util.Arrays;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.data.redis.connection.RedisConnection;
import org.springframework.data.redis.connection.RedisStringCommands;
import org.springframework.data.redis.core.types.Expiration;
import org.springframework.data.redis.serializer.RedisSerializer;

public class SecurityDaoDeferredCommand {
    private static final Logger logger = LoggerFactory.getLogger(SecurityDaoDeferredCommand.class);
    private final CommandType command;
    private final Object[] arguments;
    private final boolean serialized;

    private SecurityDaoDeferredCommand(CommandType command, Object[] arguments) {
        this(command, arguments, false);
    }

    private SecurityDaoDeferredCommand(CommandType command, Object[] arguments, boolean serialized) {
        this.command = command;
        this.arguments = arguments;
        this.serialized = serialized;
    }

    public static SecurityDaoDeferredCommand set(String key, String value) {
        return new SecurityDaoDeferredCommand(CommandType.SET, new Object[]{key, value, null});
    }

    public static SecurityDaoDeferredCommand set(String key, String value, long timeout) {
        return new SecurityDaoDeferredCommand(CommandType.SET, new Object[]{key, value, timeout});
    }

    public static SecurityDaoDeferredCommand setObject(String key, Object value) {
        return new SecurityDaoDeferredCommand(CommandType.SET_OBJECT, new Object[]{key, value, null});
    }

    public static SecurityDaoDeferredCommand setObject(String key, Object value, long timeout) {
        return new SecurityDaoDeferredCommand(CommandType.SET_OBJECT, new Object[]{key, value, timeout});
    }

    public static SecurityDaoDeferredCommand setTimeout(String key, long timeout) {
        return new SecurityDaoDeferredCommand(CommandType.SET_TIMEOUT, new Object[]{key, timeout});
    }

    public static SecurityDaoDeferredCommand delete(String key) {
        return new SecurityDaoDeferredCommand(CommandType.DELETE, new Object[]{key});
    }

    public SecurityDaoDeferredCommand serialize(RedisSerializer<?> keySerializer, RedisSerializer<?> valueSerializer) {
        return this.doSerialize(keySerializer, valueSerializer);
    }

    private SecurityDaoDeferredCommand doSerialize(RedisSerializer<Object> keySerializer, RedisSerializer<Object> valueSerializer) {
        Object[] serializedArguments;
        if (this.serialized) {
            throw new IllegalArgumentException("Command cannot be serialized twice");
        }
        switch (this.command) {
            case SET: {
                serializedArguments = new Object[]{keySerializer.serialize((Object)this.argumentNotNull(0, String.class)), valueSerializer.serialize((Object)this.argumentNotNull(1, String.class)), this.argumentNullable(2, Long.class)};
                break;
            }
            case SET_OBJECT: {
                serializedArguments = new Object[]{keySerializer.serialize((Object)this.argumentNotNull(0, String.class)), valueSerializer.serialize(this.argumentNotNull(1, Object.class)), this.argumentNullable(2, Long.class)};
                break;
            }
            case SET_TIMEOUT: {
                serializedArguments = new Object[]{keySerializer.serialize((Object)this.argumentNotNull(0, String.class)), this.argumentNotNull(1, Long.class)};
                break;
            }
            case DELETE: {
                serializedArguments = new Object[]{keySerializer.serialize((Object)this.argumentNotNull(0, String.class))};
                break;
            }
            default: {
                throw new IllegalArgumentException("Unsupported command: " + (Object)((Object)this.command));
            }
        }
        return new SecurityDaoDeferredCommand(this.command, serializedArguments, true);
    }

    public void execute(RedisConnection connection) {
        if (!this.serialized) {
            throw new IllegalStateException("Command must be serialized before executing");
        }
        switch (this.command) {
            case SET: 
            case SET_OBJECT: {
                this.executeSet(connection);
                break;
            }
            case SET_TIMEOUT: {
                this.executeSetTimeout(connection);
                break;
            }
            case DELETE: {
                this.executeDelete(connection);
                break;
            }
            default: {
                logger.debug("Skip unrecognized deferred command: {}", (Object)this);
            }
        }
    }

    private void executeSet(RedisConnection connection) {
        logger.debug("Executing: {}", (Object)this);
        byte[] key = this.argumentNotNull(0, byte[].class);
        byte[] value = this.argumentNotNull(1, byte[].class);
        Long timeout = this.argumentNullable(2, Long.class);
        if (timeout == null || timeout < 0L) {
            connection.set(key, value);
        } else {
            connection.set(key, value, Expiration.seconds((long)timeout), RedisStringCommands.SetOption.upsert());
        }
    }

    private void executeSetTimeout(RedisConnection connection) {
        logger.debug("Executing: {}", (Object)this);
        byte[] key = this.argumentNotNull(0, byte[].class);
        long timeout = this.argumentNotNull(1, Long.class);
        if (timeout < 0L) {
            connection.persist(key);
        } else {
            connection.expire(key, timeout);
        }
    }

    private void executeDelete(RedisConnection connection) {
        logger.debug("Executing: {}", (Object)this);
        byte[] key = this.argumentNotNull(0, byte[].class);
        connection.del((byte[][])new byte[][]{key});
    }

    private <T> T argumentNotNull(int index, Class<T> clazz) {
        T argument = this.argumentNullable(index, clazz);
        if (argument == null) {
            throw new NullPointerException("Argument must not be null");
        }
        return argument;
    }

    private <T> T argumentNullable(int index, Class<T> clazz) {
        if (index < 0 || index >= this.arguments.length) {
            throw new IndexOutOfBoundsException("Index: " + index + ", Size: " + this.arguments.length);
        }
        Object argument = this.arguments[index];
        if (argument != null && !clazz.isInstance(argument)) {
            throw new ClassCastException("Argument " + index + " is not of type " + clazz);
        }
        return (T)argument;
    }

    public String toString() {
        return "SecurityDaoDeferredCommand[" + (Object)((Object)this.command) + ' ' + Arrays.toString(this.arguments) + ']';
    }

    private static enum CommandType {
        SET,
        SET_OBJECT,
        SET_TIMEOUT,
        DELETE;

    }
}

