/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.hussar.support.security.plugin.dao.cache.prefetch;

import com.jxdinfo.hussar.support.security.core.prefetch.SecurityDaoPrefetchCache;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;

public class SecurityDaoPrefetchCacheImpl
implements SecurityDaoPrefetchCache {
    private static final ConcurrentMap<String, Record> cache = new ConcurrentHashMap<String, Record>();

    public void clear() {
        cache.clear();
    }

    public boolean contains(String key) {
        return cache.get(key) != null;
    }

    public Set<String> keys() {
        return cache.keySet();
    }

    public <T> T get(String key) {
        Record record = (Record)cache.get(key);
        return (T)(record != null ? record.getValue() : null);
    }

    public Long getTimeout(String key) {
        Record record = (Record)cache.get(key);
        return record != null ? record.getTimeout() : null;
    }

    public <T> void set(String key, T value) {
        cache.put(key, Record.of(value));
    }

    public void setTimeout(String key, Long timeout) {
        Record record = (Record)cache.get(key);
        if (record != null) {
            record.setTimeout(timeout);
        }
    }

    public <T> void set(String key, T value, Long timeout) {
        cache.put(key, Record.of(value, timeout));
    }

    public void remove(String key) {
        cache.remove(key);
    }

    public String toString() {
        return "SecurityDaoPrefetchCache[" + cache + ']';
    }

    private static class Record {
        private Object value;
        private Long timeout;

        private Record() {
        }

        public static Record of(Object value) {
            Record record = new Record();
            record.setValue(value);
            return record;
        }

        public static Record of(Object value, Long ttl) {
            Record record = new Record();
            record.setValue(value);
            record.setTimeout(ttl);
            return record;
        }

        public Object getValue() {
            return this.value;
        }

        public void setValue(Object value) {
            this.value = value;
        }

        public Long getTimeout() {
            return this.timeout;
        }

        public void setTimeout(Long timeout) {
            this.timeout = timeout;
        }

        public String toString() {
            if (this.timeout != null) {
                return "Record[" + this.value + "; timeout=" + this.timeout + ']';
            }
            return "Record[" + this.value + ']';
        }
    }
}

