/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.hussar.support.security.plugin.dao.cache;

import com.jxdinfo.hussar.platform.core.utils.HussarUtils;
import com.jxdinfo.hussar.support.cache.util.HussarFixedCacheUtil;
import com.jxdinfo.hussar.support.security.core.tokenservice.SecurityTokenDao;
import com.jxdinfo.hussar.support.security.core.util.SecurityFoxUtil;
import com.jxdinfo.hussar.support.security.plugin.dao.cache.properties.SecurityCacheProperties;
import java.util.ArrayList;
import java.util.List;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class SecurityTokenDaoCacheImpl
implements SecurityTokenDao {
    public String SECURITY_TOKEN_CACHE_NAME;
    @Autowired
    public SecurityCacheProperties securityCacheProperties;

    public SecurityTokenDaoCacheImpl(SecurityCacheProperties securityCacheProperties) {
        this.SECURITY_TOKEN_CACHE_NAME = securityCacheProperties.getTokenName();
    }

    public String get(String key) {
        return (String)HussarFixedCacheUtil.get((String)this.SECURITY_TOKEN_CACHE_NAME, (Object)key);
    }

    public void set(String key, String value, long timeout) {
        HussarFixedCacheUtil.put((String)this.SECURITY_TOKEN_CACHE_NAME, (Object)key, (Object)value, (long)timeout);
    }

    public void update(String key, String value) {
        HussarFixedCacheUtil.put((String)this.SECURITY_TOKEN_CACHE_NAME, (Object)key, (Object)value);
    }

    public void delete(String key) {
        HussarFixedCacheUtil.evict((String)this.SECURITY_TOKEN_CACHE_NAME, (Object)key);
    }

    public long getTimeout(String key) {
        Long timeout = HussarFixedCacheUtil.getKeyExpireTime((String)this.SECURITY_TOKEN_CACHE_NAME, (String)key);
        if (timeout == null) {
            return -2L;
        }
        return timeout;
    }

    public void updateTimeout(String key, long timeout) {
        HussarFixedCacheUtil.put((String)this.SECURITY_TOKEN_CACHE_NAME, (Object)key, (Object)HussarFixedCacheUtil.get((String)this.SECURITY_TOKEN_CACHE_NAME, (Object)key), (long)timeout);
    }

    public Object getObject(String key) {
        return HussarFixedCacheUtil.get((String)this.SECURITY_TOKEN_CACHE_NAME, (Object)key);
    }

    public void setObject(String key, Object object, long timeout) {
        HussarFixedCacheUtil.put((String)this.SECURITY_TOKEN_CACHE_NAME, (Object)key, (Object)object, (long)timeout);
    }

    public void updateObject(String key, Object object) {
        HussarFixedCacheUtil.put((String)this.SECURITY_TOKEN_CACHE_NAME, (Object)key, (Object)object);
    }

    public void deleteObject(String key) {
        HussarFixedCacheUtil.evict((String)this.SECURITY_TOKEN_CACHE_NAME, (Object)key);
    }

    public long getObjectTimeout(String key) {
        Long timeout = HussarFixedCacheUtil.getKeyExpireTime((String)this.SECURITY_TOKEN_CACHE_NAME, (String)key);
        if (timeout == null) {
            return -2L;
        }
        return timeout;
    }

    public void updateObjectTimeout(String key, long timeout) {
        if (timeout == -1L) {
            long expire = this.getTimeout(key);
            if (expire != -1L) {
                this.set(key, this.get(key), timeout);
            }
            return;
        }
        if (HussarUtils.isNotEmpty((Object)HussarFixedCacheUtil.get((String)this.SECURITY_TOKEN_CACHE_NAME, (Object)key))) {
            HussarFixedCacheUtil.put((String)this.SECURITY_TOKEN_CACHE_NAME, (Object)key, (Object)HussarFixedCacheUtil.get((String)this.SECURITY_TOKEN_CACHE_NAME, (Object)key), (long)timeout);
        }
    }

    public List<String> searchData(String prefix, String keyword, int start, int size) {
        List keys = HussarFixedCacheUtil.getKeysLike((String)prefix, (String)keyword);
        ArrayList list = new ArrayList(keys);
        return SecurityFoxUtil.searchList(list, (int)start, (int)size);
    }
}

