/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.hussar.support.security.plugin.clientLogin.util;

import com.fasterxml.jackson.core.type.TypeReference;
import com.jxdinfo.hussar.platform.core.base.apiresult.ApiResponse;
import com.jxdinfo.hussar.platform.core.utils.HussarUtils;
import com.jxdinfo.hussar.platform.core.utils.JsonUtil;
import com.jxdinfo.hussar.support.cache.util.HussarCacheUtil;
import com.jxdinfo.hussar.support.exception.HussarException;
import java.util.Map;
import java.util.concurrent.TimeUnit;
import okhttp3.OkHttpClient;
import okhttp3.Request;
import okhttp3.Response;

public class HussarClientLoginUtils {
    private static final OkHttpClient client = new OkHttpClient.Builder().connectTimeout(5L, TimeUnit.SECONDS).writeTimeout(5L, TimeUnit.SECONDS).readTimeout(5L, TimeUnit.SECONDS).build();

    public static String getToken(String serverUrl, String clientId, String clientSecret) {
        return HussarClientLoginUtils.getToken(serverUrl, clientId, clientSecret, 120L);
    }

    public static String getToken(String serverUrl, String clientId, String clientSecret, long refreshTokenThreshold) {
        if (HussarUtils.isEmpty((Object)clientId)) {
            throw new HussarException("clientId\u4e0d\u80fd\u4e3a\u7a7a");
        }
        if (HussarUtils.isEmpty((Object)clientSecret)) {
            throw new HussarException("clientSecret\u4e0d\u80fd\u4e3a\u7a7a");
        }
        if (HussarUtils.isEmpty((Object)serverUrl)) {
            throw new HussarException("serverUrl\u4e0d\u80fd\u4e3a\u7a7a");
        }
        if (refreshTokenThreshold < 0L) {
            throw new HussarException("refreshTokenThreshold\u9700\u5927\u4e8e0");
        }
        String token = (String)HussarCacheUtil.get((String)"hussar_client_token", (Object)clientId);
        Boolean doClientLogin = false;
        if (HussarUtils.isEmpty((Object)token)) {
            doClientLogin = true;
        } else {
            Long expireTime = HussarCacheUtil.getKeyExpireTime((String)"hussar_client_token", (String)clientId);
            if (expireTime == null || expireTime < refreshTokenThreshold) {
                doClientLogin = true;
            }
        }
        if (doClientLogin.booleanValue()) {
            token = HussarClientLoginUtils.doClientLogin(serverUrl, clientId, clientSecret);
        }
        return token;
    }

    private static String doClientLogin(String serverUrl, String clientId, String clientSecret) {
        try {
            String url = serverUrl + "/oauth2/client_token?grant_type=client_credentials";
            Request request = new Request.Builder().url(url).addHeader("client-id", clientId).addHeader("client-secret", clientSecret).build();
            Response response = client.newCall(request).execute();
            if (!response.isSuccessful()) {
                throw new HussarException("\u5ba2\u6237\u7aef\u8ba4\u8bc1\u8bf7\u6c42\u5931\u8d25:" + response.message());
            }
            String resultStr = response.body().string();
            ApiResponse tokenResponse = (ApiResponse)JsonUtil.parse((String)resultStr, (TypeReference)new TypeReference<ApiResponse<Map<String, Object>>>(){});
            if (tokenResponse == null || !tokenResponse.isSuccess()) {
                throw new HussarException("\u5ba2\u6237\u7aef\u8ba4\u8bc1\u5931\u8d25:" + resultStr);
            }
            Map tokenMap = (Map)tokenResponse.getData();
            String token = (String)tokenMap.get("client-token");
            long expiresIn = Long.parseLong(tokenMap.get("expires-in").toString());
            HussarCacheUtil.put((String)"hussar_client_token", (Object)clientId, (Object)token, (long)expiresIn);
            return token;
        }
        catch (Exception e) {
            throw new HussarException("\u5ba2\u6237\u7aef\u8ba4\u8bc1\u5931\u8d25", (Throwable)e);
        }
    }
}

