/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.hussar.support.security.plugin.aop;

import com.jxdinfo.hussar.platform.core.utils.HussarUtils;
import com.jxdinfo.hussar.support.security.core.annotation.CheckDynamicPermission;
import com.jxdinfo.hussar.support.security.core.dto.DynamicPermissionDto;
import com.jxdinfo.hussar.support.security.core.strategy.SecurityStrategy;
import java.lang.reflect.AnnotatedElement;
import java.lang.reflect.Method;
import java.util.Collection;
import org.aopalliance.intercept.MethodInterceptor;
import org.aopalliance.intercept.MethodInvocation;
import org.springframework.context.expression.MethodBasedEvaluationContext;
import org.springframework.core.DefaultParameterNameDiscoverer;
import org.springframework.core.ParameterNameDiscoverer;
import org.springframework.core.annotation.AnnotatedElementUtils;
import org.springframework.expression.BeanResolver;
import org.springframework.expression.EvaluationContext;
import org.springframework.expression.ExpressionParser;
import org.springframework.expression.ParserContext;
import org.springframework.expression.spel.standard.SpelExpressionParser;

public class SecurityAuthorityInterceptor
implements MethodInterceptor {
    private static final ParameterNameDiscoverer NAME_DISCOVERER = new DefaultParameterNameDiscoverer();
    private static final ExpressionParser PARSER = new SpelExpressionParser();
    private final ParserContext parserContext = new ParserContext(){

        public boolean isTemplate() {
            return false;
        }

        public String getExpressionPrefix() {
            return null;
        }

        public String getExpressionSuffix() {
            return null;
        }
    };
    private BeanResolver beanResolver;

    public Object invoke(MethodInvocation invocation) throws Throwable {
        Method method = invocation.getMethod();
        if (AnnotatedElementUtils.hasAnnotation((AnnotatedElement)method, CheckDynamicPermission.class)) {
            SecurityStrategy.me.checkDynamicPermissionAnnotation.accept(this.getDynamicPermissions(invocation, method));
        }
        SecurityStrategy.me.checkMethodAnnotation.accept(method);
        Object obj = invocation.proceed();
        return obj;
    }

    private Object doDetermineDynamicPermission(MethodInvocation invocation, String key) {
        Method method = invocation.getMethod();
        Object[] arguments = invocation.getArguments();
        MethodBasedEvaluationContext context = new MethodBasedEvaluationContext(null, method, arguments, NAME_DISCOVERER);
        context.setBeanResolver(this.beanResolver);
        return PARSER.parseExpression(key, this.parserContext).getValue((EvaluationContext)context);
    }

    private DynamicPermissionDto getDynamicPermissions(MethodInvocation invocation, AnnotatedElement element) {
        DynamicPermissionDto dynamicPermissionDto = new DynamicPermissionDto();
        dynamicPermissionDto.setAnnotatedElement(element);
        CheckDynamicPermission checkDynamicPermission = element.getAnnotation(CheckDynamicPermission.class);
        String value = checkDynamicPermission.value();
        Object permissions = this.doDetermineDynamicPermission(invocation, value);
        if (HussarUtils.isEmpty((Object)permissions)) {
            return dynamicPermissionDto;
        }
        if (permissions instanceof Collection) {
            Collection collection = (Collection)permissions;
            dynamicPermissionDto.setDynamicPermissions(collection.toArray(new String[collection.size()]));
        } else if (permissions instanceof String[]) {
            dynamicPermissionDto.setDynamicPermissions((String[])permissions);
        } else {
            dynamicPermissionDto.setDynamicPermissions(new String[]{permissions.toString()});
        }
        return dynamicPermissionDto;
    }

    public void setBeanResolver(BeanResolver beanResolver) {
        this.beanResolver = beanResolver;
    }
}

